//---------------------------------------------------------------------------
#ifndef zokzok1H
#define zokzok1H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>


#include "oe_curve.h"
#include <Buttons.hpp>

//---------------------------------------------------------------------------
class TForm1 : public TForm
{

	public:
	oe_curve*		m_Curve;

	oe_curve**		m_Curves;
	int				m_CurvesNum;

	oe_curveList*	m_CurveList;	// must become plural

	oe_v3			m_ViewMin;
	oe_v3			m_ViewMax;
	oe_v3			m_ViewRng;
	int				m_ViewPortMin[3];
	int				m_ViewPortMax[3];
	int				m_ViewPortRng[3];
	oe_v3			m_ViewToViewPort;

	oe_scalar		m_TMin;
	oe_scalar		m_TMax;
	oe_scalar		m_TStp;

	oe_scalar		m_Zoom;
	oe_v3			m_Center;
	BOOL			m_Zooming;

	BOOL			m_DrawCurve;
	BOOL			m_DrawNormals;
	BOOL			m_DrawTangents;
	BOOL			m_DrawPedal;
	BOOL			m_DrawInversePedal;
	BOOL			m_DrawDoddle;
	BOOL			m_DrawEvolute;
	BOOL			m_DrawTangentEvolute;
	
	oe_scalar		m_ScaleTangents;
	oe_scalar		m_ScaleNormals;

	oe_v3			m_Q;
	BOOL			m_QMoving;

	void	DrawCurve		();
	void	DrawCurve1		();
	void	LoadCurve		(int i);
	void	DumpCurve		();

	void	LoadCurves		();
	void	DumpCurves		();
	void	CurvesNumSet	(int num);

	void	CurveSelect		(char* name);


	BOOL	ViewToViewPort	(oe_v3& pt, int& x, int& y);
	void	ViewPortToView	(oe_v3& pt, int& x, int& y);
	void	SetZoom			(oe_scalar	s);
	void	SetCenter		(oe_scalar	x, oe_scalar y);


__published:	// IDE-managed Components
	TPanel *Panel1;
	TSplitter *Splitter1;
	TPaintBox *PaintBox1;
	TPanel *Panel2;
	TSpeedButton *SpeedButton2;
	TSpeedButton *SpeedButton1;
	TCheckBox *CheckBox5;
	TCheckBox *CheckBox6;
	TCheckBox *CheckBox4;
	TCheckBox *CheckBox3;
	TCheckBox *CheckBox2;
	TCheckBox *CheckBox1;
	TPanel *Panel3;
	TMemo *Memo2;
	TMemo *Memo1;
	TPanel *Panel4;
	TComboBox *ComboBox1;
	TButton *Button1;
	TCheckBox *CheckBox7;
	TCheckBox *CheckBox8;
	void __fastcall PaintBox1Paint(TObject *Sender);
	void __fastcall CheckBox1Click(TObject *Sender);
	void __fastcall CheckBox2Click(TObject *Sender);
	void __fastcall CheckBox3Click(TObject *Sender);
	void __fastcall SpeedButton1Click(TObject *Sender);
	void __fastcall PaintBox1MouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
	void __fastcall SpeedButton2Click(TObject *Sender);
	void __fastcall PaintBox1MouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
	void __fastcall PaintBox1MouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
	void __fastcall ComboBox1Change(TObject *Sender);
	void __fastcall Button1Click(TObject *Sender);
private:	// User declarations
public:		// User declarations
	__fastcall TForm1(TComponent* Owner);
	__fastcall ~TForm1();

};



inline	BOOL	TForm1::ViewToViewPort(oe_v3& pt, int& x, int& y)
	{
	if (pt.Length() < 100000000.0) {
		x	=	(int)((pt.m_Value[0] - m_ViewMin.m_Value[0])*m_ViewToViewPort.m_Value[0]) + m_ViewPortMin[0];
		y	=	(int)((pt.m_Value[1] - m_ViewMin.m_Value[1])*m_ViewToViewPort.m_Value[1]) + m_ViewPortMin[1];
		return(1);
		}
	else {
		x	=	(int)((0.0 - m_ViewMin.m_Value[0])*m_ViewToViewPort.m_Value[0]) + m_ViewPortMin[0];
		y	=	(int)((0.0 - m_ViewMin.m_Value[1])*m_ViewToViewPort.m_Value[1]) + m_ViewPortMin[1];
		return(0);
		}
	}

inline	void	TForm1::ViewPortToView(oe_v3& pt, int& x, int& y)
	{
	pt.m_Value[0]	=	(oe_scalar)(x - m_ViewPortMin[0]) / (oe_scalar)m_ViewPortRng[0] * m_ViewRng.m_Value[0] + m_ViewMin.m_Value[0];
	pt.m_Value[1]	=	(oe_scalar)(y - m_ViewPortMin[1]) / (oe_scalar)m_ViewPortRng[1] * m_ViewRng.m_Value[1] + m_ViewMin.m_Value[1];
	}



//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
