//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "zokzok1.h"
#include "Unit2.h"

#include "oe_curveList1.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;


void	TForm1::CurvesNumSet(int num)
	{
	int	i;

	for (i = 0; i < m_CurvesNum; i++) {
		if (m_Curves[i]) {
			delete	m_Curves[i];
			m_Curves[i]	=	NULL;
			}
		}

	delete	[]	m_Curves;
	m_Curves	=	NULL;
	m_CurvesNum	=	0;

	m_Curves	=	new	oe_curve*[num];
	m_CurvesNum	=	num;
	for (i = 0; i < m_CurvesNum; i++) {
		m_Curves[i]	=	NULL;
		}
	}

void	TForm1::CurveSelect(char* name)
	{
	int	i;
	int	found;

	found	=	-1;
	for (i = 0; i < m_CurvesNum && found == -1; i++) {
		if (!stricmp(name, m_Curves[i] -> m_Name))
			found	=	i;
		}

	if (found != -1)
		LoadCurve(found);

	DrawCurve();
	}


void	TForm1::LoadCurves()
	{
	int	i, inum;

	if (m_CurveList)
		delete	m_CurveList;

	m_CurveList	=	new	oe_curveList1;

	inum	=	m_CurveList	->	m_CurvesNum;


	CurvesNumSet(inum);

	for (i = 0; i < inum; i++) {
		m_Curves[i]	=	m_CurveList -> m_Curves[i];
		}
		
 	// interface
	ComboBox1	->	Clear();
	for (i = 0; i < m_CurvesNum; i++) {
		ComboBox1	->	Items	->	Add(m_Curves[i] -> m_Name);
		}

	if (m_Curves[0])
		CurveSelect(m_Curves[0] -> m_Name);
	}

void	TForm1::DumpCurves()
	{
	CurvesNumSet(0);
	}

void	TForm1::DumpCurve()
	{
	if (m_Curve)
		delete	m_Curve;
	m_Curve	=	NULL;
	}

void	TForm1::LoadCurve(int i)
	{
	if (i < m_CurvesNum)
		m_Curve	=	m_Curves[i];
	else
		m_Curve	=	NULL;

	if (!m_Curve)
		return;

	m_Zooming	=	FALSE;
	SetZoom(1.0);
	SetCenter(0.0, 0.0);
	m_TMin		=	m_Curve	->	m_Sugg_TMin;
	m_TMax		=	m_Curve	->	m_Sugg_TMax;
	m_TStp		=	m_Curve	->	m_Sugg_TStp;

//	m_Q.Set(0,0,0);


	Memo1	->	SetTextBuf(m_Curve	->	m_Form);
	Memo2	->	SetTextBuf(m_Curve	->	m_Desc);
	}

void	TForm1::DrawCurve()
	{
	// clear
	TCanvas*	c;
	int			w;
	int			h;
	TRect		rect;

	c	=	PaintBox1	->	Canvas;
	if (!c)
		return;

	if (!m_Curve)
		return;

	// resize ?
	w	=	PaintBox1	->	Width;
	h	=	PaintBox1	->	Height;
	rect.Left	=	0;
	rect.Top	=	0;
	rect.Right	=	w;
	rect.Bottom	=	h;
	c	->	Brush	->	Color	=	0x00808080;
	c	->	FillRect(rect);


//	oe_curve*	yaya;
//	yaya	=	m_Curve;
//	int	i;
//	for (i = 0; i < m_CurveList -> m_CurvesNum; i++) {
//		m_Curve	=	m_CurveList -> m_Curves[i];
		DrawCurve1();
//		}
//
//	m_Curve = yaya;


	}

void	TForm1::DrawCurve1()
	{
	TCanvas*	c;
	int			w;
	int			h;
	TRect		rect;

	c	=	PaintBox1	->	Canvas;
	if (!c)
		return;

	if (!m_Curve)
		return;

	// resize ?
	w	=	PaintBox1	->	Width;
	h	=	PaintBox1	->	Height;

	m_ViewPortMin[0]	=	0;
	m_ViewPortMin[1]	=	h;
	m_ViewPortMin[2]	=	0;
	m_ViewPortMax[0]	=	w;
	m_ViewPortMax[1]	=	0;
	m_ViewPortMax[2]	=	0;
	m_ViewPortRng[0]	=	m_ViewPortMax[0] - m_ViewPortMin[0];
	m_ViewPortRng[1]	=	m_ViewPortMax[1] - m_ViewPortMin[1];
	m_ViewPortRng[2]	=	m_ViewPortMax[2] - m_ViewPortMin[2];
	m_ViewToViewPort.m_Value[0]	= (oe_scalar)(m_ViewPortRng[0]) / m_ViewRng.m_Value[0];
	m_ViewToViewPort.m_Value[1]	= (oe_scalar)(m_ViewPortRng[1]) / m_ViewRng.m_Value[1];
	m_ViewToViewPort.m_Value[2]	= (oe_scalar)(m_ViewPortRng[2]) / m_ViewRng.m_Value[2];

	m_DrawCurve				=	CheckBox1 -> Checked;
	m_DrawNormals			=	CheckBox2 -> Checked;
	m_DrawTangents			=	CheckBox3 -> Checked;
	m_DrawPedal				=	CheckBox4 -> Checked;
	m_DrawInversePedal		=	CheckBox8 -> Checked;
	m_DrawDoddle			=	CheckBox5 -> Checked;
	m_DrawEvolute			=	CheckBox6 -> Checked;
	m_DrawTangentEvolute	=	CheckBox7 -> Checked;

	oe_scalar	t;
	oe_v3		tp;
	oe_v3		tn;
	oe_v3		tt;
	oe_v3		tq;
	oe_v3		v;
	oe_scalar	s;

	oe_v3		tp_prev;
	oe_v3		tv_prev;

	tp.Set(0,0,0);
	tn.Set(0,0,0);
	tt.Set(0,0,0);
	tq.Set(0,0,0);


	int			tpx, tpy;
	int			tnx, tny;
	int			tqx, tqy;
	int			vx , vy ;
	int			vvx, vvy;
	int			jumpThresh	=	(h + w) / 2;	// pixels

	if (m_DrawNormals) {
		t	=	m_TMin;
		for (t = t; t <= m_TMax; t += m_TStp * 4) {
			m_Curve	->	GetPoint(t, tp);
			ViewToViewPort(tp, tpx, tpy);
			m_Curve	->	GetNormal(t, tn);
			tn *= 0.5 * m_ScaleNormals * 100.0;
			ViewToViewPort(tp + tn, tnx, tny);
			c	->	MoveTo(tnx, tny);
			ViewToViewPort(tp - tn, tnx, tny);
			c	->	Pen		->	Color	=	0x000000f0;
			c	->	LineTo(tpx, tpy);
			c	->	Pen		->	Color	=	0x000000d0;
			c	->	LineTo(tnx, tny);
			}
		}

	if (m_DrawTangents) {
		t	=	m_TMin;
		for (t = t; t <= m_TMax; t += m_TStp * 4) {
			m_Curve	->	GetPoint(t, tp);
			ViewToViewPort(tp, tpx, tpy);
			m_Curve	->	GetTangent(t, tn);
			tn *= 0.5 * m_ScaleTangents;
			ViewToViewPort(tp + tn, tnx, tny);
			c	->	MoveTo(tnx, tny);
			c	->	Pen		->	Color	=	0x00ffff00;
			c	->	LineTo(tpx, tpy);
			ViewToViewPort(tp - tn, tnx, tny);
			c	->	Pen		->	Color	=	0x0080ff00;
			c	->	LineTo(tnx, tny);
			}
		}

	if (m_DrawCurve) {
		c	->	Pen		->	Color	=	clWhite;
		t	=	m_TMin;
		m_Curve	->	GetPoint(t, tp);
		ViewToViewPort(tp, tpx, tpy);
		c	->	MoveTo(tpx, tpy);
		for (t = t; t <= m_TMax; t += m_TStp) {
			m_Curve	->	GetPoint(t, tp);
			ViewToViewPort(tp, tpx, tpy);
			if (abs(vvx - tpx) < jumpThresh && abs(vvy - tpy) < jumpThresh)
				c	->	LineTo(tpx, tpy);
			else
				c	->	MoveTo(tpx, tpy);
			vvx		=	tpx;
			vvy		=	tpy;
//			c	->	LineTo(tpx, tpy);
			}
		}

	if (m_DrawPedal) {
		c	->	Pen		->	Color	=	0x0000ffff;

		// First, draw Q.
		ViewToViewPort(m_Q, tqx, tqy);
		c	->	Ellipse(tqx - 5, tqy - 5, tqx + 5, tqy + 5);

		t	=	m_TMin;
		m_Curve	->	GetPoint(t, tp);
		m_Curve	->	GetTangent(t, tt);
		m_Q.ClosestPointOnLine2D(tp, tt, tq);
		ViewToViewPort(tq, tqx, tqy);
		c	->	MoveTo(tqx, tqy);
		for (t = t; t <= m_TMax; t += m_TStp) {
			m_Curve	->	GetPoint	(t, tp);
			m_Curve	->	GetTangent	(t, tt);
			m_Q.ClosestPointOnLine2D(tp, tt, tq);
			if (ViewToViewPort		(tq, tqx, tqy)) {
				c	->	LineTo			(tqx, tqy);
				}
			}
		}

	if (m_DrawInversePedal) {
		c	->	Pen		->	Color	=	0x0000ccff;

		ViewToViewPort(m_Q, tqx, tqy);
		c	->	Ellipse(tqx - 5, tqy - 5, tqx + 5, tqy + 5);

		t	=	m_TMin;
		m_Curve	->	GetPoint	(t, tp);
//		m_Curve	->	GetNormal	(t, tn);
		tp.Minus(m_Q, tn);
		s				=	 tn.m_Value[0];
		tn.m_Value[0]	=	-tn.m_Value[1];
		tn.m_Value[1]	=	 s;

		tp_prev	=	tp;
		tv_prev	=	tn;
		t	+=	m_TStp;
		m_Curve	->	GetPoint	(t, tp);
//		m_Curve	->	GetNormal	(t, tn);
		tp.Minus2D(m_Q, tn);
		s				=	 tn.m_Value[0];
		tn.m_Value[0]	=	-tn.m_Value[1];
		tn.m_Value[1]	=	 s;


		v	.	LineIntersection2D(tp, tn, tp_prev, tv_prev);
		ViewToViewPort(v, vx, vy);
		c	->	MoveTo(vx, vy);
		vvx	=	vx;
		vvy	=	vy;

		for (t = t; t <= m_TMax; t += m_TStp) {
			m_Curve	->	GetPoint	(t, tp);
//			m_Curve	->	GetNormal	(t, tn);
			tp.Minus2D(m_Q, tn);
			s				=	 tn.m_Value[0];
			tn.m_Value[0]	=	-tn.m_Value[1];
			tn.m_Value[1]	=	 s;

			v	.	LineIntersection2D(tp, tn, tp_prev, tv_prev);
			if (ViewToViewPort(v, vx, vy)) {
				if (abs(vvx - vx) < jumpThresh && abs(vvy - vy) < jumpThresh)
					c	->	LineTo(vx, vy);
				else
					c	->	MoveTo(vx, vy);
				vvx		=	vx;
				vvy		=	vy;
				}
			tp_prev	=	tp;
			tv_prev	=	tn;
			}
		}

	if (m_DrawEvolute) {
		c	->	Pen		->	Color	=	0x0000ffdd;

		t	=	m_TMin;
		m_Curve	->	GetPoint	(t, tp);
		m_Curve	->	GetNormal	(t, tn);
		tp_prev	=	tp;
		tv_prev	=	tn;
		t	+=	m_TStp;
		m_Curve	->	GetPoint	(t, tp);
		m_Curve	->	GetNormal	(t, tn);
		v	.	LineIntersection2D(tp, tn, tp_prev, tv_prev);
		ViewToViewPort(v, vx, vy);
		c	->	MoveTo(vx, vy);
		vvx	=	vx;
		vvy	=	vy;

		for (t = t; t <= m_TMax; t += m_TStp) {
			m_Curve	->	GetPoint	(t, tp);
			m_Curve	->	GetNormal	(t, tn);
			v	.	LineIntersection2D(tp, tn, tp_prev, tv_prev);
			if (ViewToViewPort(v, vx, vy)) {
				if (abs(vvx - vx) < jumpThresh && abs(vvy - vy) < jumpThresh)
					c	->	LineTo(vx, vy);
				else
					c	->	MoveTo(vx, vy);
				vvx		=	vx;
				vvy		=	vy;
				}
			tp_prev	=	tp;
			tv_prev	=	tn;
			}
		}

	if (m_DrawDoddle) {
		c	->	Pen		->	Color	=	0x00ffff00;

		// First, draw Q.
		ViewToViewPort(m_Q, tqx, tqy);
		c	->	Ellipse(tqx - 5, tqy - 5, tqx + 5, tqy + 5);

		t	=	m_TMin;
		m_Curve	->	GetPoint(t, tp);
		m_Curve	->	GetNormal(t, tn);
		m_Q.ClosestPointOnLine2D(tp, tn, tq);
		ViewToViewPort(tq, tqx, tqy);
		c	->	MoveTo(tqx, tqy);
		for (t = t; t <= m_TMax; t += m_TStp) {
			m_Curve	->	GetPoint	(t, tp);
			m_Curve	->	GetNormal	(t, tn);
			m_Q.ClosestPointOnLine2D(tp, tn, tq);
			if (ViewToViewPort		(tq, tqx, tqy)) {
				if (abs(vvx - tqx) < jumpThresh && abs(vvy - tqy) < jumpThresh)
					c	->	LineTo(tqx, tqy);
				else
					c	->	MoveTo(tqx, tqy);
				vvx		=	tqx;
				vvy		=	tqy;
				}
			}
		}

	}

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
	m_Curve	=	NULL;

	m_DrawCurve		=	TRUE;
	m_DrawNormals	=	TRUE;
	m_DrawTangents	=	TRUE;

	m_ScaleNormals	=	0.5;
	m_ScaleTangents	=	1;

	m_QMoving		=	FALSE;

	m_Curves		=	NULL;
	m_CurvesNum		=	0;

	m_CurveList		=	NULL;

	LoadCurves();
}

__fastcall TForm1::~TForm1()
{
	DumpCurves();
}


//---------------------------------------------------------------------------
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
	DrawCurve();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
	DrawCurve();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox2Click(TObject *Sender)
{
	DrawCurve();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox3Click(TObject *Sender)
{
	DrawCurve();
}

void	TForm1::SetZoom(oe_scalar s)
	{
	if (s == 0.0)
		return;

	m_Zoom		=	s;


	// get the base
	oe_v3	center;
	oe_v3	v;
	m_ViewMin	=	m_Curve	->	m_Sugg_ViewMin;
	m_ViewMax	=	m_Curve	->	m_Sugg_ViewMax;
	m_ViewRng	=	m_ViewMax - m_ViewMin;
	center		=	(m_ViewMin + m_ViewMax) * 0.5;
	v			=	m_ViewRng / (m_Zoom * 2);
	center		+=	m_Center;
	m_ViewMin	=	center	- v;
	m_ViewMax	=	center	+ v;
	m_ViewRng	=	m_ViewMax - m_ViewMin;

	}

void	TForm1::SetCenter(oe_scalar x, oe_scalar y)
	{
	m_Center.Set(x, y, 0);
	SetZoom(m_Zoom);
	}

//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton1Click(TObject *Sender)
{
	m_Zooming	=	!m_Zooming;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::PaintBox1MouseDown(TObject *Sender,
	  TMouseButton Button, TShiftState Shift, int X, int Y)
{
	oe_v3	v;

	if (m_Zooming) {
		if (Button == mbLeft)
			SetZoom(m_Zoom * 1.25);
		else if (Button == mbRight)
			SetZoom(m_Zoom / 1.5);

		ViewPortToView(v, X, Y);
		SetCenter(v.m_Value[0], v.m_Value[1]);
		DrawCurve();
		}
	else {
		m_QMoving = TRUE;
		ViewPortToView(m_Q, X, Y);
		DrawCurve();
		}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton2Click(TObject *Sender)
{
	m_Zooming		=	FALSE;
	SetZoom		(1.0);
	SetCenter	(0.0, 0.0);
	DrawCurve	();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PaintBox1MouseMove(TObject *Sender,
	  TShiftState Shift, int X, int Y)
{
	if (!m_Zooming) {
		if (m_QMoving) {
			ViewPortToView(m_Q, X, Y);
			DrawCurve();
			}
		}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PaintBox1MouseUp(TObject *Sender,
	  TMouseButton Button, TShiftState Shift, int X, int Y)
{
	m_QMoving = FALSE;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox1Change(TObject *Sender)
{
	TComboBox*	sender	=	(TComboBox*)Sender;

	int	i;

	i	=	sender -> ItemIndex;
	if (i >= 0)
		CurveSelect(sender -> Items -> Strings[i].c_str());
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
	static	TForm2*	y = NULL;

	if (!y) {
		y = new TForm2(this);
		y -> Width = 20;
		}

	y	->	Show();

}
//---------------------------------------------------------------------------

