/*

oe_curve_list1.cpp

*/


#include "oe_curveList1.h"


oe_curveList1::oe_curveList1()
	{
	int	i;

	SetName("First Curve Set");
	SetDesc("Simple curves");
	SetAuth("Doc Ocelot 19991126");

	CurvesNumSet(16);

	i = 0;
	m_Curves[i++]	=	new	oe_curve_circle;
	m_Curves[i++]	=	new	oe_curve_line;
	m_Curves[i++]	=	new	oe_curve_sine;
	m_Curves[i++]	=	new	oe_curve_tangent;
	m_Curves[i++]	=	new	oe_curve_polynomial5;
	m_Curves[i++]	=	new	oe_curve_hyperbola;
	m_Curves[i++]	=	new	oe_curve_lissajous;
	m_Curves[i++]	=	new	oe_curve_clover;
	m_Curves[i++]	=	new	oe_curve_freethsnephroid;
	m_Curves[i++]	=	new	oe_curve_spiral1;
	m_Curves[i++]	=	new	oe_curve_exponent;
	m_Curves[i++]	=	new	oe_curve_wacky1;
	m_Curves[i++]	=	new	oe_curve_SpiralFermat;
	m_Curves[i++]	=	new	oe_curve_SpiralFermat_2;
	m_Curves[i++]	=	new	oe_curve_SpiralHyperbolic;
	m_Curves[i++]	=	new	oe_curve_Cardiod;
	}

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_circle::oe_curve_circle()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.14159265359 * 2;
	m_Sugg_TMax		=	 3.14159265359 * 2;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(-3, -3, -1);
	m_Sugg_ViewMax.Set	( 3,  3,  1);

	SetName("Circle");
	SetForm("r = 1\ntheta = t");
	SetDesc("A Circle");
	}

void	oe_curve_circle::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	r	=	1.0;

	PolarToRectangular_Point(r, t, dst);
	}

void	oe_curve_circle::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	r	=	1.0;

	PolarToRectangular_Tangent(r, t, 0, 1, dst);
	dst.Norm2D(dst);
	}


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_line::oe_curve_line()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-1;
	m_Sugg_TMax		=	 1;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(m_Sugg_TMin * 1.1, m_Sugg_TMin * 1.1, -1);
	m_Sugg_ViewMax.Set	(m_Sugg_TMax * 1.1, m_Sugg_TMax * 1.1,  1);

	SetName("Line");
	SetForm("x = t\ny = 0");
	SetDesc("A line.");
	}

void	oe_curve_line::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	t;
	dst.m_Value[1]	=	0;
	}

void	oe_curve_line::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	1.0;
	dst.m_Value[1]	=	0;
//	dst.Norm2D(dst);
	}


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_sine::oe_curve_sine()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.14159265359 * 2;
	m_Sugg_TMax		=	 3.14159265359 * 2;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(m_Sugg_TMin * 1.1, m_Sugg_TMin * 1.1, -1);
	m_Sugg_ViewMax.Set	(m_Sugg_TMax * 1.1, m_Sugg_TMax * 1.1,  1);

	SetName("Sine");
	SetForm("x = t\ny= sin(t)");
	SetDesc("A Sine Wave");
	}

void	oe_curve_sine::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	t;
	dst.m_Value[1]	=	sin(t);
	}

void	oe_curve_sine::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	1;
	dst.m_Value[1]	=	cos(t);
	dst.Norm2D(dst);
	}


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_tangent::oe_curve_tangent()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.14159265359 * 1.2;
	m_Sugg_TMax		=	 3.14159265359 * 1.2;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(m_Sugg_TMin * 1.1, m_Sugg_TMin * 1.1, -1);
	m_Sugg_ViewMax.Set	(m_Sugg_TMax * 1.1, m_Sugg_TMax * 1.1,  1);

	SetName("Tangent");
	SetForm("x = t\ny = tan(t)");
	SetDesc("AKA sin/cos");
	}

void	oe_curve_tangent::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	t;
	dst.m_Value[1]	=	tan(t);
	}

void	oe_curve_tangent::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	1;
	dst.m_Value[1]	=	1.0/(cos(t)*cos(t));
	dst.Norm2D(dst);
	}


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_polynomial5::oe_curve_polynomial5()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-8;
	m_Sugg_TMax		=	 8;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(m_Sugg_TMin * 1.1, m_Sugg_TMin * 1.1, -1);
	m_Sugg_ViewMax.Set	(m_Sugg_TMax * 1.1, m_Sugg_TMax * 1.1,  1);

	SetName("Polynomial (5th degree)");
	SetForm("x = t\ny = a + b*t + c*t^2 + d*t^3 + e*t^4 + f*t^5");
	SetDesc("La La");
	}

void	oe_curve_polynomial5::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	int			i;
	int			j;
	int			order = 6;
	oe_scalar	n[6];
	oe_scalar	s;

	n[0]	=	0;
	n[1]	=	0.0;
	n[2]	=	1.0/2.0;
	n[3]	=	0.0/30.0;
	n[4]	=	0.0/40.0;
	n[5]	=	0.0/500.0;

	dst.m_Value[0]	=	t;
	dst.m_Value[1]	=	0;
	for (i = 0; i < order; i++) {
		s	=	1;
		for (j = 0; j < i; j++) {
			s *=	t;
			}
		dst.m_Value[1]	+=	n[i] * s;
		}
	}

void	oe_curve_polynomial5::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	int			i;
	int			j;
	int			order = 6;
	oe_scalar	n[6];
	oe_scalar	s;

	n[0]	=	0;
	n[1]	=	0.0;
	n[2]	=	1.0/2.0;
	n[3]	=	0.0/30.0;
	n[4]	=	0.0/40.0;
	n[5]	=	0.0/500.0;

	dst.m_Value[0]	=	1;
	dst.m_Value[1]	=	0;
	for (i = 0; i < order; i++) {
		s	=	1;
		for (j = 1; j < i; j++) {
			s *=	t;
			}
		dst.m_Value[1]	+=	n[i] * i * s;
		}

	dst.Norm2D(dst);
	}


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_hyperbola::oe_curve_hyperbola()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3;
	m_Sugg_TMax		=	 3;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(m_Sugg_TMin * 1.1, m_Sugg_TMin * 1.1, -1);
	m_Sugg_ViewMax.Set	(m_Sugg_TMax * 1.1, m_Sugg_TMax * 1.1,  1);

	SetName("Hyperbola");
	SetForm("x = t\ny = 1/t");
	SetDesc("La La");
	}

void	oe_curve_hyperbola::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	t;
	if (t != 0.0)
		dst.m_Value[1]	=	1/t;
	else
		dst.m_Value[1]	=	0;
	}

void	oe_curve_hyperbola::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	1;
	if (t != 0.0)
		dst.m_Value[1]	=	-1/(t*t);
	else
		dst.m_Value[1]	=	0;
	dst.Norm2D(dst);
	}

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_lissajous::oe_curve_lissajous()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.14159265359;
	m_Sugg_TMax		=	 3.14159265359;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(-2, -2, -1);
	m_Sugg_ViewMax.Set	( 2,  2,  1);

	SetName("lissajous");
	SetForm("x = cos(a*t)\ny = sin(b*t)");
	SetDesc("La La");
	}

void	oe_curve_lissajous::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a	=	1;
	oe_scalar	b	=	2;

	dst.m_Value[0]	=	cos(a * t);
	dst.m_Value[1]	=	sin(b * t);
	}

void	oe_curve_lissajous::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a	=	1;
	oe_scalar	b	=	2;

	dst.m_Value[0]	=	-a*sin(a * t);
	dst.m_Value[1]	=	 b*cos(b * t);
	dst.Norm2D(dst);
	}


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_clover::oe_curve_clover()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.14159265359;
	m_Sugg_TMax		=	 3.14159265359;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 500.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(-4, -4, -1);
	m_Sugg_ViewMax.Set	( 4,  4,  1);

	SetName("Clover");
	SetForm("r = sin(n * t) + m\ntheta = t");
	SetDesc("Nice");
	}

void	oe_curve_clover::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	m;
	oe_scalar	n;

	m				=	5;
	n				=	1.4;
	PolarToRectangular_Point(0.4*sin(m*t) + n, t, dst);
	}

void	oe_curve_clover::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	m;
	oe_scalar	n;


	// clover
	m				=	5;
	n				=	1.4;

	PolarToRectangular_Tangent(0.4*sin(m*t) + n, t, 0.4 * m * cos(m*t), 1.0, dst);
	dst.Norm2D(dst);
	}


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_freethsnephroid::oe_curve_freethsnephroid()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.14159265359 * 2;
	m_Sugg_TMax		=	 3.14159265359 * 2;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(-5, -4, -1);
	m_Sugg_ViewMax.Set	( 3,  4,  1);

	SetName("Freeth's Nephroid");
	SetForm("r = a * (1 + 2 * sin (t/2))");
	SetDesc("Nice, hah?");
	}

void	oe_curve_freethsnephroid::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1;

	PolarToRectangular_Point(a * (1.0 + 2.0*sin(t/2.0)), t, dst);
	}

void	oe_curve_freethsnephroid::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1;

	PolarToRectangular_Tangent(a * (1.0 + 2.0*sin(t/2.0)), t, a * cos(t * 0.5), 1.0, dst);

	dst.Norm2D(dst);
	}

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_spiral1::oe_curve_spiral1()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.14159265359 * 0;
	m_Sugg_TMax		=	 3.14159265359 * 6;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(-20, -20, -1);
	m_Sugg_ViewMax.Set	( 20,  20,  1);

	SetName("Spiral 1");
	SetForm("r = t\ntheta = t");
	SetDesc("I'm not sure of the formal name for this spiral.");
	}

void	oe_curve_spiral1::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1;

	PolarToRectangular_Point(a * t, t, dst);
	}

void	oe_curve_spiral1::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1;

	PolarToRectangular_Tangent(a * t, t, a, 1.0, dst);

	dst.Norm2D(dst);
	}





////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_exponent::oe_curve_exponent()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-7;
	m_Sugg_TMax		=	 4;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(m_Sugg_TMin * 1.8, m_Sugg_TMin * 1.8 + 8, -1);
	m_Sugg_ViewMax.Set	(m_Sugg_TMax * 1.8, m_Sugg_TMax * 1.8 + 8,  1);

	SetName("Exponent");
	SetForm("x = t\ny = e^t");
	SetDesc("La La");
	}

void	oe_curve_exponent::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	t;
	dst.m_Value[1]	=	exp(t);
	}

void	oe_curve_exponent::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	1;
	dst.m_Value[1]	=	exp(t);
	dst.Norm2D(dst);
	}


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_wacky1::oe_curve_wacky1()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.0;
	m_Sugg_TMax		=	 3.0;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 800.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(m_Sugg_TMin * 1.1, m_Sugg_TMin * 1.1 + 2, -1);
	m_Sugg_ViewMax.Set	(m_Sugg_TMax * 1.1, m_Sugg_TMax * 1.1 + 2,  1);

	SetName("Wacky 1");
	SetForm("x = t\ny = 1 / (a + t^2)");
	SetDesc("I think this might be the witch of agnesi.\nI find this curve interesting because the doddle and the pedal seem to line up more than usual.");
	}

void	oe_curve_wacky1::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	t;
	dst.m_Value[1]	=	1.0 / (.3 + t * t);
	}

void	oe_curve_wacky1::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	dst.m_Value[0]	=	1.0;
	dst.m_Value[1]	=	-2.0 * t /((.3 + t * t) * (.3 + t * t));
	dst.Norm2D(dst);
	}


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_SpiralFermat::oe_curve_SpiralFermat()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.14159265359 * 0;
	m_Sugg_TMax		=	 3.14159265359 * 1.5;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(-15, -15, -1);
	m_Sugg_ViewMax.Set	( 15,  15,  1);

	SetName("Fermat's Spiral");
	SetForm("r^2 = a^2 * theta\ntheta = t");
	SetDesc("Fermat's Spiral.\n(Implemented as theta = r^2/a^2)");
	}

void	oe_curve_SpiralFermat::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1;

	PolarToRectangular_Point(t, t*t/(a*a), dst);
	}

void	oe_curve_SpiralFermat::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1;

	PolarToRectangular_Tangent(t, t*t/(a*a), 1.0, 2.0*t/(a*a), dst);

	dst.Norm2D(dst);
	}

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_SpiralFermat_2::oe_curve_SpiralFermat_2()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	 0.001;
	m_Sugg_TMax		=	 3.14159265359 * 7;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(-15, -15, -1);
	m_Sugg_ViewMax.Set	( 15,  15,  1);

	SetName("Fermat's Spiral (2)");
	SetForm("r^2 = a^2 * theta\ntheta = t");
	SetDesc("Fermat's Spiral.\n(Implemented as r = a*sqrt(theta) )");
	}

void	oe_curve_SpiralFermat_2::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1;

	PolarToRectangular_Point( a * sqrt( t), t, dst);
	}

void	oe_curve_SpiralFermat_2::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1;

	PolarToRectangular_Tangent( a * sqrt( t), t,  a / (2.0*sqrt( t)), 1.0, dst);

	dst.Norm2D(dst);
	}



////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_SpiralHyperbolic::oe_curve_SpiralHyperbolic()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	 0.3;
	m_Sugg_TMax		=	 3.14159265359 * 10;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(-3, -3, -1);
	m_Sugg_ViewMax.Set	( 3,  3,  1);

	SetName("Hyperbolic Spiral");
	SetForm("r = a / theta\ntheta = t");
	SetDesc("Hyperbolic Spiral");
	}

void	oe_curve_SpiralHyperbolic::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1;

	PolarToRectangular_Point(a/t, t, dst);
	}

void	oe_curve_SpiralHyperbolic::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1;

	PolarToRectangular_Tangent( a / t, t,  -a / (t * t), 1.0, dst);

	dst.Norm2D(dst);
	}

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

oe_curve_Cardiod::oe_curve_Cardiod()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.14159265359 * 1.0;
	m_Sugg_TMax		=	 3.14159265359 * 1.0;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(-4.3, -4.3, -1);
	m_Sugg_ViewMax.Set	( 4.3,  4.3,  1);

	SetName("Cardiod");
	SetForm("r = 2 * (1 + cos(a*theta))\ntheta = t");
	SetDesc("oop oop a doop");
	}

void	oe_curve_Cardiod::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1.0;

	PolarToRectangular_Point(2.0 * (1.0 + cos(a*t)), t, dst);
	}

void	oe_curve_Cardiod::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	a;

	a = 1.0;

	PolarToRectangular_Tangent(2.0 * (1.0 + cos(a*t)), t, -2.0 * a * sin(a*t), 1.0, dst);

	dst.Norm2D(dst);
	}






/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/

