/*

oe_curve.h

base class for a curve.

*/

#ifndef _OE_CURVE_H_
#define _OE_CURVE_H_


typedef	double	oe_scalar;
#define	OE_SCALAR

#include "oe_v3.h"
#include "string.h"

enum {
	OE_CURVEPARAM_REAL,
	OE_CURVEPARAM_INTEGER,
	};

void	oe_curve_strncpy(char* dst, char* src, int n)
	{
	int	i;
	int	j;

	j = 0;
	for (i = 0; i < n && src[j] != '\0'; i++) {
		if (src[j] == '\n') {
			dst[i++] =	13;
			dst[i] =	10;
			}
		else
			dst[i] =	src[j];
		j++;
		}
	dst[i]	=	'\0';
	}

class	oe_curve_param
	{
	public:
	char		m_Name	[32 ];		// name
	char		m_Desc	[256];		// description

	oe_scalar	m_Value;
	oe_scalar	m_Min;
	oe_scalar	m_Max;
	int			m_Type;

	oe_curve_param()
	  {
	  SetName	("default");
	  SetDesc	("default");
	  SetValue	(1.0);
	  };

	void	SetName	(char* s)		{oe_curve_strncpy(m_Name, s, 31);	}
	void	SetDesc	(char* s)		{oe_curve_strncpy(m_Desc, s, 255);	}
	void	SetValue(oe_scalar s)	{m_Value	=	s;			}
	void	SetMin	(oe_scalar s)	{m_Min		=	s;			}
	void	SetMax	(oe_scalar s)	{m_Max		=	s;			}
	void	SetType	(int t)			{m_Type		=	t;			}
	};

class	oe_curve
	{
	public:

	oe_curve_param*	m_Params;
	int				m_ParamsNum;
	oe_scalar		m_Sugg_TMin;
	oe_scalar		m_Sugg_TMax;
	oe_scalar		m_Sugg_TStp;
	oe_v3			m_Sugg_ViewMin;
	oe_v3			m_Sugg_ViewMax;

	char			m_Name	[32 ];		// name
	char			m_Form	[128];		// formula
	char			m_Desc	[256];		// description

					oe_curve();
	~				oe_curve();

	int				ParamsNumSet(int n);

	void			SetName	(char* s)		{oe_curve_strncpy(m_Name, s, 31);	}
	void			SetForm	(char* s)		{oe_curve_strncpy(m_Form, s, 127);	}
	void			SetDesc	(char* s)		{oe_curve_strncpy(m_Desc, s, 255);	}

	void			PolarToRectangular_Point	(oe_scalar r, oe_scalar theta, oe_v3& dst);
	void			PolarToRectangular_Tangent	(oe_scalar r, oe_scalar theta, oe_scalar dr, oe_scalar dtheta, oe_v3& dst);

	virtual	void	GetPoint	(oe_scalar	t, oe_v3& dst);
	virtual	void	GetTangent	(oe_scalar	t, oe_v3& dst);
	virtual	void	GetNormal	(oe_scalar	t, oe_v3& dst);
	};


class	oe_curveList
	{
	public:

	oe_curve**	m_Curves;
	int		  	m_CurvesNum;

	char	  	m_Name[64	];
	char	  	m_Desc[256	];
	char		m_Auth[32	];


				oe_curveList	();
	~			oe_curveList	();

	void		SetName			(char* s)		{oe_curve_strncpy(m_Name, s, 63);	}
	void		SetDesc			(char* s)		{oe_curve_strncpy(m_Desc, s, 255);	}
	void		SetAuth			(char* s)		{oe_curve_strncpy(m_Auth, s, 31);	}

	void		CurvesNumSet	(int num);
	};



// convenience function
inline	void	oe_curve::PolarToRectangular_Point(oe_scalar r, oe_scalar theta, oe_v3& dst)
	{
	dst.m_Value[0] = r * cos(theta);
	dst.m_Value[1] = r * sin(theta);
	}

// convenience function
inline	void	oe_curve::PolarToRectangular_Tangent(oe_scalar r, oe_scalar theta, oe_scalar dr, oe_scalar dtheta, oe_v3& dst)
	{
	oe_scalar	s;
	oe_scalar	c;

	s	=	sin(theta);
	c	=	cos(theta);

	dst.m_Value[0]	=	r * -1.0 * dtheta * s + dr * c;
	dst.m_Value[1]	=	r *        dtheta * c + dr * s;
	}



#endif	// _OE_CURVE_H_
