/*

oe_curve.cpp

base class for a curve.

*/


#include <math.h>
#include "oe_curve.h"

oe_curveList::oe_curveList()
	{
	m_Curves	=	NULL;
	m_CurvesNum	=	0;

	SetName("Empty");
	SetDesc("Nothing Much");
	SetAuth("Nobody");
	}

oe_curveList::~oe_curveList()
	{
	CurvesNumSet(0);
	}

void	oe_curveList::CurvesNumSet(int num)
	{
	int	i;

	if (m_CurvesNum > 0) {
		for (i = 0; i < m_CurvesNum; i++) {
			delete	m_Curves[i];
			m_Curves[i]	=	NULL;
			}
		delete	[]	m_Curves;
		m_Curves	=	NULL;
		m_CurvesNum	=	0;
		}

	if (num > 0) {
		m_Curves	=	new	oe_curve*[num];
		m_CurvesNum	=	num;
		for (i = 0; i < m_CurvesNum; i++) {
			m_Curves[i]	=	NULL;
			}
		}
	}


/////////////////////////////////////////////////////////////////////////




int	oe_curve::ParamsNumSet(int n)
	{
	if (m_Params) {
		delete	[]	m_Params;
		}

	m_Params	=	NULL;
	m_ParamsNum	=	0;

	if (n > 0) {
		m_Params	=	new oe_curve_param[n];
		m_ParamsNum	=	n;
		}

	return 0;
	}


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
// Non-Critical Virtual Functions
void	oe_curve::GetNormal	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	tmp;

	GetTangent(t, dst);
	tmp				=	dst.m_Value[0];
	dst.m_Value[0]	=	dst.m_Value[1];
	dst.m_Value[1]	=	-tmp;
	}

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
// Critical Virtual Functions
oe_curve::oe_curve()
	{
	m_Params	= NULL	;
	m_ParamsNum	=	0	;

	m_Sugg_TMin		=	-3.14159265359;
	m_Sugg_TMax		=	 3.14159265359;
	m_Sugg_TStp		=	 (m_Sugg_TMax - m_Sugg_TMin) / 300.0;
	m_Sugg_TMax		+=	 m_Sugg_TStp;
	m_Sugg_ViewMin.Set	(-4, -4, -1);
	m_Sugg_ViewMax.Set	( 4,  4,  1);

	SetName("Unit Circle");
	SetForm("x = sin(t)\ny = cos(t)");
	SetDesc("Hello World");

	}

oe_curve::~oe_curve()
	{
	ParamsNumSet(0);
	}


// calculate the x and y of the curve at point t
// by default, a unit circle.
void	oe_curve::GetPoint	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	m;
	oe_scalar	n;

	dst.m_Value[2]	=	0.0;

//	dst.m_Value[0]	=	t;
//	dst.m_Value[1]	=	t;

//	dst.m_Value[0]	=	t;
//	dst.m_Value[1]	=	sin(t) + sin(3.0 * t);

	// tan(x)
//	dst.m_Value[0]	=	t;
//	dst.m_Value[1]	=	tan(t);

	// sin(x) + .3 * sin(4x)
//	dst.m_Value[0]	=	cos(t);
//	dst.m_Value[1]	=	sin(t) + 0.6 * sin(3 * t);

	// unit circle
	dst.m_Value[0]	=	sin(t);
	dst.m_Value[1]	=	cos(t);

	// parabola
//	dst.m_Value[0]	=	t;
//	dst.m_Value[1]	=	t * t;

	// cubic
//	dst.m_Value[0]	=	t;
//	dst.m_Value[1]	=	t * t * t;

	// hyperbola
//	dst.m_Value[0]	=	t;
//	dst.m_Value[1]	=	1/t;

	// sin
//	dst.m_Value[0]	=	t;
//	dst.m_Value[1]	=	sin(t);

	// 1/t * sin
//	dst.m_Value[0]	=	t;
//	dst.m_Value[1]	=	1/t*sin(4*t);

	// lissajous
//	dst.m_Value[0]	=	sin(2 * t);
//	dst.m_Value[1]	=	cos(1 * t);

	// small circle
//	dst.m_Value[0]	=	sin(t);
//	dst.m_Value[1]	=	cos(t);

	// clover
//	m				=	3;
//	n				=	2.5;
//	dst.m_Value[0]	=	.4*(sin(m*t) + n)*cos(t);
//	dst.m_Value[1]	=	.4*(sin(m*t) + n)*sin(t);

	}

// calculate the unit tangent to the curve at point t
// note that the normal is by default defined as the 90-degree clockwise
// rotation of this.  That relationship could be reversed if it suits you.
void	oe_curve::GetTangent	(oe_scalar	t, oe_v3& dst)
	{
	oe_scalar	m;
	oe_scalar	n;

	dst.m_Value[2]	=	0.0;

//	dst.m_Value[0]	=	1.0;
//	dst.m_Value[1]	=	1.0;

//	dst.m_Value[0]	=	1.0;
//	dst.m_Value[1]	=	cos(t) + 3.0 * cos(3.0 * t);

	// tan(x)
//	dst.m_Value[0]	=	1;
//	dst.m_Value[1]	=	1.0/(cos(t)*cos(t));

	// sin(x) + .3 * sin(4x)
//	dst.m_Value[0]	=	-sin(t);
//	dst.m_Value[1]	=	cos(t) + 0.6 * 4.0 * cos(3 * t);

	// unit circle
	dst.m_Value[0]	=	cos(t);
	dst.m_Value[1]	=	-sin(t);

	// parabola
//	dst.m_Value[0]	=	1;
//	dst.m_Value[1]	=	2 * t;

	// cubic
//	dst.m_Value[0]	=	1;
//	dst.m_Value[1]	=	3 * t * t;

	// hyperbola
//	dst.m_Value[0]	=	1;
//	dst.m_Value[1]	=	-1/(t*t);

	// sin
//	dst.m_Value[0]	=	1;
//	dst.m_Value[1]	=	cos(t);

	// 1/t * sin
//	dst.m_Value[0]	=	1;
//	dst.m_Value[1]	=	-sin(4*t) / (t * t) + 4 * cos(4 * t) / t;

	// lissajous
//	dst.m_Value[0]	=	 2 * cos(2 * t);
//	dst.m_Value[1]	=	-1 * sin(1 * t);

	// small circle
//	dst.m_Value[0]	=	cos(t);
//	dst.m_Value[1]	=	-sin(t);

	// clover
//	m				=	3;
//	n				=	2.5;
//	dst.m_Value[0]	=	-(sin(m*t) + n)*sin(t) + m*cos(m*t)*cos(t);
//	dst.m_Value[1]	=	 (sin(m*t) + n)*cos(t) + m*cos(m*t)*sin(t);

	dst.Norm(dst);
	}



/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/

