/*

  oxe_RendDX2

  */


#include "oxe_RendDX2.h"

oxe_RendDX2::oxe_RendDX2()
	{
	m_HWnd						=	NULL;
	m_lpDD1						=	NULL;
	m_lpDD4						=	NULL;
	m_lpD3D3					=	NULL;
	m_lpDDS_Primary				=	NULL;
	m_lpDDS_BackBuffer			=	NULL;
	m_lpD3DDevice				=	NULL;
	m_lpD3DViewport				=	NULL;

	m_ZBufferDepth_Desired		=	16;
	}

oxe_RendDX2::~oxe_RendDX2()
	{
	}


// This destroys the current backbuffer if it exists,
// and then allocates a new one matching the dimensions of the current window.
// return 0 on success
int		oxe_RendDX2::BackBufferCreate()
	{
	if (!m_lpDD4 || !m_HWnd)
		return 1;

	HWND			hWnd;
	RECT			r1;
	HRESULT			hResult;
	DDSURFACEDESC2	ddsd;
	OXE_INITDXSTRUCT(ddsd);

	hWnd	=	m_HWnd;



	ddsd.dwFlags		= DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
	ddsd.ddsCaps.dwCaps	= DDSCAPS_OFFSCREENPLAIN | DDSCAPS_3DDEVICE;

	GetClientRect	(hWnd, &r1);
	ClientToScreen	(hWnd, (POINT*)&r1.left);
	ClientToScreen	(hWnd, (POINT*)&r1.right);
	ddsd.dwWidth		=	r1.right	- r1.left;
	ddsd.dwHeight		=	r1.bottom	- r1.top;

	hResult	= m_lpDD4	->	CreateSurface(&ddsd, &m_lpDDS_BackBuffer, NULL );
	if (FAILED(hResult))
		return	2;

	return 0;
	}

// This destroys the current backbuffer if it exists.
// return 0 on success
int		oxe_RendDX2::BackBufferDestroy()
	{
	if (!m_lpDD4 || !m_HWnd)
		return 1;

	if (!m_lpDDS_BackBuffer)
		return	0;

	m_lpDDS_BackBuffer	->	Release();
	m_lpDDS_BackBuffer	=	NULL;

	return	0;
	}


static HRESULT CALLBACK G_D3DEnumZBufferCallback(DDPIXELFORMAT* pddpf, void* lpContext)
	{
	if (!lpContext)
		return	D3DENUMRET_CANCEL;

	return	((oxe_RendDX2*)lpContext) ->	EnumZBufferCallback(pddpf, lpContext);
	}

HRESULT CALLBACK oxe_RendDX2::EnumZBufferCallback(DDPIXELFORMAT* pddpf, void* lpContext)
	{
	if (lpContext != this)
		return	D3DENUMRET_CANCEL;

	if (pddpf -> dwFlags != DDPF_ZBUFFER)
		return	D3DENUMRET_OK;

	// test if this one is better than the one we already have

	// Choose the deepest format available <= ZBufferDepth_Desired bits.
	// This should be a config file option.

	if ((pddpf -> dwZBufferBitDepth > m_ZBufferPixelFormat.dwZBufferBitDepth &&
		 pddpf -> dwZBufferBitDepth <= m_ZBufferDepth_Desired)
		|| (m_ZBufferPixelFormat.dwZBufferBitDepth < m_ZBufferDepth_Desired))
		{
		m_ZBufferPixelFormat_Good	=	true;
		m_ZBufferPixelFormat		=	*pddpf;
		}

	return	D3DENUMRET_OK;
	}


int	oxe_RendDX2::ZBufferCreate()
	{
	if (!m_HWnd || !m_lpD3D3 || !m_D3D_DeviceGUID_IT || !m_lpDD4 || !m_lpDDS_BackBuffer)
		return 1;

	m_ZBufferPixelFormat_Good	=	false;

	OXE_INITDXSTRUCT(m_ZBufferPixelFormat);
	m_lpD3D3 -> EnumZBufferFormats(*m_D3D_DeviceGUID_IT, G_D3DEnumZBufferCallback, this);

	if (!m_ZBufferPixelFormat_Good)
		return	1;

	DDSURFACEDESC2 ddsd;

    // Get z-buffer dimensions from the render target
    // Setup the surface desc for the z-buffer.
	OXE_INITDXSTRUCT(ddsd);
    ddsd.dwFlags			=	DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT|DDSD_PIXELFORMAT;
    ddsd.ddsCaps.dwCaps		=	DDSCAPS_ZBUFFER;
	ddsd.dwWidth			=	m_WindowRect.right	- m_WindowRect.left;
	ddsd.dwHeight			=	m_WindowRect.bottom	- m_WindowRect.top;
	ddsd.ddpfPixelFormat	=	m_ZBufferPixelFormat;

    // For hardware devices, the z-buffer should be in video memory. For
	// software devices, create the z-buffer in system memory
	if(IsEqualIID(*m_D3D_DeviceGUID_IT, IID_IDirect3DHALDevice))
		ddsd.ddsCaps.dwCaps	|=	DDSCAPS_VIDEOMEMORY;
	else
		ddsd.ddsCaps.dwCaps	|=	DDSCAPS_SYSTEMMEMORY;

    // Create and attach a z-buffer. Real apps should be able to handle an
	// error here (DDERR_OUTOFVIDEOMEMORY may be encountered). For this 
	// tutorial, though, we are simply going to exit ungracefully.
    if (FAILED(m_lpDD4 -> CreateSurface( &ddsd, &m_lpDDS_ZBuffer, NULL )))
		return 2;

	// Attach the z-buffer to the back buffer.
    if (FAILED(m_lpDDS_BackBuffer	->	AddAttachedSurface(m_lpDDS_ZBuffer)))
		return 3;

	
	return	0;
	}

int	oxe_RendDX2::ZBufferDestroy()
	{
    if	(m_lpDDS_ZBuffer)
		m_lpDDS_ZBuffer	->	Release();

	m_lpDDS_ZBuffer	=	NULL;

	return	0;
	}


// Device Selection
static HRESULT CALLBACK G_D3DEnumDevicesCallback
	(
	GUID FAR*		lpGuid,                    
	LPSTR			lpDeviceDescription,           
	LPSTR			lpDeviceName,                  
	LPD3DDEVICEDESC	lpD3DHWDeviceDesc,   
	LPD3DDEVICEDESC	lpD3DHELDeviceDesc,  
	LPVOID			lpContext
	)
	{
	if (lpContext)
		{
		return ((oxe_RendDX2*)lpContext) -> DeviceEnumCallback
			(
			lpGuid,
			lpDeviceDescription,
			lpDeviceName,
			lpD3DHWDeviceDesc,
			lpD3DHELDeviceDesc,
			lpContext
			);
		}
	else
		{
		return	D3DENUMRET_CANCEL;
		}
	}

HRESULT CALLBACK oxe_RendDX2::DeviceEnumCallback
	(
	GUID FAR*		lpGuid,                    
	LPSTR			lpDeviceDescription,           
	LPSTR			lpDeviceName,                  
	LPD3DDEVICEDESC	lpD3DHWDeviceDesc, 
	LPD3DDEVICEDESC	lpD3DHELDeviceDesc, 
	LPVOID			lpContext
	)
	{
	LPD3DDEVICEDESC	lpTheDevice;

	if (lpContext != this)
		return	D3DENUMRET_CANCEL;	// ought to never happen

	bool				isHW;

	isHW	=	(lpD3DHWDeviceDesc	->	dcmColorModel	!=	0);

	if (isHW)
		lpTheDevice	=	lpD3DHWDeviceDesc;
	else
		lpTheDevice	=	lpD3DHELDeviceDesc;

	m_DevName	=	lpDeviceDescription;

	if (!DevicePass(lpTheDevice))
		{
		char	s[1024];
		sprintf(s, "%s\n%s\n\n\n%s\n\n", lpDeviceDescription, lpDeviceName, m_Hoot);
		::MessageBox(NULL, s, "Direct3D Device does not Pass our stringent requirements!", MB_OK);
		return	D3DENUMRET_OK;
		}
	else
		{
		char	s[1024];
		sprintf(s, "%s\n%s\n\n\nPASSES!\n\n", lpDeviceDescription, lpDeviceName);
//		::MessageBox(NULL, s, "Direct3D Device Passes our stringent requirements!", MB_OK);
		}

	if (isHW)
		{
		if (lpTheDevice == DeviceChooseBetter(&m_D3D_DeviceDesc_HW, lpTheDevice))
			{
			m_D3D_DeviceDesc_HW	=	*lpTheDevice;
			m_D3D_DeviceGUID_HW	=	lpGuid;
			}
		}
	else
		{
		if (lpTheDevice == DeviceChooseBetter(&m_D3D_DeviceDesc_SW, lpTheDevice))
			{
			m_D3D_DeviceDesc_SW	=	*lpTheDevice;
			m_D3D_DeviceGUID_SW	=	lpGuid;
			}
		}

	return	D3DENUMRET_OK;
	}


#define	HRDX_WHOOP(a,b) if (a) {strcpy(m_Hoot, b); if (IDCANCEL == ::MessageBox(NULL, b, m_DevName, MB_OKCANCEL)) return false;}

// returns true iff this device meets the minimum req's
// PLEASE NOTE
// i have tried to include as many options as possible and
// then comment them out if we don't care. Also have brought
// over descriptions, and kept a consistent format which makes
// it easy to work with. Please don't delete commented out lines
// and please try to maintain the format.
bool	oxe_RendDX2::DevicePass(LPD3DDEVICEDESC dd)
	{
	if (!dd)
		return	false;

	// Check that the fields we're intereested in contain valid info:

/*
	HRDX_WHOOP(  !false,
				"!false")

	HRDX_WHOOP(  false != true,
				"false != true")
*/

	
	// The bClipping member is valid. 
//	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_BCLIPPING),
//				"!(dd -> dwFlags & D3DDD_BCLIPPING)")

	// The dcmColorModel member is valid. 
	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_COLORMODEL),
				"!(dd -> dwFlags & D3DDD_COLORMODEL)")
	
	// The dwDevCaps member is valid. 
	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_DEVCAPS),
				"!(dd -> dwFlags & D3DDD_DEVCAPS)")

	// The dwDeviceRenderBitDepth member is valid. 
	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_DEVICERENDERBITDEPTH),
				"!(dd -> dwFlags & D3DDD_DEVICERENDERBITDEPTH)")

	// The dwDeviceZBufferBitDepth member is valid. 
	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_DEVICEZBUFFERBITDEPTH),
				"!(dd -> dwFlags & D3DDD_DEVICEZBUFFERBITDEPTH)")

	// The dlcLightingCaps member is valid.  TODO
//	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_LIGHTINGCAPS),
//				"!(dd -> dwFlags & D3DDD_LIGHTINGCAPS)")

	// The dpcLineCaps member is valid. 
	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_LINECAPS),
				"!(dd -> dwFlags & D3DDD_LINECAPS)")

	// The dwMaxVertexCount member is valid.  (execute buffer, don't care)
//	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_MAXVERTEXCOUNT),
//				"!(dd -> dwFlags & D3DDD_MAXVERTEXCOUNT)")

	// The dwMaxBufferSize member is valid. 
//	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_MAXBUFFERSIZE),
//				"!(dd -> dwFlags & D3DDD_MAXBUFFERSIZE)")

	// The dtcTransformCaps member is valid.  todo - fails on maxi-gamer
//	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_TRANSFORMCAPS),
//				"!(dd -> dwFlags & D3DDD_TRANSFORMCAPS)")

	// The dpcTriCaps member is valid
	HRDX_WHOOP(  !(dd -> dwFlags & D3DDD_TRICAPS),
				"!(dd -> dwFlags & D3DDD_TRICAPS)")


	// Okay. Check individual stuff.

	// yep
	HRDX_WHOOP(  (dd -> dcmColorModel	!=	D3DCOLOR_RGB),
				"(dd -> dcmColorModel	!=	D3DCOLOR_RGB)")


	// yep
	HRDX_WHOOP(  !(dd -> dwDevCaps	&	D3DDEVCAPS_DRAWPRIMTLVERTEX),
				"!(dd -> dwDevCaps	&	D3DDEVCAPS_DRAWPRIMTLVERTEX)")

	// yep
	HRDX_WHOOP(   (dd -> dwDevCaps	&	D3DDEVCAPS_SORTDECREASINGZ),
				" (dd -> dwDevCaps	&	D3DDEVCAPS_SORTDECREASINGZ)")

	// yep
	HRDX_WHOOP(   (dd -> dwDevCaps	&	D3DDEVCAPS_SORTEXACT),
				" (dd -> dwDevCaps	&	D3DDEVCAPS_SORTEXACT)")

	// yep
//	HRDX_WHOOP(   (dd -> dwDevCaps	&	D3DDEVCAPS_SORTINCREASINGZ),
//				" (dd -> dwDevCaps	&	D3DDEVCAPS_SORTINCREASINGZ)")



	// todo not sure we really need this. (fails on maxi-gamer)
//	HRDX_WHOOP(   (dd	->	dtcTransformCaps.dwCaps	!=	D3DTRANSFORMCAPS_CLIP),
//				" (dd	->	dtcTransformCaps.dwCaps	!=	D3DTRANSFORMCAPS_CLIP)")



	// TRUE if the device can perform 3-D clipping.
//	HRDX_WHOOP(  !(dd	->	bClipping),
//				"!(dd	->	bClipping)")



	// for some reason these lighting tests fail on cards that obviously support them
	// yep todo
//	HRDX_WHOOP(  !(dd ->	dlcLightingCaps.dwLightingModel & D3DLIGHTCAPS_DIRECTIONAL),
//				"!(dd ->	dlcLightingCaps.dwLightingModel & D3DLIGHTCAPS_DIRECTIONAL)")

	// yep
//	HRDX_WHOOP(  !(dd ->	dlcLightingCaps.dwLightingModel & D3DLIGHTCAPS_POINT),
//				"!(dd ->	dlcLightingCaps.dwLightingModel & D3DLIGHTCAPS_POINT)")

	// yep
//	HRDX_WHOOP(  !(dd ->	dlcLightingCaps.dwLightingModel & D3DLIGHTCAPS_SPOT),
//				"!(dd ->	dlcLightingCaps.dwLightingModel & D3DLIGHTCAPS_SPOT)")

	// yep todo
//	HRDX_WHOOP(   (dd ->	dlcLightingCaps.dwLightingModel	!=	D3DLIGHTINGMODEL_RGB),
//				" (dd ->	dlcLightingCaps.dwLightingModel	!=	D3DLIGHTINGMODEL_RGB)")

	// somewhat arbitrary on my part
//	HRDX_WHOOP(  ( dd ->	dlcLightingCaps.dwNumLights		<	3),
//				"( dd ->	dlcLightingCaps.dwNumLights		<	3)")



	// yep
	HRDX_WHOOP(  !(dd	->	dpcLineCaps.dwZCmpCaps	&	D3DPCMPCAPS_LESS),
				"!(dd	->	dpcLineCaps.dwZCmpCaps	&	D3DPCMPCAPS_LESS)")



	// The device conforms to the OpenGL standard.
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_CONFORMANT),
//				"!(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_CONFORMANT)")

	// The driver supports counterclockwise culling through the D3DRENDERSTATE_CULLMODE state. (This applies only to triangle primitives.) This corresponds to the D3DCULL_CCW member of the D3DCULL enumerated type.
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_CULLCCW),
				"!(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_CULLCCW)")

	// The driver supports clockwise triangle culling through the D3DRENDERSTATE_CULLMODE state. (This applies only to triangle primitives.) This corresponds to the D3DCULL_CW member of the D3DCULL enumerated type.
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_CULLCW),
				"!(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_CULLCW)")

	// The driver does not perform triangle culling. This corresponds to the D3DCULL_NONE member of the D3DCULL enumerated type.
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_CULLNONE),
				"!(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_CULLNONE)")

	// The driver can handle values other than 1 in the wRepeatFactor member of the D3DLINEPATTERN structure. (This applies only to line-drawing primitives.)
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_LINEPATTERNREP),
//				"!(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_LINEPATTERNREP)")

	// The device can perform a bitmask of color planes.
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_MASKPLANES),
//				"!(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_MASKPLANES)")

	// The device can enable and disable modification of the depth-buffer on pixel operations.
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_MASKZ),
//				"!(dd	->	dpcTriCaps.dwMiscCaps	&	D3DPMISCCAPS_MASKZ)")


	// yep
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwZCmpCaps	&	D3DPCMPCAPS_LESS),
				"!(dd	->	dpcTriCaps.dwZCmpCaps	&	D3DPCMPCAPS_LESS)")

	// yep
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwZCmpCaps	&	D3DPCMPCAPS_LESSEQUAL),
				"!(dd	->	dpcTriCaps.dwZCmpCaps	&	D3DPCMPCAPS_LESSEQUAL)")


	// Source blend factor is (1-As, 1-As, 1-As, 1-As) and destination blend factor is (As, As, As, As); the destination blend selection is overridden.
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_BOTHINVSRCALPHA),
				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_BOTHINVSRCALPHA)")

	// The driver supports the D3DBLEND_BOTHSRCALPHA blend mode. (This blend mode is obsolete for DirectX 6.0 and later. For more information, see D3DBLEND.)
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_BOTHSRCALPHA),
				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_BOTHSRCALPHA)")

	// Blend factor is (Ad, Ad, Ad, Ad).
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_DESTALPHA),
//				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_DESTALPHA)")

	// Blend factor is (Rd, Gd, Bd, Ad).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_DESTCOLOR),
				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_DESTCOLOR)")

	// Blend factor is (1-Ad, 1-Ad, 1-Ad, 1-Ad).
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_INVDESTALPHA),
//				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_INVDESTALPHA)")

	// Blend factor is (1-Rd, 1-Gd, 1-Bd, 1-Ad).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_INVDESTCOLOR),
				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_INVDESTCOLOR)")

	// Blend factor is (1-As, 1-As, 1-As, 1-As).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_INVSRCALPHA),
				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_INVSRCALPHA)")

	// Blend factor is (1-Rd, 1-Gd, 1-Bd, 1-Ad).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_INVSRCCOLOR),
				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_INVSRCCOLOR)")

	// Blend factor is (1, 1, 1, 1).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_ONE),
				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_ONE)")

	// Blend factor is (As, As, As, As).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_SRCALPHA),
				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_SRCALPHA)")

	// Blend factor is (f, f, f, 1); f = min(As, 1-Ad).
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_SRCALPHASAT),
//				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_SRCALPHASAT)")

	// Blend factor is (Rs, Gs, Bs, As).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_SRCCOLOR),
				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_SRCCOLOR)")
				
	// Blend factor is (0, 0, 0, 0). 
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_ZERO),
				"!(dd	->	dpcTriCaps.dwSrcBlendCaps	&	D3DPBLENDCAPS_ZERO)")
				

	// Source blend factor is (1-As, 1-As, 1-As, 1-As) and destination blend factor is (As, As, As, As); the destination blend selection is overridden.
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_BOTHINVSRCALPHA),
//				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_BOTHINVSRCALPHA)")

	// The driver supports the D3DBLEND_BOTHSRCALPHA blend mode. (This blend mode is obsolete for DirectX 6.0 and later. For more information, see D3DBLEND.)
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_BOTHSRCALPHA),
//				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_BOTHSRCALPHA)")

	// Blend factor is (Ad, Ad, Ad, Ad).
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_DESTALPHA),
//				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_DESTALPHA)")

	// Blend factor is (Rd, Gd, Bd, Ad).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_DESTCOLOR),
				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_DESTCOLOR)")

	// Blend factor is (1-Ad, 1-Ad, 1-Ad, 1-Ad).
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_INVDESTALPHA),
//				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_INVDESTALPHA)")

	// Blend factor is (1-Rd, 1-Gd, 1-Bd, 1-Ad).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_INVDESTCOLOR),
				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_INVDESTCOLOR)")

	// Blend factor is (1-As, 1-As, 1-As, 1-As).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_INVSRCALPHA),
				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_INVSRCALPHA)")

	// Blend factor is (1-Rd, 1-Gd, 1-Bd, 1-Ad).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_INVSRCCOLOR),
				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_INVSRCCOLOR)")

	// Blend factor is (1, 1, 1, 1).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_ONE),
				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_ONE)")

	// Blend factor is (As, As, As, As).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_SRCALPHA),
				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_SRCALPHA)")

	// Blend factor is (f, f, f, 1); f = min(As, 1-Ad).
//	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_SRCALPHASAT),
//				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_SRCALPHASAT)")

	// Blend factor is (Rs, Gs, Bs, As).
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_SRCCOLOR),
				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_SRCCOLOR)")
				
	// Blend factor is (0, 0, 0, 0). 
	HRDX_WHOOP(  !(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_ZERO),
				"!(dd	->	dpcTriCaps.dwDestBlendCaps	&	D3DPBLENDCAPS_ZERO)")


	// Device can support an alpha component for flat blended and stippled transparency, respectively (the D3DSHADE_FLAT state for the D3DSHADEMODE enumerated type). In these modes, the alpha color component for a primitive is provided as part of the color for the first vertex of the primitive. 
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAFLATBLEND),
				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAFLATBLEND)")

	//  Device can support an alpha component for flat blended and stippled transparency, respectively (the D3DSHADE_FLAT state for the D3DSHADEMODE enumerated type),
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAFLATSTIPPLED),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAFLATSTIPPLED)")

	// Device can support an alpha component for Gouraud blended and stippled transparency, respectively (the D3DSHADE_GOURAUD state for the D3DSHADEMODE enumerated type). In these modes, the alpha color component for a primitive is provided at vertices and interpolated across a face along with the other color components. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAGOURAUDBLEND),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAGOURAUDBLEND)")
	
	// Device can support an alpha component for Gouraud blended and stippled transparency, respectively (the D3DSHADE_GOURAUD state for the D3DSHADEMODE enumerated type),
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAGOURAUDSTIPPLED),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAGOURAUDSTIPPLED)")

	// Device can support an alpha component for Phong blended and stippled transparency, respectively (the D3DSHADE_PHONG state for the D3DSHADEMODE enumerated type). In these modes, vertex parameters are reevaluated on a per-pixel basis, applying lighting effects for the red, green, and blue color components. Phong shading is not currently supported. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAPHONGBLEND),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAPHONGBLEND)")

	// Device can support an alpha component for Phong blended and stippled transparency, respectively (the D3DSHADE_PHONG state for the D3DSHADEMODE enumerated type),
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAPHONGSTIPPLED),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_ALPHAPHONGSTIPPLED)")

	// Device can support colored flat shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. In these modes, the color component for a primitive is provided as part of the color for the first vertex of the primitive. In monochromatic lighting modes, only the blue component of the color is interpolated; in RGB lighting modes, the red, green, and blue components are interpolated. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORFLATMONO),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORFLATMONO)")

	// Device can support colored flat shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. In these modes, the color component for a primitive is provided as part of the color for the first vertex of the primitive. In monochromatic lighting modes, only the blue component of the color is interpolated; in RGB lighting modes, the red, green, and blue components are interpolated. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORFLATRGB),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORFLATRGB)")

	// Device can support colored Gouraud shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. In these modes, the color component for a primitive is provided at vertices and interpolated across a face along with the other color components. In monochromatic lighting modes, only the blue component of the color is interpolated; in RGB lighting modes, the red, green, and blue components are interpolated. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORGOURAUDMONO),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORGOURAUDMONO)")

	// Device can support colored Gouraud shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. In these modes, the color component for a primitive is provided at vertices and interpolated across a face along with the other color components. In monochromatic lighting modes, only the blue component of the color is interpolated; in RGB lighting modes, the red, green, and blue components are interpolated. 
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORGOURAUDRGB),
				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORGOURAUDRGB)")

	// Device can support colored Phong shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. In these modes, vertex parameters are reevaluated on a per-pixel basis. Lighting effects are applied for the red, green, and blue color components in RGB mode, and for the blue component only for monochromatic mode. Phong shading is not currently supported. 
//	HRDX_WHOOP(  !dd ->		dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORPHONGMONO),
//				"!dd ->		dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORPHONGMONO)")

	// Device can support colored Phong shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. In these modes, vertex parameters are reevaluated on a per-pixel basis. Lighting effects are applied for the red, green, and blue color components in RGB mode, and for the blue component only for monochromatic mode. Phong shading is not currently supported. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORPHONGRGB	),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_COLORPHONGRGB	)")

	// Device can support fog in the flat, Gouraud, and Phong shading models, respectively. Phong shading is not currently supported. 
//	HRDX_WHOOP(  !dd ->		dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_FOGFLAT),
//				"!dd ->		dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_FOGFLAT)")

	// Device can support fog in the flat, Gouraud, and Phong shading models, respectively. Phong shading is not currently supported. 
//	HRDX_WHOOP(  !dd ->		dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_FOGGOURAUD),
//				"!dd ->		dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_FOGGOURAUD)")

	// Device can support fog in the flat, Gouraud, and Phong shading models, respectively. Phong shading is not currently supported. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_FOGPHONG),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_FOGPHONG)")

	// Device can support specular highlights in flat shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARFLATMONO),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARFLATMONO)")

	// Device can support specular highlights in flat shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARFLATRGB),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARFLATRGB)")

	// Device can support specular highlights in Gouraud shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARGOURAUDMONO),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARGOURAUDMONO)")

	// Device can support specular highlights in Gouraud shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARGOURAUDRGB),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARGOURAUDRGB)")

	// Device can support specular highlights in Phong shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. Phong shading is not currently supported. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARPHONGMONO),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARPHONGMONO)")

	// Device can support specular highlights in Phong shading in the D3DCOLOR_MONO and D3DCOLOR_RGB color models, respectively. Phong shading is not currently supported. 
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARPHONGRGB),
//				"!(dd ->	dpcTriCaps.dwShadeCaps		&	D3DPSHADECAPS_SPECULARPHONGRGB)")


//	dwTextureCaps 
//	Miscellaneous texture-mapping capabilities. This member can be one or more of the following: 

	// Supports RGBA textures in the D3DTBLEND_DECAL and D3DTBLEND_MODULATE texture filtering modes. If this capability is not set, then only RGB textures are supported in those modes. Regardless of the setting of this flag, alpha must always be supported in D3DTBLEND_DECALMASK, D3DTBLEND_DECALALPHA, and D3DTBLEND_MODULATEALPHA filtering modes whenever those filtering modes are available.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_ALPHA),
				"!(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_ALPHA)")

	// Supports palettized texture surfaces whose palettes contain alpha information (see DDPCAPS_ALPHA in the DDCAPS structure).
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_ALPHAPALETTE),
//				"!(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_ALPHAPALETTE)")

	// Superseded by D3DPTADDRESSCAPS_BORDER.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_BORDER),
//				"!(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_BORDER)")

	// Perspective correction is supported.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_PERSPECTIVE),
				"!(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_PERSPECTIVE)")

	// All nonmipmapped textures must have widths and heights specified as powers of two if this flag is set. (Note that all mipmapped textures must always have dimensions that are powers of two.)
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_POW2),
//				"!(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_POW2)")

	// All textures must be square.
	HRDX_WHOOP(   (dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_SQUAREONLY),
				" (dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_SQUAREONLY)")

	// Texture indices are not scaled by the texture size prior to interpolation.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE),
//				"!(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE)")

	// Texture transparency is supported. (Only those texels that are not the current transparent color are drawn.) 
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_TRANSPARENCY),
				"!(dd ->	dpcTriCaps.dwTextureCaps	&	D3DPTEXTURECAPS_TRANSPARENCY)")

	
//	dwTextureFilterCaps
//	General texture filtering flags 
	// Bilinear filtering. Chooses the texel that has nearest coordinates, then performs a weighted average with the four surrounding texels to determine the final color. This applies to both zooming in and zooming out. If either zooming in or zooming out is supported, then both must be supported.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_LINEAR),
				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_LINEAR)")

	// Trilinear interpolation between mipmaps. Performs bilinear filtering on the two nearest mipmaps, then interpolates linearly between the two colors to determine a final color.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_LINEARMIPLINEAR),
//				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_LINEARMIPLINEAR)")

	// Linear interpolation between two point sampled mipmaps. Chooses the nearest texel from the two closest mipmap levels, then performs linear interpolation between them.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_LINEARMIPNEAREST),
//				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_LINEARMIPNEAREST)")

	// Nearest mipmapping, with bilinear filtering applied to the result. Chooses the texel from the appropriate mipmap that has nearest coordinates, then performs a weighted average with the four surrounding texels to determine the final color.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MIPLINEAR),
//				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MIPLINEAR)")

	// Nearest mipmapping. Chooses the texel from the appropriate mipmap with coordinates nearest to the desired pixel value.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MIPNEAREST),
//				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MIPNEAREST)")

	// Point sampling. The texel with coordinates nearest to the desired pixel value is used. This applies to both zooming in and zooming out. If either zooming in or zooming out is supported, then both must be supported.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_NEAREST),
				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_NEAREST)")


//	Per-stage texture filtering flags 
//	todo - not sure of these
	// The device supports per-stage flat-cubic filtering for magnifying textures. The flat-cubic magnification filter is represented by the D3DTFG_FLATCUBIC member of the D3DTEXTUREMAGFILTER enumerated type.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MAGFAFLATCUBIC),
//				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MAGFAFLATCUBIC)")

	// The device supports per-stage anisotropic filtering for magnifying textures. The anisotropic magnification filter is represented by the D3DTFG_ANISOTROPIC member of the D3DTEXTUREMAGFILTER enumerated type.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MAGFANISOTROPIC),
//				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MAGFANISOTROPIC)")

	// The device supports the per-stage Gaussian-cubic filtering for magnifying textures. The Gaussian-cubic magnification filter is represented by the D3DTFG_GAUSSIANCUBIC member of the D3DTEXTUREMAGFILTER enumerated type.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MAGFGAUSSIANCUBIC),
//				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MAGFGAUSSIANCUBIC)")

	// The device supports per-stage bilinear-interpolation filtering for magnifying textures. The bilinear-interpolation magnification filter is represented by the D3DTFG_LINEAR member of the D3DTEXTUREMAGFILTER enumerated type.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MAGFLINEAR),
				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MAGFLINEAR)")

	// The device supports per-stage point-sampled filtering for magnifying textures. The point-sample magnification filter is represented by the D3DTFG_POINT member of the D3DTEXTUREMAGFILTER enumerated type.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MAGFPOINT),
				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MAGFPOINT)")

	// The device supports per-stage anisotropic filtering for minifying textures. The anisotropic minification filter is represented by the D3DTFN_ANISOTROPIC member of the D3DTEXTUREMINFILTER enumerated type.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MINFANISOTROPIC),
//				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MINFANISOTROPIC)")

	// The device supports per-stage bilinear-interpolation filtering for minifying textures. The bilinear minification filter is represented by the D3DTFN_LINEAR member of the D3DTEXTUREMINFILTER enumerated type.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MINFLINEAR),
				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MINFLINEAR)")

	// The device supports per-stage point-sampled filtering for minifying textures. The point-sample minification filter is represented by the D3DTFN_POINT member of the D3DTEXTUREMINFILTER enumerated type.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MINFPOINT),
				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MINFPOINT)")

	// The device supports per-stage trilinear-interpolation filtering for mipmaps. The trilinear-interpolation mipmapping filter is represented by the D3DTFP_LINEAR member of the D3DTEXTUREMIPFILTER enumerated type.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MIPFLINEAR),
				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MIPFLINEAR)")

	// The device supports per-stage point-sampled filtering for mipmaps. The point-sample mipmapping filter is represented by the D3DTFP_POINT member of the D3DTEXTUREMIPFILTER enumerated type.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MIPFPOINT),
				"!(dd ->	dpcTriCaps.dwTextureFilterCaps	&	D3DPTFILTERCAPS_MIPFPOINT)")

 




//	dwTextureBlendCaps 
//	todo - any of this required ?
//	Texture-blending capabilities. See the D3DTEXTUREBLEND enumerated type for discussions of the various texture-blending modes. This member can be one or more of the following: 
	// Supports the additive texture-blending mode, in which the Gouraud interpolants are added to the texture lookup with saturation semantics. This capability corresponds to the D3DTBLEND_ADD member of the D3DTEXTUREBLEND enumerated type.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_ADD),
//				"!(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_ADD)")

	// Copy mode texture-blending (D3DTBLEND_COPY from the D3DTEXTUREBLEND enumerated type) is supported.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_COPY),
//				"!(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_COPY)")

	// Decal texture-blending mode (D3DTBLEND_DECAL from the D3DTEXTUREBLEND enumerated type) is supported.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_DECAL),
//				"!(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_DECAL)")

	// Decal-alpha texture-blending mode (D3DTBLEND_DECALALPHA from the D3DTEXTUREBLEND enumerated type) is supported.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_DECALALPHA),
//				"!(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_DECALALPHA)")

	// Decal-mask texture-blending mode (D3DTBLEND_DECALMASK from the D3DTEXTUREBLEND enumerated type) is supported.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_DECALMASK),
//				"!(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_DECALMASK)")

	// Modulate texture-blending mode (D3DTBLEND_MODULATE from the D3DTEXTUREBLEND enumerated type) is supported.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_MODULATE),
//				"!(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_MODULATE)")

	// Modulate-alpha texture-blending mode (D3DTBLEND_MODULATEALPHA from the D3DTEXTUREBLEND enumerated type) is supported.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_MODULATEALPHA),
//				"!(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_MODULATEALPHA)")

	// Modulate-mask texture-blending mode (D3DTBLEND_MODULATEMASK from the D3DTEXTUREBLEND enumerated type) is supported.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_MODULATEMASK),
//				"!(dd ->	dpcTriCaps.dwTextureBlendCaps	&	D3DPTBLENDCAPS_MODULATEMASK)")


//	dwTextureA(ddressCaps 
//	Texture-addressing capabilities. This member can be one or more of the following: 
	// Device supports setting coordinates outside the range [0.0, 1.0] to the border color, as specified by the D3DRENDERSTATE_BORDERCOLOR render state. This ability corresponds to the D3DTADDRESS_BORDER texture-addressing mode.
//	HRDX_WHOOP(  !dd ->	dpcTriCaps.dwTextureAddressCaps	&	D3DPTADDRESSCAPS_BORDER),
//				"!dd ->	dpcTriCaps.dwTextureAddressCaps	&	D3DPTADDRESSCAPS_BORDER)")

	// Device can clamp textures to addresses.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureAddressCaps	&	D3DPTADDRESSCAPS_CLAMP),
//				"!(dd ->	dpcTriCaps.dwTextureAddressCaps	&	D3DPTADDRESSCAPS_CLAMP)")

	// Device can separate the texture-addressing modes of the u and v coordinates of the texture. This ability corresponds to the D3DRENDERSTATE_TEXTUREADDRESSU and D3DRENDERSTATE_TEXTUREADDRESSV render-state values.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureAddressCaps	&	D3DPTADDRESSCAPS_INDEPENDENTUV),
//				"!(dd ->	dpcTriCaps.dwTextureAddressCaps	&	D3DPTADDRESSCAPS_INDEPENDENTUV)")

	// Device can mirror textures to addresses.
//	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureAddressCaps	&	D3DPTADDRESSCAPS_MIRROR),
//				"!(dd ->	dpcTriCaps.dwTextureAddressCaps	&	D3DPTADDRESSCAPS_MIRROR)")

	// Device can wrap textures to addresses.
	HRDX_WHOOP(  !(dd ->	dpcTriCaps.dwTextureAddressCaps	&	D3DPTADDRESSCAPS_WRAP),
				"!(dd ->	dpcTriCaps.dwTextureAddressCaps	&	D3DPTADDRESSCAPS_WRAP)")

	return true;
	}


// returns the better of two devices
LPD3DDEVICEDESC	oxe_RendDX2::DeviceChooseBetter	(LPD3DDEVICEDESC dd1, LPD3DDEVICEDESC dd2)
	{
	if (!dd1)
		return dd2;
	if (!dd2)
		return dd1;

	// PAIN

	if (dd1 ->	dcmColorModel	==	0)
		return	dd2;
	if (dd2	->	dcmColorModel	==	0)
		return	dd1;


	return dd1;
	}


int	oxe_RendDX2::DeviceSelect()
	{
	if (!m_lpD3D3)
		return	1;

	m_Mode_State.m_AllInvalid	=	true;

	m_D3D_DeviceGUID_HW			=	NULL;
	m_D3D_DeviceGUID_SW			=	NULL;
	m_D3D_DeviceGUID_IT			=	NULL;
	OXE_INITDXSTRUCT(m_D3D_DeviceDesc_HW);
	OXE_INITDXSTRUCT(m_D3D_DeviceDesc_SW);
	OXE_INITDXSTRUCT(m_D3D_DeviceDesc_IT);


	m_lpD3D3 -> EnumDevices(G_D3DEnumDevicesCallback, this);

	if (m_D3D_DeviceGUID_HW)
		{
		m_D3D_DeviceGUID_IT	=	m_D3D_DeviceGUID_HW;
		m_D3D_DeviceDesc_IT	=	m_D3D_DeviceDesc_HW;
		}
	else
		{
		m_D3D_DeviceGUID_IT	=	m_D3D_DeviceGUID_SW;
		m_D3D_DeviceDesc_IT	=	m_D3D_DeviceDesc_SW;
		}


	return 0;
	}


int	oxe_RendDX2::DeviceCreate()
	{
	if (!m_lpD3D3 || !m_lpDD4)
		return 1;

	DDSURFACEDESC2	ddsd;

	OXE_INITDXSTRUCT(ddsd);
	m_lpDD4	->	GetDisplayMode(&ddsd);

	m_Mode_State.m_AllInvalid	=	true;

	if (ddsd.ddpfPixelFormat.dwRGBBitCount <= 8)
		return 2;


	if (!FAILED(m_lpD3D3 -> CreateDevice(*m_D3D_DeviceGUID_HW, m_lpDDS_BackBuffer, &m_lpD3DDevice, NULL)))
		{
		m_D3D_DeviceGUID_IT	=	m_D3D_DeviceGUID_HW;
		m_D3D_DeviceDesc_IT	=	m_D3D_DeviceDesc_HW;
		return 0;
		}

	if (!FAILED(m_lpD3D3 -> CreateDevice(*m_D3D_DeviceGUID_SW, m_lpDDS_BackBuffer, &m_lpD3DDevice, NULL)))
		{
		m_D3D_DeviceGUID_IT	=	m_D3D_DeviceGUID_SW;
		m_D3D_DeviceDesc_IT	=	m_D3D_DeviceDesc_SW;
		return 0;
		}

	return	1;
 	}

void	oxe_RendDX2::DeviceDestroy()
	{
	LightsClearD3D		();
//	MaterialsClearD3D	();
	if (m_lpD3DDevice)
		{
		m_lpD3DDevice	->	Release();
		m_lpD3DDevice	=	NULL;
		}
 	}

int	oxe_RendDX2::ViewportCreate()
	{
	if (!m_lpD3D3 || !m_lpD3DDevice)
		return	1;

	D3DVIEWPORT2	vdData;
	HRESULT			hResult;

	m_Mode_State.m_AllInvalid	=	true;

	OXE_INITDXSTRUCT	(vdData);
	vdData.dwX			= 0;
	vdData.dwY			= 0;
	vdData.dwWidth		= m_WindowRect.right	- m_WindowRect.left;
	vdData.dwHeight		= m_WindowRect.bottom	- m_WindowRect.top;
	vdData.dvClipX		= -1.0f;
	vdData.dvClipWidth	=  2.0f;
	vdData.dvClipY		=  1.0f;
	vdData.dvClipHeight	=  2.0f;
	vdData.dvMaxZ		=  1.0f;

	if (vdData.dwWidth <=	0	|| vdData.dwHeight <= 1)
		vdData.dwHeight	=	vdData.dwHeight;
		

	hResult = m_lpD3D3			->	CreateViewport(&m_lpD3DViewport, NULL);
	if(FAILED(hResult))
		return hResult;

	// Associate the viewport with the device.
	hResult = m_lpD3DDevice		->	AddViewport(m_lpD3DViewport);
	if(FAILED(hResult))
		return hResult;

	// Set the parameters for the new viewport.
	hResult = m_lpD3DViewport	->	SetViewport2(&vdData);
	if(FAILED(hResult))
		{
		switch(hResult)
			{
			case D3DERR_VIEWPORTHASNODEVICE:
				strcpy(m_Hoot, "D3DERR_VIEWPORTHASNODEVICE");
				break;
			case DDERR_INVALIDOBJECT:
				strcpy(m_Hoot, "DDERR_INVALIDOBJECT");
				break;
			case DDERR_INVALIDPARAMS:
				strcpy(m_Hoot, "DDERR_INVALIDPARAMS");
				break;
			}

		return hResult;
		}

	// Set the current viewport for the device
	// Since i don't think we'll be switching between viewports,
	// no need to put this in a seperate FN or anything.
    hResult = m_lpD3DDevice		->	SetCurrentViewport(m_lpD3DViewport);
	if(FAILED(hResult))
		return hResult;

	return	0;
	}

void	oxe_RendDX2::ViewportDestroy()
	{
	LightsClearD3D		();
//	MaterialsClearD3D	();
	if (m_lpD3DViewport)
		{
		m_lpD3DViewport ->	Release();
		m_lpD3DViewport	=	NULL;
		}
	}



int	oxe_RendDX2::MatrixSet(int which, oe_matrix4* mat)
	{
	if (!mat)
		return	1;

	D3DMATRIX*	d3dMat;
	oe_scalar*	data;

	switch(which)
		{
		default:
			d3dMat	=	NULL;
			break;
		case OXE_MATRIX_WRLD:
			d3dMat	=	&m_MatrixWrld;
			break;
		case OXE_MATRIX_VIEW:
			d3dMat	=	&m_MatrixView;
			break;
		case OXE_MATRIX_PROJ:
			d3dMat	=	&m_MatrixProj;
			break;
		}

	if (!d3dMat)
		return	2;

	data	=	mat -> m_Data;

	d3dMat -> _11	=	(float)data[ 0];
	d3dMat -> _12	=	(float)data[ 1];
	d3dMat -> _13	=	(float)data[ 2];
	d3dMat -> _14	=	(float)data[ 3];
	d3dMat -> _21	=	(float)data[ 4];
	d3dMat -> _22	=	(float)data[ 5];
	d3dMat -> _23	=	(float)data[ 6];
	d3dMat -> _24	=	(float)data[ 7];
	d3dMat -> _31	=	(float)data[ 8];
	d3dMat -> _32	=	(float)data[ 9];
	d3dMat -> _33	=	(float)data[10];
	d3dMat -> _34	=	(float)data[11];
	d3dMat -> _41	=	(float)data[12];
	d3dMat -> _42	=	(float)data[13];
	d3dMat -> _43	=	(float)data[14];
	d3dMat -> _44	=	(float)data[15];

	switch(which)
		{
		default:
			break;
		case OXE_MATRIX_WRLD:
			break;
		case OXE_MATRIX_VIEW:
			d3dMat	->_11	*=	-1.0f;
			d3dMat	->_33	*=	-1.0f;
			d3dMat	->_43	*=	-1.0f;
			break;
		case OXE_MATRIX_PROJ:
			d3dMat	->_11	*=	-1.0f;
			d3dMat	->_33	*=	-1.0f;
			d3dMat	->_34	*=	-1.0f;
			break;
		}

	if (FAILED(MatrixSetD3D(which)))
		return	4;

	return	0;
	}

int	oxe_RendDX2::MatrixGet(int which, oe_matrix4* mat)
	{
	if (!mat)
		return	1;

	D3DMATRIX*	d3dMat;
	oe_scalar*	data;

	switch(which)
		{
		default:
			d3dMat	=	NULL;
			break;
		case OXE_MATRIX_WRLD:
			d3dMat	=	&m_MatrixWrld;
			break;
		case OXE_MATRIX_VIEW:
			d3dMat	=	&m_MatrixView;
			break;
		case OXE_MATRIX_PROJ:
			d3dMat	=	&m_MatrixProj;
			break;
		}

	if (!d3dMat)
		return	2;

	data		=	mat -> m_Data;

	data[ 0]	=	d3dMat -> _11;
	data[ 1]	=	d3dMat -> _12;
	data[ 2]	=	d3dMat -> _13;
	data[ 3]	=	d3dMat -> _14;
	data[ 4]	=	d3dMat -> _21;
	data[ 5]	=	d3dMat -> _22;
	data[ 6]	=	d3dMat -> _23;
	data[ 7]	=	d3dMat -> _34;
	data[ 8]	=	d3dMat -> _31;
	data[ 9]	=	d3dMat -> _32;
	data[10]	=	d3dMat -> _33;
	data[11]	=	d3dMat -> _34;
	data[12]	=	d3dMat -> _41;
	data[13]	=	d3dMat -> _42;
	data[14]	=	d3dMat -> _43;
	data[15]	=	d3dMat -> _44;

	return 0;
	}


int	oxe_RendDX2::MatrixSetD3D(int which)
	{
	D3DTRANSFORMSTATETYPE	trn;
	D3DMATRIX*				mat;

	if (!m_lpD3DDevice)
		return 3;


	switch(which)
		{
		default:
			mat	=	NULL;
			break;
		case OXE_MATRIX_WRLD:
			trn	=	D3DTRANSFORMSTATE_WORLD;
			mat	=	&m_MatrixWrld;
			break;
		case OXE_MATRIX_VIEW:
			trn	=	D3DTRANSFORMSTATE_VIEW;
			mat	=	&m_MatrixView;
			break;
		case OXE_MATRIX_PROJ:
			trn	=	D3DTRANSFORMSTATE_PROJECTION;
			mat	=	&m_MatrixProj;
			break;
		}

	if (!mat)
		return	1;

	if (FAILED(m_lpD3DDevice -> SetTransform(trn, mat)))
		return	2;

	return 0;
	}

int		oxe_RendDX2::WindowSetUp(HWND hWnd)
	{

	m_HWnd	=	hWnd;

	// Get an IDirectDraw interface.
	// Use the current display driver.

	HRESULT	hResult;

	// Get basic DDraw interface
	hResult	=				DirectDrawCreate	(NULL, &m_lpDD1, NULL); 
	if (FAILED(hResult))
		return	2;

    // Get a ptr to an IDirectDraw4 interface.
	// This interface to DirectDraw represents the DX6 version of the API.
    hResult	=	m_lpDD1	->	QueryInterface		(IID_IDirectDraw4, (void**)&m_lpDD4);
    if(FAILED(hResult))
        return	2;

	// Set cooperative level
    hResult	=	m_lpDD4	->	SetCooperativeLevel	(hWnd, DDSCL_NORMAL);
    if(FAILED(hResult))
        return	3;

	// Create primary surface
	DDSURFACEDESC2 ddsd;
	OXE_INITDXSTRUCT(ddsd);
	ddsd.dwFlags		= DDSD_CAPS;
	ddsd.ddsCaps.dwCaps	= DDSCAPS_PRIMARYSURFACE;
    hResult	=	m_lpDD4	->	CreateSurface		(&ddsd, &m_lpDDS_Primary, NULL);
    if(FAILED(hResult))
        return	4;

	WindowDimensionsGet(false);

	// Create backbuffer
	if (BackBufferCreate())
		return	4;

	if (ClipperCreate())
		return	4;

	// Get D3D interface
	hResult = m_lpDD4 -> QueryInterface(IID_IDirect3D3, (void **)&m_lpD3D3);
	if (FAILED(hResult))
		return	5;

	if (DeviceSelect())
		return	6;

	if (ZBufferCreate())
		return	7;

	if (DeviceCreate())
		return	8;

	if (ViewportCreate())
		return	9;

	oe_matrix4	Identity;
	Identity.MakeIdentity();
	MatrixSet(OXE_MATRIX_WRLD, &Identity);
	MatrixSet(OXE_MATRIX_PROJ, &Identity);
	MatrixSet(OXE_MATRIX_VIEW, &Identity);

//	return 1;

	return 0;
	}

int		oxe_RendDX2::WindowSetDn()
	{
	return	1;
	}

void	oxe_RendDX2::WindowDimensionsGet(bool doResize)
	{
	if(!m_HWnd)
		return;

	int	oldWidth;
	int	oldHeight;

	// Get window dimensions
	HWND	hWnd;
	hWnd	=	m_HWnd;

	oldWidth					=	m_WindowRect.right	- m_WindowRect.left;
	oldHeight					=	m_WindowRect.bottom	- m_WindowRect.top;

	GetClientRect	(hWnd, &m_WindowRect);
	GetClientRect	(hWnd, &m_ViewportRect);

	ClientToScreen	(hWnd, (POINT*)&m_WindowRect.left	);
	ClientToScreen	(hWnd, (POINT*)&m_WindowRect.right	);

	if (doResize && (
		m_WindowRect.right	- m_WindowRect.left	!=	oldWidth	||
		m_WindowRect.bottom	- m_WindowRect.top	!=	oldHeight		))
		{
		SizeChanged();
		}
	}

// This really does the resize,
// do not call it if the window has not actually been resized.
int	oxe_RendDX2::SizeChanged()
	{
	int	rtn;

	ViewportDestroy				();
	DeviceDestroy				();
	ZBufferDestroy				();
	BackBufferDestroy			();

	rtn	=	BackBufferCreate	();
	if (rtn)
		return rtn;

	rtn	=	ZBufferCreate		();
	if (rtn)
		return rtn;

	rtn	=	DeviceCreate		();
	if (rtn)
		return	rtn;

	rtn	=	ViewportCreate		();
	if (rtn)
		return	rtn;

	return	rtn;
	}


int	oxe_RendDX2::ClipperCreate()
	{
	if (!m_HWnd)
		return 1;

	// Create a clipper object which handles all our clipping for cases when
	// our window is partially obscured by other windows. This is not needed
	// for apps running in fullscreen mode.

	LPDIRECTDRAWCLIPPER Clipper;

	if (FAILED(m_lpDD4 ->CreateClipper(0, &Clipper, NULL)))
		return 2;

	// Associate the clipper with our window. Note that, afterwards, the
	// clipper is internally referenced by the primary surface, so it is safe
	// to release our local reference to it.


	Clipper			->	SetHWnd		(0, m_HWnd);
	m_lpDDS_Primary ->	SetClipper	(Clipper);
	Clipper			->	Release		();

	return 0;
	}




int	oxe_RendDX2::OnMove()
	{
	WindowDimensionsGet(true);
	return 0;
	}

int	oxe_RendDX2::OnSize()
	{
	WindowDimensionsGet(true);
	return 0;
	}



int	oxe_RendDX2::SceneBegin()
	{
	if (!m_lpD3DDevice)
		return 1;

	LightsUntouch();

	if (FAILED(m_lpD3DDevice -> BeginScene()))
		return	2;

	// todo - should these be in HR_Mode_State ?
	// or are they too DX specific ?
	m_lpD3DDevice -> SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTFG_ANISOTROPIC	);
	m_lpD3DDevice -> SetTextureStageState(0, D3DTSS_MINFILTER, D3DTFG_ANISOTROPIC	);
	m_lpD3DDevice -> SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTFG_LINEAR		);
	m_lpD3DDevice -> SetTextureStageState(1, D3DTSS_MAGFILTER, D3DTFG_ANISOTROPIC	);
	m_lpD3DDevice -> SetTextureStageState(1, D3DTSS_MINFILTER, D3DTFG_ANISOTROPIC	);
	m_lpD3DDevice -> SetTextureStageState(1, D3DTSS_MIPFILTER, D3DTFG_LINEAR		);

	return 0;
	}

int	oxe_RendDX2::SceneEnd()
	{
	if (!m_lpD3DDevice)
		return	1;

	if (FAILED(m_lpD3DDevice -> EndScene()))
		return	2;

	return 0;
	}

int		oxe_RendDX2::Clear()
	{
	if (!m_lpD3DDevice || !m_lpD3DViewport)
		return	1;

	int	clearFlags;
	D3DRECT	r1;

	r1.x1	=	0;
	r1.y1	=	0;
	r1.x2	=	m_WindowRect.right	-	m_WindowRect.left;
	r1.y2	=	m_WindowRect.bottom	-	m_WindowRect.top;

	clearFlags	=	0;

//	if (clear pixel buffer)
		clearFlags	|=	D3DCLEAR_TARGET;	// Clear the rendering target to the color in the dwColor parameter.

//	if (ClearZBuffer)
		clearFlags	|=	D3DCLEAR_ZBUFFER;	// Clear the depth-buffer to the value in the dvZ parameter.

	// if (ClearStencil)
//		clearFlags	|=	D3DCLEAR_STENCIL;	// Clear the stencil buffer to the value in the dwStencil parameter.

	D3DCOLOR	clearColor;

	clearColor	=	D3DRGB(m_ClearColor.m_Value[0], m_ClearColor.m_Value[1], m_ClearColor.m_Value[2]);

	if (FAILED(m_lpD3DViewport	-> Clear2(1, &r1, clearFlags, clearColor, 1.0f, 0)))
		return	2;

	
	return	0;

	}


int	oxe_RendDX2::BackBufferShow	()
	{
	if (!m_lpDDS_Primary || !m_lpDDS_BackBuffer)
		return	1;

	//TODO - use fast blt
	//DDBLT_WAIT
	if (FAILED(m_lpDDS_Primary	-> Blt(&m_WindowRect, m_lpDDS_BackBuffer, &m_ViewportRect, 0, NULL)))
		return	2;

	return 0;
	}


//////////////////
// Mode Routines

int oxe_RendDX2::ModeSetD3D(HR_Mode_State* hrms)
	{
	if (!hrms || !m_lpD3DDevice)
		return	1;

	HR_Mode_State	changeState;
	HR_Mode_State*	hrms_new;


	// I don't know how much overhead there is involved in setting a mode
	// to be the same as it already is, but just in case, this routine
	// will get the difference between the current state and the new one.
	// (only for those items in the new state that are marked 'care')
	changeState.Diff(&m_Mode_State, hrms);

	hrms_new	=	&changeState;


	if (hrms_new -> m_Care_Cull)
		{
		m_Mode_State.m_Cull				=	hrms_new -> m_Cull;

		switch (m_Mode_State.m_Cull)
			{
			case HR_CULL_NONE:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_NONE);
				break;
			default:
			case HR_CULL_BACK:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_CCW);
				break;
			case HR_CULL_FRONT:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_CW);
				break;
			}
		}

	if (hrms_new -> m_Care_Fill)
		{
		m_Mode_State.m_Fill				=	hrms_new -> m_Fill;

		switch (m_Mode_State.m_Fill)
			{
			case HR_FILL_POINT:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_FILLMODE, D3DFILL_POINT);
				break;
			case HR_FILL_LINE:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_FILLMODE, D3DFILL_WIREFRAME);
				break;
			default:
			case HR_FILL_SOLID:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_FILLMODE, D3DFILL_SOLID);
				break;
			}
		}

	if (hrms_new -> m_Care_ZWrite)
		{
		m_Mode_State.m_ZWrite			=	hrms_new -> m_ZWrite;
		m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZWRITEENABLE	, m_Mode_State.m_ZWrite);
		}

	if (hrms_new -> m_Care_ZTest)
		{
		m_Mode_State.m_ZTest			=	hrms_new -> m_ZTest;
		m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZENABLE		, m_Mode_State.m_ZTest);
		}

	if (hrms_new -> m_Care_ZFunc)
		{
		m_Mode_State.m_ZFunc			=	hrms_new -> m_ZFunc;

		switch (m_Mode_State.m_ZFunc)
			{
			case HR_CMP_NEVER:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZFUNC,	D3DCMP_NEVER);
				break;
			default:
			case HR_CMP_LESS:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZFUNC,	D3DCMP_LESS);
				break;
			case HR_CMP_EQUAL:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZFUNC,	D3DCMP_EQUAL);
				break;
			case HR_CMP_LESSEQUAL:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZFUNC,	D3DCMP_LESSEQUAL);
				break;
			case HR_CMP_GREATER:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZFUNC,	D3DCMP_GREATER);
				break;
			case HR_CMP_NOTEQUAL:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZFUNC,	D3DCMP_NOTEQUAL);
				break;
			case HR_CMP_GREATEREQUAL:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZFUNC,	D3DCMP_GREATEREQUAL);
				break;
			case HR_CMP_ALWAYS:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZFUNC,	D3DCMP_ALWAYS);
				break;
			}
		}

    
	if (hrms_new -> m_Care_ZBias)
		{
		m_Mode_State.m_ZBias			=	hrms_new -> m_ZBias;

		if		(m_Mode_State.m_ZBias > 16)
			m_Mode_State.m_ZBias	=	16;
		else if	(m_Mode_State.m_ZBias < 0)
			m_Mode_State.m_ZBias	=	0;

		m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ZBIAS,	m_Mode_State.m_ZBias);
		}

	if (hrms_new -> m_Care_AlphaBlend)
		{
		m_Mode_State.m_AlphaBlend		=	hrms_new -> m_AlphaBlend;

		m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_ALPHABLENDENABLE,	m_Mode_State.m_AlphaBlend);
		}

	if (hrms_new -> m_Care_AlphaBlendSrc)
		{
		m_Mode_State.m_AlphaBlendSrc	=	hrms_new -> m_AlphaBlendSrc;

		switch (m_Mode_State.m_AlphaBlendSrc)
			{
			case HR_BLEND_ZERO:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_ZERO				);
				break;
			default:
			case HR_BLEND_ONE:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_ONE				);
				break;
			case HR_BLEND_SRCCOLOR:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCCOLOR			);
				break;
			case HR_BLEND_INVSRCCOLOR:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_INVSRCCOLOR		);
				break;
			case HR_BLEND_SRCALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA			);
				break;
			case HR_BLEND_INVSRCALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_INVSRCALPHA		);
				break;
			case HR_BLEND_DESTALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_DESTALPHA			);
				break;
			case HR_BLEND_INVDESTALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_INVDESTALPHA		);
				break;
			case HR_BLEND_DESTCOLOR:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_DESTCOLOR			);
				break;
			case HR_BLEND_INVDESTCOLOR:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_INVDESTCOLOR		);
				break;
			case HR_BLEND_SRCALPHASAT:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHASAT		);
				break;
			case HR_BLEND_BOTHSRCALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_BOTHSRCALPHA		);
				break;
			case HR_BLEND_BOTHINVSRCALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_BOTHINVSRCALPHA	);
				break;
			}

		}

	if (hrms_new -> m_Care_AlphaBlendDst)
		{
		m_Mode_State.m_AlphaBlendDst	=	hrms_new -> m_AlphaBlendDst;

		switch (m_Mode_State.m_AlphaBlendSrc)
			{
			default:
			case HR_BLEND_ZERO:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_ZERO				);
				break;
			case HR_BLEND_ONE:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_ONE				);
				break;
			case HR_BLEND_SRCCOLOR:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_SRCCOLOR			);
				break;
			case HR_BLEND_INVSRCCOLOR:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCCOLOR		);
				break;
			case HR_BLEND_SRCALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_SRCALPHA			);
				break;
			case HR_BLEND_INVSRCALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA		);
				break;
			case HR_BLEND_DESTALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_DESTALPHA		);
				break;
			case HR_BLEND_INVDESTALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVDESTALPHA		);
				break;
			case HR_BLEND_DESTCOLOR:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_DESTCOLOR		);
				break;
			case HR_BLEND_INVDESTCOLOR:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVDESTCOLOR		);
				break;
			case HR_BLEND_SRCALPHASAT:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_SRCALPHASAT		);
				break;
			case HR_BLEND_BOTHSRCALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_BOTHSRCALPHA		);
				break;
			case HR_BLEND_BOTHINVSRCALPHA:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_BOTHINVSRCALPHA	);
				break;
			}
		}

	if (hrms_new -> m_Care_Specular)
		{
		m_Mode_State.m_Specular				=	hrms_new -> m_Specular;
		m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SPECULARENABLE,	m_Mode_State.m_Specular		);
		}

	if (hrms_new -> m_Care_Shade)
		{
		m_Mode_State.m_Shade				=	hrms_new -> m_Shade;

		switch (m_Mode_State.m_Shade)
			{
			case HR_SHADE_FLAT:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SHADEMODE,	D3DSHADE_FLAT);
				break;
			default:
			case HR_SHADE_GOURAUD:
			case HR_SHADE_PHONG:
				m_lpD3DDevice -> SetRenderState(D3DRENDERSTATE_SHADEMODE,	D3DSHADE_GOURAUD);
				break;
			}
		}

	// unimplemented:
	if (hrms_new -> m_Care_Fog)
		{
		m_Mode_State.m_Fog				=	hrms_new -> m_Fog;
		}

	// unimplemented:
	if (hrms_new -> m_Care_FogIParam1)
		{
		m_Mode_State.m_FogIParam1		=	hrms_new -> m_FogIParam1;
		}

	// unimplemented:
	if (hrms_new -> m_Care_FogIParam2)
		{
		m_Mode_State.m_FogIParam2		=	hrms_new -> m_FogIParam2;
		}

	// unimplemented:
	if (hrms_new -> m_Care_FogIParam3)
		{
		m_Mode_State.m_FogIParam3		=	hrms_new -> m_FogIParam3;
		}

	// unimplemented:
	if (hrms_new -> m_Care_FogIParam4)
		{
		m_Mode_State.m_FogIParam4		=	hrms_new -> m_FogIParam4;
		}

	// unimplemented:
	if (hrms_new -> m_Care_FogFParam1)
		{
		m_Mode_State.m_FogFParam1		=	hrms_new -> m_FogFParam1;
		}

	// unimplemented:
	if (hrms_new -> m_Care_FogFParam2)
		{
		m_Mode_State.m_FogFParam2		=	hrms_new -> m_FogFParam2;
		}

	// unimplemented:
	if (hrms_new -> m_Care_FogFParam3)
		{
		m_Mode_State.m_FogFParam3		=	hrms_new -> m_FogFParam3;
		}

	// unimplemented:
	if (hrms_new -> m_Care_FogFParam4)
		{
		m_Mode_State.m_FogFParam4		=	hrms_new -> m_FogFParam4;
		}

	return	0;
	}

int oxe_RendDX2::ModeSet(HR_Mode_State* hrms)
	{
	return ModeSetD3D(hrms);
	}

int oxe_RendDX2::ModeGet(HR_Mode_State* hrms)
	{
	if (!hrms)
		return	1;

	return	0;
	}



int oxe_RendDX2::LightAdd(oxe_3DLight* lit)
	{
	if (!m_Lights.IsMember(lit))
		m_Lights.Append(lit);

	return 0;
	}

int	oxe_RendDX2::LightDel(oxe_3DLight* lit)
	{
	if (!lit)
		return 1;

	if (LightDelD3D(lit))
		return 2;

	int	i;

	if (!m_Lights.IsMember(lit, i))
		return 3;

	m_Lights.Remove(i);

	return 0;
	}

// Removes the light from the viewport,
// releases it, etc.
int	oxe_RendDX2::LightDelD3D(oxe_3DLight* lit)
	{
	if (!lit)
		return 1;

	LPDIRECT3DLIGHT	d3dL;
	
	d3dL	=	(LPDIRECT3DLIGHT)(lit -> m_RendererData);

	lit				->	m_RendererData	=	NULL;
	lit				->	Touch();

	if (!d3dL)
		return 0;

	m_lpD3DViewport	->	DeleteLight		(d3dL);
	d3dL			->	Release			();

	return 0;
	}


int	oxe_RendDX2::LightsGetNum()
	{
	return	m_Lights.GetNum();
	}

oxe_3DLight*	oxe_RendDX2::LightGet(int num)
	{
	if (num < 0 || num >= m_Lights.GetNum())
		return NULL;

	return (oxe_3DLight*)(m_Lights[num]);
	}

int	oxe_RendDX2::LightUntouch(oxe_3DLight* lit)
	{
	if (!lit)
		return 1;


	bool				needToReallocate;
	LPDIRECT3DLIGHT		d3dL;

	needToReallocate	=	false;

	if (lit -> m_Type == OXE_LIGHT_AMBIENT)
		return LightUntouchAmbient(lit);


	d3dL				=	(LPDIRECT3DLIGHT)(lit -> m_RendererData);

	if (!d3dL)
		needToReallocate	=	true;

	if (needToReallocate)
		if (LightReallocate(lit))
			return 2;

	d3dL				=	(LPDIRECT3DLIGHT)(lit -> m_RendererData);
	if (!d3dL)
		return	4;

	if (!lit -> m_Touched)
		return 0;

	D3DLIGHT2	specs;

	if (LightHapToD3D(lit, &specs))
		return	2;

	if (FAILED((d3dL -> SetLight((LPD3DLIGHT)&specs))))
		return	3;

	lit	->	m_Touched	=	false;

	return	0;
	}

int	oxe_RendDX2::LightUntouchAmbient(oxe_3DLight* lit)
	{
	if (!lit || !m_lpD3DDevice)
		return 1;

	if (lit -> m_Type	!=	OXE_LIGHT_AMBIENT)
		return 2;

	if (!lit -> m_Touched)
		return	0;

	unsigned	char	r, g, b, a;

	r	=	(unsigned char)(__max(0.0, __min(255.0, lit -> m_Color.m_Value[0] * 255.0f + 0.5f)));
	g	=	(unsigned char)(__max(0.0, __min(255.0, lit -> m_Color.m_Value[1] * 255.0f + 0.5f)));
	b	=	(unsigned char)(__max(0.0, __min(255.0, lit -> m_Color.m_Value[2] * 255.0f + 0.5f)));
	a	=	0;

	if (FAILED(m_lpD3DDevice ->SetLightState(D3DLIGHTSTATE_AMBIENT, RGBA_MAKE(r, g, b, a))))
		return 3;

	lit	->	m_Touched	=	false;

	return	0;
	}


int	oxe_RendDX2::LightReallocate(oxe_3DLight* lit)
	{
	if (!lit || !m_lpD3DViewport)
		return	1;

	if (lit -> m_Type == OXE_LIGHT_AMBIENT)
		return	0;

	LightDelD3D(lit);

	if (!m_lpD3D3)
		return	2;

	LPDIRECT3DLIGHT	d3dL;


    if (FAILED(m_lpD3D3 -> CreateLight(&d3dL, NULL)))
		return	3;

	lit	->	m_RendererData	=	d3dL;

	D3DLIGHT2	specs;

	if (LightHapToD3D(lit, &specs))
		return	4;

	if (FAILED(d3dL -> SetLight((LPD3DLIGHT)&specs)))
		return	5;

	if (FAILED(m_lpD3DViewport -> AddLight(d3dL)))
		return	6;

	lit	->	m_Touched	=	false;
	return 0;
	}


// This routine fills in the D3DLIGHT2 structure
// with the appropriate data based on the oxe_3DLight.
// NOTE
// it does not actually make any D3D calls,
// actually updating the D3D light should be done after a call to this.
int	oxe_RendDX2::LightHapToD3D(oxe_3DLight* litSrc, D3DLIGHT2* litDst)
	{
	if (!litSrc || !litDst)
		return 1;

	if (litSrc -> m_Type == OXE_LIGHT_AMBIENT)
		return 2;

	OXE_INITDXSTRUCT((*litDst));


	// Type Type Type Type Type Type Type Type 

	switch (litSrc -> m_Type)
		{
		case OXE_LIGHT_AMBIENT:
			// needs to be handled specially
			break;

		case OXE_LIGHT_SPOT:
			litDst -> dltType = D3DLIGHT_SPOT;
			// Light is a spotlight source. This light is something like a point light except that the illumination is limited to a cone. This light type has a direction and several other parameters which determine the shape of the cone it produces. For information about these parameters, see the D3DLIGHT2 structure. 
			break;

		default:
		case OXE_LIGHT_DIRECTIONAL:
			litDst -> dltType = D3DLIGHT_DIRECTIONAL;
			// Light is a directional source. This is equivalent to using a point light source at an infinite distance. 
			break;

		case OXE_LIGHT_POINT:
			litDst -> dltType = D3DLIGHT_POINT;
			// Light is a point source. The light has a position in space and radiates light in all directions. 
			break;

		case OXE_LIGHT_DIRECTIONALPOINT:
			litDst -> dltType = D3DLIGHT_PARALLELPOINT;
			// Light is a parallel point source. This light type acts like a directional light except its direction is the vector going from the light position to the origin of the geometry it is illuminating. 
			break;
		}


	// Color Color Color Color Color Color Color Color 


	oe_scalar*		rgba;
	D3DCOLORVALUE	dcv;
	oe_v3*			v;

	rgba	=	litSrc ->	m_Color.m_Value;
	dcv.r	=	rgba[0];
	dcv.g	=	rgba[1];
	dcv.b	=	rgba[2];
	dcv.a	=	rgba[3];
	litDst	->	dcvColor = dcv;


	// Position Position Position Position Position Position 
	v							=	&litSrc	->	m_Position;
	litDst	-> dvPosition.x		=	v		->	m_Value[0];
	litDst	-> dvPosition.y		=	v		->	m_Value[1];
	litDst	-> dvPosition.z		=	v		->	m_Value[2];

	// Direction Direction Direction Direction Direction 
	v							=	&litSrc	->	m_Direction;
	litDst	-> dvDirection.x	=	v		->	m_Value[0];
	litDst	-> dvDirection.y	=	v		->	m_Value[1];
	litDst	-> dvDirection.z	=	v		->	m_Value[2];

	// Range Range Range Range Range Range Range Range Range 
	litDst	->	dvRange			=	litSrc	->	m_Range;

	// Falloff Falloff Falloff Falloff Falloff Falloff Falloff 
	litDst	->	dvFalloff		=	1.0f;		// hardwired, see DX Docs. Spotlight Subtlety.

	// Attenuation Attenuation Attenuation Attenuation Attenuation
	litDst	->	dvAttenuation0	=	0.0f;
	litDst	->	dvAttenuation1	=	1.0f;
	litDst	->	dvAttenuation2	=	0.0f;

	// Cone Cone Cone Cone Cone Cone Cone Cone Cone Cone Cone 
	litDst	->	dvTheta			=	litSrc ->	m_ConeAngleInner;		// radians
	litDst	->	dvPhi			=	litSrc ->	m_ConeAngleOutter;		// radians

	litDst	->	dwFlags			=	D3DLIGHT_ACTIVE;

	return 0;
	}

int	oxe_RendDX2::LightsUntouch()
	{
	int			i, inum;
	int			errs;

	errs	=	0;
	inum	=	LightsGetNum();
	for (i = 0; i < inum; i++)
		errs	+=	LightUntouch(LightGet(i));

	return	errs;
	}

// This is called when the viewport is destroyed / created.
// It releases the D3D side of our list of Lights.
// It does NOT delete any oxe_3DLights.
int	oxe_RendDX2::LightsClearD3D()
	{
	int	i, inum;
	int	errs;

	inum	=	m_Lights.GetNum();
	errs	=	0;
	for (i = 0; i < inum; i++)
		{
		errs += LightDelD3D((oxe_3DLight*)(m_Lights[i]));
		}

	return errs;
	}



int	oxe_RendDX2::MaterialAdd(oxe_3DMaterial*	mtl)
	{
	if (!m_Materials.IsMember(mtl))
		m_Materials.Append(mtl);

	return 0;
	}

int	oxe_RendDX2::MaterialDel(oxe_3DMaterial*	mtl)
	{
	if (!mtl)
		return 1;

	if (MaterialDelD3D(mtl))
		return 2;

	int	i;

	if (!m_Materials.IsMember(mtl, i))
		return 3;

	m_Materials.Remove(i);

	return 0;
	}

oxe_3DMaterial*	oxe_RendDX2::MaterialGet(int num)
	{
	if (num < 0 || num >= m_Materials.GetNum())
		return NULL;

	return	(oxe_3DMaterial*)(m_Materials.GetNum());
	}

int	oxe_RendDX2::MaterialsGetNum()
	{
	return m_Materials.GetNum();
	}


int	oxe_RendDX2::MaterialUntouch(oxe_3DMaterial* mtl)
	{
	if (!mtl)
		return	1;

//	MaterialAdd(mtl);		// no need.

	bool				needToReallocate;
	void*				hey;
	LPDIRECT3DMATERIAL3	d3dMtl;
	D3DMATERIAL			spec;

	needToReallocate	=	false;


	hey					=	mtl ->m_RendererData;
	d3dMtl				=	(LPDIRECT3DMATERIAL3)(mtl -> m_RendererData);

	if (!d3dMtl)
		needToReallocate	=	true;

	if (needToReallocate)
		if (MaterialReallocate(mtl))
			return 2;

	d3dMtl				=	(LPDIRECT3DMATERIAL3)(mtl -> m_RendererData);
	if (!d3dMtl)
		return	3;

	if (!mtl -> m_Touched && 0)
		return	0;

	if (FAILED(MaterialHapToD3D(mtl, &spec)))
		return	4;

	if (FAILED(d3dMtl	->	SetMaterial(&spec)))
		return	5;

	mtl	->	m_Touched	=	false;

	return	0;
	}

int	oxe_RendDX2::MaterialReallocate(oxe_3DMaterial* mtl)
	{
	if (!mtl)
		return	1;

	MaterialDelD3D(mtl);

	if (!m_lpD3D3)
		return	2;

	LPDIRECT3DMATERIAL3	d3dMtl;
	D3DMATERIAL			spec;

	if (FAILED(m_lpD3D3	->	CreateMaterial(&d3dMtl, NULL)))
		return	3;

	if (FAILED(MaterialHapToD3D(mtl, &spec)))
		return	4;

	if (FAILED(d3dMtl	->	SetMaterial(&spec)))
		return	5;

	mtl ->	SetRendererData(d3dMtl);

	mtl	->	m_Touched	=	false;

	return	0;
	}

int	oxe_RendDX2::MaterialDelD3D(oxe_3DMaterial* mtl)
	{
	if (!mtl)
		return	1;

	LPDIRECT3DMATERIAL3	d3dMtl;

	d3dMtl				=	(LPDIRECT3DMATERIAL3)(mtl -> m_RendererData);

	mtl	->	SetRendererData(NULL);
	
	if (!d3dMtl)
		return	0;

	d3dMtl	->	Release			();

	return	0;
	}

// In this call,
// Multiply material or whatever is assumed to have been done.
int	oxe_RendDX2::MaterialHapToD3D(oxe_3DMaterial* mtlSrc, D3DMATERIAL* mtlDst)
	{
	if (!mtlSrc || !mtlDst)
		return 1;

	OXE_INITDXSTRUCT((*mtlDst));

	D3DCOLORVALUE	cv;
	oe_scalar*		pf;
	
	// Diffuse Diffuse Diffuse Diffuse Diffuse Diffuse Diffuse Diffuse
	pf		=	mtlSrc	->	m_Diffuse.m_Value;
	cv.r	=	pf[0];
	cv.g	=	pf[1];
	cv.b	=	pf[2];
	cv.a	=	pf[3];
	mtlDst	->	diffuse		=	cv;

	// Ambient Ambient Ambient Ambient Ambient Ambient Ambient Ambient 
	pf		=	mtlSrc	->	m_Ambient.m_Value;
	cv.r	=	pf[0];
	cv.g	=	pf[1];
	cv.b	=	pf[2];
	cv.a	=	pf[3];
	mtlDst	->	ambient		=	cv;

	// Specular Specular Specular Specular Specular Specular Specular 
	pf		=	mtlSrc	->	m_Specular.m_Value;
	cv.r	=	pf[0];
	cv.g	=	pf[1];
	cv.b	=	pf[2];
	cv.a	=	pf[3];
	mtlDst	->	specular	=	cv;

	// Emissive Emissive Emissive Emissive Emissive Emissive Emissive 
	pf		=	mtlSrc	->	m_Emissive.m_Value;
	cv.r	=	pf[0];
	cv.g	=	pf[1];
	cv.b	=	pf[2];
	cv.a	=	pf[3];
	mtlDst	->	emissive	=	cv;

	// Power Power Power Power Power Power Power Power Power Power Power
	mtlDst	->	power		=	mtlSrc ->	m_SpecularPower;

	return	0;
	}

int	oxe_RendDX2::MaterialsClearD3D()
	{
	int	i, inum;
	int	errs;

	inum	=	m_Materials.GetNum();
	errs	=	0;
	for (i = 0; i < inum; i++)
		{
		errs += MaterialDelD3D((oxe_3DMaterial*)(m_Materials[i]));
		}

	return errs;
	}

int	oxe_RendDX2::MaterialSet(oxe_3DMaterial*	mtl)
	{
	if (!mtl || !m_lpD3DDevice)
		return	1;

	MaterialUntouch(mtl);


	LPDIRECT3DMATERIAL3	d3dMtl;

	d3dMtl	=	(LPDIRECT3DMATERIAL3)(mtl -> m_RendererData);

	if (!d3dMtl)
		return 2;

	D3DMATERIALHANDLE	hmtl;

	if (FAILED(d3dMtl -> GetHandle(m_lpD3DDevice, &hmtl)))
		return	3;

	if (FAILED(m_lpD3DDevice ->SetLightState(D3DLIGHTSTATE_MATERIAL, hmtl)))
		return	4;


	return 0;
	}
