/*

  oxe_Registry

  a class to store pointers-to-values and names for the values.
  whoop, whoo, and weehee

  */

#ifndef	_OXE_REGISTRY_H_
#define	_OXE_REGISTRY_H_

#include "oe_voidlist.h"
#include "oe_v2.h"
#include "oe_v3.h"
#include "oe_v4.h"
#include <stdio.h>


#define	OXE_REG_TYPE_VOID		0
#define	OXE_REG_TYPE_OESCALAR	1
#define	OXE_REG_TYPE_OEV2		2
#define	OXE_REG_TYPE_OEV3		3
#define	OXE_REG_TYPE_OEV4		4
#define	OXE_REG_TYPE_INT		5
#define	OXE_REG_TYPE_STRING		6


class	oxe_RegistryEntry
	{
	public:

	char*	m_Name;
	void*	m_Value;
	int		m_Type;

	public:
		oxe_RegistryEntry	();
	~	oxe_RegistryEntry	();
	
	void		SetName		(const char	*n	);
	const char*	GetName		(				);
	void		SetValue	(void		*p	);
	void		SetValue	(oe_scalar	*p	);
	void		SetValue	(oe_v2		*p	);
	void		SetValue	(oe_v3		*p	);
	void		SetValue	(oe_v4		*p	);
	void		SetValue	(int		*p	);
	void		SetValue	(char		*p	);
	void*		GetValue	(				);
	void		SetType		(int		 t	);
	int			GetType		(				);

	int			Write		(FILE* fp);
	int			ReadValue	(FILE* fp);
	};

class	oxe_Registry
	{
	public:

	oe_VoidList	m_Entries;

	oxe_RegistryEntry*	AddEntry(const char* name					);
	oxe_RegistryEntry*	AddEntry(const char* name, void		* value	);
	oxe_RegistryEntry*	AddEntry(const char* name, oe_scalar* value	);
	oxe_RegistryEntry*	AddEntry(const char* name, oe_v2	* value	);
	oxe_RegistryEntry*	AddEntry(const char* name, oe_v3	* value	);
	oxe_RegistryEntry*	AddEntry(const char* name, oe_v4	* value	);
	oxe_RegistryEntry*	AddEntry(const char* name, int		* value	);
	oxe_RegistryEntry*	AddEntry(const char* name, char		* value	);

	oxe_RegistryEntry*	Find	(const char* name					);


	void	Save(FILE* fp);
	void	Save(const char* fn);
	void	Load(FILE* fp);
	void	Load(const char* fn);

	};


#endif	_OXE_REGISTRY_H_
