/*

  oxe_3DObj

  a 3d object class

  This is the render-independant base class.

  Has a 1-1 mapping 'twixt vertices, normals, tex-coords.

  May be represented as tristrips!

  */


#ifndef	_OXE_3D_OBJ_H_
#define	_OXE_3D_OBJ_H_


#include "generic_os.h"
#include "oe_v3.h"
#include "oe_v2.h"
#include "oxe_3DMaterial.h"
#include "oxe_MagicDiscontinuityFixer.h"


class	oxe_3DObj
	{
	public:

	int				m_VerticesNum;

	oe_v3*			m_Vertices;
	oe_v3*			m_Normals;
	oe_v2*			m_TexCoords0;
	oe_v2*			m_TexCoords1;

	bool			m_TexCoords0Use;
	bool			m_TexCoords1Use;
	bool			m_NormalsUse;

	int				m_IndexMode;		// 0 for simple triangle list

	int				m_IndicesNum;		// this is the size of the following array:
	int*			m_Indices;			// ie in plain tri-list, IndicesNum = TrianglesNum * 3

	bool			m_TouchedVerts;
	bool			m_TouchedNorms;
	bool			m_TouchedTexs0;
	bool			m_TouchedTexs1;
	bool			m_TouchedIndxs;


	oxe_3DMaterial	m_Material;

	oxe_MDF			m_MDF1;				// for the donut...

					oxe_3DObj();
	~				oxe_3DObj();

	virtual	int		VerticesNumSet			(int num	);
	virtual	long	VerticesNumGet			(			)			{ return m_VerticesNum;	}
	virtual	int		IndicesNumSet			(int num	);
	virtual	long	IndicesNumGet			(			)			{ return m_IndicesNum;	}
	virtual	void	TouchVerts				(			)			{ m_TouchedVerts = true;}
	virtual	void	TouchNorms				(			)			{ m_TouchedNorms = true;}
	virtual	void	TouchTexs0				(			)			{ m_TouchedTexs0 = true;}
	virtual	void	TouchTexs1				(			)			{ m_TouchedTexs1 = true;}
	virtual	void	TouchIndxs				(			)			{ m_TouchedIndxs = true;}
	virtual	void	Touch					(			)
						{
						TouchVerts();
						TouchNorms();
						TouchTexs0();
						TouchTexs1();
						TouchTexs1();
//						TouchIndxs();
						}
	virtual	void	UnTouchVerts			(			)=0;	// PURE VIRTUAL
	virtual	void	UnTouchNorms			(			)=0;	// PURE VIRTUAL
	virtual	void	UnTouchTexs0			(			)=0;	// PURE VIRTUAL
	virtual	void	UnTouchTexs1			(			)=0;	// PURE VIRTUAL
	virtual	void	UnTouchIndxs			(			)=0;	// PURE VIRTUAL
	virtual	void	UnTouch					(			)
						{
						UnTouchVerts();
						UnTouchNorms();
						UnTouchTexs0();
						UnTouchTexs1();
						UnTouchIndxs();
						}

	virtual	void	TexSet					(const char* fn)=0;	// PURE VIRTUAL

	void			MakeCube				(oe_scalar radius = 0.5f);
	void			MakeDonut				(
											oe_scalar	rMajor,
											oe_scalar	rMinor,
											unsigned short	segsMajor,
											unsigned short	segsMinor,
											oe_scalar	majPertFreq	=	0.0f,
											oe_scalar	majPertAmp	=	0.0f,
											oe_scalar	majPertPhase=	0.0f,
											oe_scalar	majTwists	=	0.0f,
											oe_scalar	twistAmp	=	0.0f,
											oe_scalar	twistOffset	=	0.0f,
											oe_scalar	twistRate	=	0.0f,
											oe_scalar	t			=	0.0f,
											int			flags		=   0
											);

	void			MakeNormalsSpherical	(oe_v3& origin);
	void			MakeNormalsSpherical	();

	};


#endif	//	_OXE_3D_OBJ_H_
