/*

  oxe_3DMaterial

  */

#ifndef	_OXE_3D_MATERIAL_H_
#define	_OXE_3D_MATERIAL_H_

#include "oe_v3.h"
#include "oe_v4.h"
#include "oe_std.h"
#include "oxe_Rend.h"

class oxe_3DMaterial
{
	public:

	oe_v4		m_Ambient;
	oe_v4		m_Diffuse;
	oe_v4		m_Specular;
	oe_v4		m_Emissive;
	oe_scalar	m_SpecularPower;

	int			m_DrawNormals;
	int			m_Cull;
	int			m_Fill;

	bool				m_EnvironmentMapped;
	bool				m_AlphaBlended;
	unsigned char		m_SrcBlendFactor;
	unsigned char		m_DstBlendFactor;

	int					m_SrcBlendMode;
	int					m_DstBlendMode;

	bool				m_Touched;
	void*				m_RendererData;					// this belongs to the current renderer, not you.

	public:

					oxe_3DMaterial			();
	void			Touch					()				{ m_Touched = true;				}
	void			SetRendererData			(void* rd)		{ m_RendererData = rd;			}
	};



#endif	//	_OXE_3D_MATERIAL_H_

