// oxeDlgMaterial.cpp : implementation file
//

#include "thefinaldonut.h"
#include "oxeDlgMaterial.h"
#include "TheFinalDonutDlg.h"
#include "oxe_MFCUtils.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// oxeDlgMaterial dialog


oxeDlgMaterial::oxeDlgMaterial(CWnd* pParent /*=NULL*/)
	: CDialog(oxeDlgMaterial::IDD, pParent)
	{
	//{{AFX_DATA_INIT(oxeDlgMaterial)
	//}}AFX_DATA_INIT
	
//	m_TFDD	=	NULL;
	m_pM	=	NULL;
	m_pR	=	NULL;
	m_pG	=	NULL;
	m_pB	=	NULL;
	m_pA	=	NULL;
	m_pS	=	NULL;
	}


void oxeDlgMaterial::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(oxeDlgMaterial)
	DDX_Control(pDX, IDC_BUTTON_FILL, m_GUI_Button_Fill);
	DDX_Control(pDX, IDC_BUTTON_CULL, m_GUI_Button_Cull);
	DDX_Control(pDX, IDC_CHECK_NORMS, m_GUI_Check_Norms);
	DDX_Control(pDX, IDC_EDIT5, m_GUI_EditS);
	DDX_Control(pDX, IDC_EDIT4, m_GUI_EditA);
	DDX_Control(pDX, IDC_EDIT3, m_GUI_EditB);
	DDX_Control(pDX, IDC_EDIT2, m_GUI_EditG);
	DDX_Control(pDX, IDC_EDIT1, m_GUI_EditR);
	DDX_Control(pDX, IDC_SLIDER5, m_GUI_SliderS);
	DDX_Control(pDX, IDC_SLIDER4, m_GUI_SliderA);
	DDX_Control(pDX, IDC_SLIDER3, m_GUI_SliderB);
	DDX_Control(pDX, IDC_SLIDER2, m_GUI_SliderG);
	DDX_Control(pDX, IDC_SLIDER1, m_GUI_SliderR);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(oxeDlgMaterial, CDialog)
	//{{AFX_MSG_MAP(oxeDlgMaterial)
	ON_BN_CLICKED(IDC_BUTTON2, OnDiffuse)
	ON_BN_CLICKED(IDC_BUTTON3, OnSpecular)
	ON_BN_CLICKED(IDC_BUTTON4, OnAmbient)
	ON_BN_CLICKED(IDC_BUTTON5, OnEmissive)
	ON_EN_CHANGE(IDC_EDIT1, OnChangeEdits)
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_CHECK_NORMS, OnCheckNorms)
	ON_BN_CLICKED(IDC_BUTTON_FILL, OnButtonFill)
	ON_EN_CHANGE(IDC_EDIT2, OnChangeEdits)
	ON_EN_CHANGE(IDC_EDIT3, OnChangeEdits)
	ON_EN_CHANGE(IDC_EDIT4, OnChangeEdits)
	ON_EN_CHANGE(IDC_EDIT5, OnChangeEdits)
	ON_BN_CLICKED(IDC_BUTTON_CULL, OnButtonCull)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// oxeDlgMaterial message handlers


void	oxeDlgMaterial::EnableControls()
	{
	int	enable;

	if (m_pM)
		enable	=	TRUE;
	else
		enable	=	FALSE;

	m_GUI_SliderR	.	EnableWindow(enable);
	m_GUI_SliderG	.	EnableWindow(enable);
	m_GUI_SliderB	.	EnableWindow(enable);
	m_GUI_SliderA	.	EnableWindow(enable);
	m_GUI_SliderS	.	ShowWindow(0);
	m_GUI_EditR		.	EnableWindow(enable);
	m_GUI_EditG		.	EnableWindow(enable);
	m_GUI_EditB		.	EnableWindow(enable);
	m_GUI_EditA		.	EnableWindow(enable);
	m_GUI_EditS		.	ShowWindow(0);
	}


void oxeDlgMaterial::AttachColor(oe_v4* color)
	{
	if (!color)
		{
		m_pR	=	NULL;
		m_pG	=	NULL;
		m_pB	=	NULL;
		m_pA	=	NULL;
		m_pS	=	NULL;
		}
	else
		{
		m_pR	=	color -> m_Value + OE_X;
		m_pG	=	color -> m_Value + OE_Y;
		m_pB	=	color -> m_Value + OE_Z;
		m_pA	=	color -> m_Value + OE_W;
		}

	ValsToEdits();
	}



void	oxeDlgMaterial::ValsToEdits()
	{
	char	s[16];

	m_Semaphor1	=	1;


	if (m_pR)
		sprintf(s, "%.2g", *m_pR);
	else
		strcpy(s, "---");
	m_GUI_EditR.SetWindowText(s);

	if (m_pG)
		sprintf(s, "%.2g", *m_pG);
	else
		strcpy(s, "---");
	m_GUI_EditG.SetWindowText(s);

	if (m_pB)
		sprintf(s, "%.2g", *m_pB);
	else
		strcpy(s, "---");
	m_GUI_EditB.SetWindowText(s);

	if (m_pA)
		sprintf(s, "%.2g", *m_pA);
	else
		strcpy(s, "---");
	m_GUI_EditA.SetWindowText(s);

	if (m_pS)
		sprintf(s, "%.2g", *m_pS);
	else
		strcpy(s, "---");
	m_GUI_EditS.SetWindowText(s);
	
	m_Semaphor1	=	0;
	}


void	oxeDlgMaterial::ValsToSliders()
	{
	if (m_pR)
		oxe_SliderSet(&m_GUI_SliderR, 0.0f, 1.0f	, *m_pR);
	if (m_pG)
		oxe_SliderSet(&m_GUI_SliderG, 0.0f, 1.0f	, *m_pG);
	if (m_pB)
		oxe_SliderSet(&m_GUI_SliderB, 0.0f, 1.0f	, *m_pB);
	if (m_pA)
		oxe_SliderSet(&m_GUI_SliderA, 0.0f, 1.0f	, *m_pA);
	if (m_pS)
		oxe_SliderSet(&m_GUI_SliderS, 0.0f, 100.0f	, *m_pS);

	}

void	oxeDlgMaterial::SlidersToVals()
	{
	if (m_pR)
		oxe_SliderGet(&m_GUI_SliderR, 0.0f, 1.0f	, m_pR);
	if (m_pG)
		oxe_SliderGet(&m_GUI_SliderG, 0.0f, 1.0f	, m_pG);
	if (m_pB)
		oxe_SliderGet(&m_GUI_SliderB, 0.0f, 1.0f	, m_pB);
	if (m_pA)
		oxe_SliderGet(&m_GUI_SliderA, 0.0f, 1.0f	, m_pA);
	if (m_pS)
		oxe_SliderGet(&m_GUI_SliderS, 0.0f, 100.0f	, m_pS);

	if (m_pM)
		m_pM->Touch();

	}

	
void oxeDlgMaterial::OnDiffuse() 
{
	EnableControls();
	AttachColor(&m_pM -> m_Diffuse);
	ValsToSliders();
}

void oxeDlgMaterial::OnSpecular() 
{
	EnableControls();
	m_pS	=	&m_pM -> m_SpecularPower;
	AttachColor(&m_pM -> m_Specular);
	m_GUI_EditS		.ShowWindow(TRUE);
	m_GUI_SliderS	.ShowWindow(TRUE);
	ValsToSliders();
}

void oxeDlgMaterial::OnAmbient() 
{
	EnableControls();
	AttachColor(&m_pM -> m_Ambient);
	ValsToSliders();
}

void oxeDlgMaterial::OnEmissive() 
{
	EnableControls();
	AttachColor(&m_pM -> m_Emissive);
	ValsToSliders();
}

void oxeDlgMaterial::OnChangeEdits() 
{
	if (m_Semaphor1 != 0)
		return;

	oe_scalar	r, g, b, a, s;
	CString		cs;

	m_GUI_EditR.GetWindowText(cs);
	r	=	(oe_scalar)atof(cs);
	m_GUI_EditG.GetWindowText(cs);
	g	=	(oe_scalar)atof(cs);
	m_GUI_EditB.GetWindowText(cs);
	b	=	(oe_scalar)atof(cs);
	m_GUI_EditA.GetWindowText(cs);
	a	=	(oe_scalar)atof(cs);
	m_GUI_EditS.GetWindowText(cs);
	s	=	(oe_scalar)atof(cs);

	if (m_pR)
		*m_pR	=	r;
	if (m_pG)
		*m_pG	=	g;
	if (m_pB)
		*m_pB	=	b;
	if (m_pA)
		*m_pA	=	a;
	if (m_pS)
		*m_pS	=	s;
	
	if (m_pM)
		{
		m_pM ->Touch();
		}

	ValsToSliders();

}

BOOL oxeDlgMaterial::OnInitDialog() 
{
	CDialog::OnInitDialog();


	oxe_SliderInit(&m_GUI_SliderR);
	oxe_SliderInit(&m_GUI_SliderG);
	oxe_SliderInit(&m_GUI_SliderB);
	oxe_SliderInit(&m_GUI_SliderA);
	oxe_SliderInit(&m_GUI_SliderS);

	OnDiffuse();

	ValsToGUI();
	
	return TRUE;
}

void oxeDlgMaterial::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SlidersToVals();
	ValsToEdits();

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void oxeDlgMaterial::OnCheckNorms() 
{
	if (!m_pM)
		return;

	if (m_GUI_Check_Norms.GetCheck() & 3)
		m_pM	->	m_DrawNormals	=	1;
	else
		m_pM	->	m_DrawNormals	=	0;

}

void oxeDlgMaterial::ValsToGUI()
	{
	if (!m_pM)
		return;

	ValsToSliders	();
	ValsToEdits		();
	ValsToButtons	();
	}


void oxeDlgMaterial::ValsToButtons()
	{
	if (!m_pM)
		return;

	char*	s;


	if (m_pM -> m_DrawNormals)
		m_GUI_Check_Norms.SetCheck(TRUE);
	else
		m_GUI_Check_Norms.SetCheck(!TRUE);

	switch	(m_pM -> m_Fill)
		{
		default:
		case HR_FILL_SOLID:
			s	=	"sld";
			break;

		case HR_FILL_LINE:
			s	=	"lin";
			break;
			
		case HR_FILL_POINT:
			s	=	"pnt";
			break;
		}

	m_GUI_Button_Fill.SetWindowText(s);

	switch	(m_pM -> m_Cull)
		{
		default:
		case HR_CULL_BACK:
			s	=	"bak";
			break;

		case HR_CULL_FRONT:
			s	=	"frt";
			break;
			
		case HR_CULL_NONE:
			s	=	"nun";
			break;
		}

	m_GUI_Button_Cull.SetWindowText(s);

	}


void oxeDlgMaterial::OnButtonFill() 
	{
	if (!m_pM)
		return;

	switch (m_pM -> m_Fill)
		{
		default:
		case HR_FILL_SOLID:
			m_pM	->	m_Fill	=	HR_FILL_LINE;
			break;

		case HR_FILL_LINE:
			m_pM	->	m_Fill	=	HR_FILL_POINT;
			break;
			
		case HR_FILL_POINT:
			m_pM	->	m_Fill	=	HR_FILL_SOLID;
			break;
		}

	ValsToButtons();
	}




void oxeDlgMaterial::OnButtonCull() 
	{
	if (!m_pM)
		return;

	switch (m_pM -> m_Cull)
		{
		default:
		case HR_CULL_BACK:
			m_pM	->	m_Cull	=	HR_CULL_FRONT;
			break;

		case HR_CULL_FRONT:
			m_pM	->	m_Cull	=	HR_CULL_NONE;
			break;
			
		case HR_CULL_NONE:
			m_pM	->	m_Cull	=	HR_CULL_BACK;
			break;
		}

	ValsToButtons();
	}
