/*

  oe_voidlist

  A dynamic array of pointers to voids

  */



#ifndef	_OE_VOISLIST_H_
#define	_OE_VOISLIST_H_

#include "oe_std.h"

class	oe_VoidList
	{
	/////////////////////////
	// Data
	public:

	void**	list;
	int		numItems;


	/////////////////////////
	// Routines
	public:

	oe_VoidList();
	virtual ~oe_VoidList();

	virtual void					Empty		();
	virtual void					Append		(void* newItem, int num = 1);
	virtual void					Insert		(void* newItem, int addBefore, int num = 1);
	virtual void					Remove		(int which, int num = 1);
	virtual int						GetLength	()					{ return numItems; }
	virtual	int						GetNum		()					{return numItems;};
	virtual void					Trunkate	(int start);
	virtual void* &					operator[]	(int i)	const;
	virtual void* *					GetListPtr	()					{ return list; }
	virtual int						IsMember	(void* itemID, int &slot);
	virtual int						IsMember	(void* itemID);
	virtual	void					Duplicate	(oe_VoidList &src);
	};

inline void*&	oe_VoidList::operator[](int i)const
	{
		return(list[i]);
	}


inline int	oe_VoidList::IsMember(void* itemID, int &slot)
	{
	int	i;

	slot = -1;

	if (numItems == 0)
		return 0;

	for (i = 0; i < numItems; i++) {
		if (list[i] == itemID) {
			slot = i;
			return 1;
			}
		}

	return 0;
	}

inline int	oe_VoidList::IsMember(void* itemID)
	{
	int	i;

	return(IsMember(itemID, i));
	}




#endif	//	_OE_VOISLIST_H_
