/*

  oe_voidlist

  A dynamic array of pointers to voids

  */

#include "oe_VoidList.h"

oe_VoidList::oe_VoidList()
	{
	list		= NULL;
	numItems	= 0;
	}


oe_VoidList::~oe_VoidList()
	{
	if (list != NULL) {
		delete [] list;
		list = NULL;
		}
	numItems = 0;
	}



void	oe_VoidList::Append(void* newItem, int num)
	{
	void**	newList;
	int		newNumItems;
	int		i;

	if (num == 0)
		return;

	newNumItems = numItems + num;

	newList = new void*[newNumItems];

	////////////////////////////////
	// Copy & remove the old list.
	// (Note - it is possible to have numItems == 0 and list != NULL)
	if (list) {
		for (i = 0; i < numItems; i++)
			newList[i] = list[i];
		delete [] list;
		}

	////////////////////////////////
	// Add the new item(s).
	for (i = numItems; i < newNumItems; i++)
		newList[i] = newItem;

	////////////////////////////////
	// Hail the new list.
	list = newList;
	numItems = newNumItems;
	}


void	oe_VoidList::Insert(void* newItem, int addBefore, int num)
	{
	void**	newList;
	int		newNumItems, i, j;

	if (num == 0)
		return;

	newNumItems = numItems + num;

	newList = new void*[newNumItems];

	////////////////////////////////
	// Copy beginning of the old list.

	for (i = 0; i < addBefore; i++)
		newList[i] = list[i];
	// add item
	newList[i++] = newItem;

	// copy end of old list
	for (j = addBefore; j < numItems; j++, i++)
			newList[i] = list[j];

	delete [] list;

	////////////////////////////////
	// Hail the new list.
	list = newList;
	numItems = newNumItems;
	}


void	oe_VoidList::Remove(int which, int num)
	{
	void**	newList;
	int		newNumItems, i, j;

	if (num <= 0 || which >= numItems)
		return;

	newNumItems = numItems - num;

	newList = new void*[newNumItems];

	////////////////////////////////
	// Copy & remove the old list.
	for (i = 0; i < which; i++)
		newList[i] = list[i];

	for (j = which + num; j < numItems; j++, i++)
		newList[i] = list[j];

	delete [] list;
		
	////////////////////////////////
	// Hail the new list.
	list = newList;
	numItems = newNumItems;
	
	}


void	oe_VoidList:: Duplicate(oe_VoidList &src)
	{
	int		i;


	numItems = src.numItems;

	if (list)
		delete [] list;

	list = new void*[numItems];

	if (!list)
		return;

	for (i = 0; i < numItems; i++)
		list[i] = src.list[i];
	}


void	oe_VoidList::Trunkate(int start)
	{
	Remove(start, numItems - start);
	}


void	oe_VoidList::Empty()
	{
	if (numItems > 0) {

		delete [] list;
		list		= NULL;
		numItems	= 0;
		}
	}

