/*

	oxe_matrix

*/

#ifndef	_OE_MATRIX_H_
#define	_OE_MATRIX_H_


#include "oe_v3.h"

#define	OE_00	 0
#define	OE_01	 1
#define	OE_02	 2
#define	OE_03	 3
#define	OE_10	 4
#define	OE_11	 5
#define	OE_12	 6
#define	OE_13	 7
#define	OE_20	 8
#define	OE_21	 9
#define	OE_22	10
#define	OE_23	11
#define	OE_30	12
#define	OE_31	13
#define	OE_32	14
#define	OE_33	15


class	oe_matrix4
	{
	public:

	oe_scalar	m_Data[16];

	void	MakeIdentity	();
	void	MakeZero		();
	void	MakeRotate		(int primaryAxis, oe_scalar radians);
	void	MakeScale		(oe_v3& v);
	void	MakeScale		(oe_scalar x, oe_scalar y, oe_scalar z);
	void	MakeTranslate	(oe_v3& v);
	void	MakeTranslate	(oe_scalar x, oe_scalar y, oe_scalar z);

	void	MakeProjection	(oe_scalar nr, oe_scalar fr, oe_scalar fov_X, oe_scalar fov_Y);

	void	PreMult			(oe_matrix4& src, oe_matrix4& dst);
	void	PostMult		(oe_matrix4& src, oe_matrix4& dst);

	void	Copy			(oe_matrix4& src);
	};



#endif	//	_OE_MATRIX_H_
