
#include "oe_matrix.h"
#include <memory.h>
#include <math.h>


void	oe_matrix4::MakeZero()
	{
	oe_scalar*	f;

	f		=	m_Data;

	*f++	=	0.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;

	*f++	=	0.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;
	
	*f++	=	0.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;
	
	*f++	=	0.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;
	*f		=	0.0f;
	}

void	oe_matrix4::MakeIdentity()
	{
	oe_scalar*	f;

	f		=	m_Data;

	*f++	=	1.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;

	*f++	=	0.0f;
	*f++	=	1.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;
	
	*f++	=	0.0f;
	*f++	=	0.0f;
	*f++	=	1.0f;
	*f++	=	0.0f;
	
	*f++	=	0.0f;
	*f++	=	0.0f;
	*f++	=	0.0f;
	*f		=	1.0f;
	}

void	oe_matrix4::MakeRotate(int primaryAxis, oe_scalar radians)
	{
	oe_scalar*	f;
	oe_scalar	s, c;

	s	=	oe_sin(radians);
	c	=	oe_cos(radians);

	f	=	m_Data;

	MakeIdentity();

	switch(primaryAxis)
		{
		default:
			break;
		case OE_X:
			m_Data[ 5]	=	 c;
			m_Data[ 6]	=	 s;
			m_Data[ 9]	=	-s;
			m_Data[10]	=	 c;
			break;
		case OE_Y:
			m_Data[ 0]	=	 c;
			m_Data[ 2]	=	-s;
			m_Data[ 8]	=	 s;
			m_Data[10]	=	 c;
			break;
		case OE_Z:
			m_Data[ 0]	=	 c;
			m_Data[ 1]	=	 s;
			m_Data[ 4]	=	-s;
			m_Data[ 5]	=	 c;
			break;
		}
	}

void	oe_matrix4::MakeScale(oe_v3& v)
	{
	MakeIdentity();
	m_Data[ 0]	=	v.m_Value[0];
	m_Data[ 5]	=	v.m_Value[1];
	m_Data[10]	=	v.m_Value[2];
	}

void	oe_matrix4::MakeScale(oe_scalar x, oe_scalar y, oe_scalar z)
	{
	MakeIdentity();
	m_Data[ 0]	=	x;
	m_Data[ 5]	=	y;
	m_Data[10]	=	z;
	}

void	oe_matrix4::MakeTranslate(oe_v3& v)
	{
	MakeIdentity();
	m_Data[12]	=	v.m_Value[0];
	m_Data[13]	=	v.m_Value[1];
	m_Data[14]	=	v.m_Value[2];
	}

void	oe_matrix4::MakeTranslate(oe_scalar x, oe_scalar y, oe_scalar z)
	{
	MakeIdentity();
	m_Data[12]	=	x;
	m_Data[13]	=	y;
	m_Data[14]	=	z;
	}


void	oe_matrix4::MakeProjection(oe_scalar nr, oe_scalar fr, oe_scalar fov_X, oe_scalar fov_Y)
{
	oe_scalar	h, w, Q;

	w = 1.0f/oe_tan(fov_X	*	0.5f);
	h = 1.0f/oe_tan(fov_Y	*	0.5f);
	Q = fr/(fr - nr);

	MakeZero();

	m_Data[OE_00]	=	 w;
	m_Data[OE_11]	=	 h;
	m_Data[OE_22]	=	-Q;
	m_Data[OE_32]	=	-Q * nr;
	m_Data[OE_23]	=	-1;
}   

void	oe_matrix4::PreMult(oe_matrix4& src, oe_matrix4& dst)
	{
	oe_matrix4	tmp;
	oe_scalar*	f1;
	oe_scalar*	f2;
	oe_scalar*	fdst;

	tmp.Copy(*this);

	f1		=	tmp.m_Data;
	f2		=	src.m_Data;
	fdst	=	dst.m_Data;

	*fdst++		=	f1[OE_00] * f2[OE_00] +
					f1[OE_01] * f2[OE_10] +
					f1[OE_02] * f2[OE_20] +
					f1[OE_03] * f2[OE_30];
	
	*fdst++		=	f1[OE_00] * f2[OE_01] +
					f1[OE_01] * f2[OE_11] +
					f1[OE_02] * f2[OE_21] +
					f1[OE_03] * f2[OE_31];
	
	*fdst++		=	f1[OE_00] * f2[OE_02] +
					f1[OE_01] * f2[OE_12] +
					f1[OE_02] * f2[OE_22] +
					f1[OE_03] * f2[OE_32];
	
	*fdst++		=	f1[OE_00] * f2[OE_03] +
					f1[OE_01] * f2[OE_13] +
					f1[OE_02] * f2[OE_23] +
					f1[OE_03] * f2[OE_33];
	
	*fdst++		=	f1[OE_10] * f2[OE_00] +
					f1[OE_11] * f2[OE_10] +
					f1[OE_12] * f2[OE_20] +
					f1[OE_13] * f2[OE_30];
	
	*fdst++		=	f1[OE_10] * f2[OE_01] +
					f1[OE_11] * f2[OE_11] +
					f1[OE_12] * f2[OE_21] +
					f1[OE_13] * f2[OE_31];
	
	*fdst++		=	f1[OE_10] * f2[OE_02] +
					f1[OE_11] * f2[OE_12] +
					f1[OE_12] * f2[OE_22] +
					f1[OE_13] * f2[OE_32];
	
	*fdst++		=	f1[OE_10] * f2[OE_03] +
					f1[OE_11] * f2[OE_13] +
					f1[OE_12] * f2[OE_23] +
					f1[OE_13] * f2[OE_33];
	
	*fdst++		=	f1[OE_20] * f2[OE_00] +
					f1[OE_21] * f2[OE_10] +
					f1[OE_22] * f2[OE_20] +
					f1[OE_23] * f2[OE_30];
	
	*fdst++		=	f1[OE_20] * f2[OE_01] +
					f1[OE_21] * f2[OE_11] +
					f1[OE_22] * f2[OE_21] +
					f1[OE_23] * f2[OE_31];
	
	*fdst++		=	f1[OE_20] * f2[OE_02] +
					f1[OE_21] * f2[OE_12] +
					f1[OE_22] * f2[OE_22] +
					f1[OE_23] * f2[OE_32];
	
	*fdst++		=	f1[OE_20] * f2[OE_03] +
					f1[OE_21] * f2[OE_13] +
					f1[OE_22] * f2[OE_23] +
					f1[OE_23] * f2[OE_33];
	
	*fdst++		=	f1[OE_30] * f2[OE_00] +
					f1[OE_31] * f2[OE_10] +
					f1[OE_32] * f2[OE_20] +
					f1[OE_33] * f2[OE_30];
	
	*fdst++		=	f1[OE_30] * f2[OE_01] +
					f1[OE_31] * f2[OE_11] +
					f1[OE_32] * f2[OE_21] +
					f1[OE_33] * f2[OE_31];
	
	*fdst++		=	f1[OE_30] * f2[OE_02] +
					f1[OE_31] * f2[OE_12] +
					f1[OE_32] * f2[OE_22] +
					f1[OE_33] * f2[OE_32];
	
	*fdst++		=	f1[OE_30] * f2[OE_03] +
					f1[OE_31] * f2[OE_13] +
					f1[OE_32] * f2[OE_23] +
					f1[OE_33] * f2[OE_33];
	}


void	oe_matrix4::PostMult(oe_matrix4& src, oe_matrix4& dst)
	{
	}

void	oe_matrix4::Copy(oe_matrix4& src)
	{
	memcpy(m_Data, src.m_Data, sizeof(oe_scalar) * 16);
	}