/*

  oe_fluid2.h


  lord hack's 2d fluid dynamics
  
  */

#include "oe_v2.h"


#define	OE_F2C_CONSTYLE_CIRCLE_LINEAR	0		// connectivity is a simple linear-falloff circle

typedef struct 
	{
	float	radius;		// distance at which connectivity goes to zero
	} OE_F2C_CONSTYLE_CIRCLE_LINEAR_Params;


class oe_fluid2cell
	{
	public:
	oe_v2	m_Velocity;
	int		m_PosX;					// location in parent array
	int		m_PosY;					// location in parent array
	};

class oe_fluid2
	{
	public:

	oe_fluid2cell*	m_Cells;		// w * h elements. see allocation for order
	int				m_CellsW;
	int				m_CellsH;

	public:

		oe_fluid2		();
	~	oe_fluid2		();

	void	SizeSet		(int w, int h);
	void	Pulse		(float dt = 1.0f/60.0f);
	void	VelocitySet	(float vx, float vy);

	void	MakeConnectivity	(int style, void* params);
	void	MakeConnectivity	(OE_F2C_CONSTYLE_CIRCLE_LINEAR_Params* params);

	
	};


