/*

  oe_fluid2.h


  lord hack's 2d fluid dynamics
  
  */

#include "oe_fluid2.h"
#include "oe_std.h"
#include "stdlib.h"


oe_fluid2::oe_fluid2()
	{
	m_CellsW	=	0;
	m_CellsH	=	0;
	m_Cells		=	NULL;
	}

oe_fluid2::~oe_fluid2()
	{
	SizeSet(0, 0);
	}

void	oe_fluid2::SizeSet(int w, int h)
	{
	if (w == m_CellsW && h == m_CellsH)
		return;

	OE_DELETEARRAY(m_Cells);
	m_CellsW	=	0;
	m_CellsH	=	0;

	if (w == m_CellsW && h == m_CellsH)
		return;


	m_CellsW	=	w;
	m_CellsH	=	h;

	m_Cells	=	new	oe_fluid2cell[w * h];

	int				i, j;
	oe_fluid2cell*	fc;
	
	fc		=	m_Cells;

	for (j = 0; j < h; j++)
		{
		for (i = 0; i < w; i++)
			{
			fc -> m_PosX = i;
			fc -> m_PosY = j;
			fc++;
			}
		}
	}

void	oe_fluid2::MakeConnectivity(int style, void* params)
	{
	switch (style)
		{
		default:
			break;
		case OE_F2C_CONSTYLE_CIRCLE_LINEAR:
			MakeConnectivity((OE_F2C_CONSTYLE_CIRCLE_LINEAR_Params*)params);
			break;

		}

	}


void	oe_fluid2::MakeConnectivity(OE_F2C_CONSTYLE_CIRCLE_LINEAR_Params* params)
	{
	}


extern	float	g_RotRad;
extern	float	g_RotOff;
extern	float	g_RotFac;
extern	int		g_RotStyle;
extern	float	g_RotCenX;
extern	float	g_RotCenY;
extern	int		g_ResetMode;
extern	float	g_Len;


void	oe_fluid2::Pulse(float dt)
	{
	int				i, inum;
	oe_fluid2cell*	fc;
	oe_v2			v1;

	inum	=	m_CellsW * m_CellsH;
	fc		=	m_Cells;

	float	g;
	float	x;
	float	y;


	for (i = 0; i < inum; i++)
		{
		x	=	(float)(fc->m_PosX) + 0.5f - ((float)m_CellsW * g_RotCenX);
		y	=	(float)(fc->m_PosY) + 0.5f - ((float)m_CellsH * g_RotCenY);

		switch (g_RotStyle)
			{
			case 1:
			default:
				g	=	sqrtf(x*x + y*y);
				break;
			case 2:
				g	=	sinf(x*.4f) + sinf(y*.4f);
				break;				
			}


		fc->m_Velocity.Rot((g * g_RotRad + g_RotOff)*g_RotFac, v1);
		fc->m_Velocity = v1;
		fc++;
		}
	}

void	oe_fluid2::VelocitySet(float vx, float vy)
	{
	int				i, inum;
	oe_fluid2cell*	fc;

	inum	=	m_CellsW * m_CellsH;

	oe_v2		v1;
	oe_v2		v2;
	oe_scalar	x;
	oe_scalar	y;


	v1.Set(vx, vy);

	for (i = 0; i < inum; i++)
		{
		fc	=	&(m_Cells[i]);

		switch (g_ResetMode)
			{
			default:
			case 0:
				fc -> m_Velocity	=	v1;
				break;
			case 1:
				x	=	(float)(fc->m_PosX) + 0.5f - ((float)m_CellsW * g_RotCenX);
				y	=	(float)(fc->m_PosY) + 0.5f - ((float)m_CellsH * g_RotCenY);
				fc -> m_Velocity.Set(x, y);
				break;
			case 2:
				x	=	(float)(fc->m_PosX) + 0.5f - ((float)m_CellsW * g_RotCenX);
				y	=	(float)(fc->m_PosY) + 0.5f - ((float)m_CellsH * g_RotCenY);
				fc -> m_Velocity.Set(x, y);
				fc -> m_Velocity.Rot((float)(rand() % 33333)/33333.0f * OE_2PI, fc -> m_Velocity);
				break;
			}

		fc -> m_Velocity.Norm(g_Len, fc -> m_Velocity);
		}
	}
