// fluid3Dlg.h : header file
//

#if !defined(AFX_FLUID3DLG_H__6F4F1202_AD7A_4617_B886_4ABBD26643A5__INCLUDED_)
#define AFX_FLUID3DLG_H__6F4F1202_AD7A_4617_B886_4ABBD26643A5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "oe_fluid2.h"

#define OE_MOVECTRLS_MODE_TOP	0x01
#define OE_MOVECTRLS_MODE_LEFT	0x02
#define OE_MOVECTRLS_MODE_RIGHT	0x04
#define OE_MOVECTRLS_MODE_BOT	0x08
#define OE_MOVECTRLS_MODE_H		(OE_MOVECTRLS_MODE_RIGHT	| OE_MOVECTRLS_MODE_LEFT)
#define OE_MOVECTRLS_MODE_V		(OE_MOVECTRLS_MODE_TOP		| OE_MOVECTRLS_MODE_BOT	)
#define OE_MOVECTRLS_MODE_TL	(OE_MOVECTRLS_MODE_TOP		| OE_MOVECTRLS_MODE_LEFT)
#define OE_MOVECTRLS_MODE_BR	(OE_MOVECTRLS_MODE_RIGHT	| OE_MOVECTRLS_MODE_BOT	)
#define OE_MOVECTRLS_MODE_ALL	(OE_MOVECTRLS_MODE_TL		| OE_MOVECTRLS_MODE_BR	)


/////////////////////////////////////////////////////////////////////////////
// CFluid3Dlg dialog

class CFluid3Dlg : public CDialog
{
	public:

	oe_fluid2		m_Fluid;
	float			m_PlaySpeed;
	float			m_PauseSpeed;

	CToolTipCtrl	m_ToolTips;

	CWnd*			m_MoveCtrls			[256];
	int				m_MoveCtrlsInitialX	[256];
	int				m_MoveCtrlsInitialY	[256];
	int				m_MoveCtrlsMode		[256];
	int				m_MoveCtrlsNum;
	int				m_OrigSX, m_OrigSY;

	float			m_RotCenX;
	float			m_RotCenY;

	bool			m_StorePhase;

	int				m_ReversePeriod;
	int				m_ReversePeriodCountDown;
	int				m_RecenterPeriod;
	int				m_RecenterPeriodCountDown;
	


//	doublebuffer stuff
//	http://orchard.wccnet.org/~chasselb/win293/ClassNotes/Bitmaps1.html

    CDC*			m_pdcMemory;
    CBitmap*		m_pBitmap;
	bool			m_NeedResize;


	public:
	void	Pulse			();
	void	FluidDisplay	();

	void	LoadSettings	(const char* name);
	void	SaveSettings	(const char* name);

	void	AddMoveCtrl		(CWnd* cwnd, int mode = OE_MOVECTRLS_MODE_ALL);

	void	DoDrop			(HDROP hDrop);
		

// Construction
public:
	CFluid3Dlg(CWnd* pParent = NULL);	// standard constructor
	~CFluid3Dlg();

// Dialog Data
	//{{AFX_DATA(CFluid3Dlg)
	enum { IDD = IDD_FLUID3_DIALOG };
	CButton	m_GUI_Button_11;
	CButton	m_GUI_Button_10;
	CButton	m_GUI_Button_9;
	CButton	m_GUI_Button_8;
	CButton	m_GUI_Button_7;
	CButton	m_GUI_Button_6;
	CStatic	m_GUI_Static_Ho9;
	CStatic	m_GUI_Static_Ho8;
	CEdit	m_GUI_Edit_Cen;
	CEdit	m_GUI_Edit_Rev;
	CButton	m_GUI_Check_Phase;
	CStatic	m_GUI_Static_Ho7;
	CButton	m_GUI_Button_3;
	CButton	m_GUI_Check_Cross;
	CButton	m_GUI_Button_R;
	CButton	m_GUI_Button_P;
	CButton	m_GUI_Button_FR;
	CButton	m_GUI_Button_FF;
	CButton	m_GUI_Button_F;
	CStatic	m_GUI_Static_Ho6;
	CStatic	m_GUI_Static_Ho5;
	CStatic	m_GUI_Static_Ho4;
	CStatic	m_GUI_Static_Ho3;
	CStatic	m_GUI_Static_Ho2;
	CStatic	m_GUI_Static_Ho1;
	CButton	m_GUI_Button_5;
	CButton	m_GUI_Button_4;
	CButton	m_GUI_Button_2;
	CButton	m_GUI_Button_1;
	CButton	m_GUI_Check_Tail;
	CButton	m_GUI_Check_Dash;
	CButton	m_GUI_Check_Dot;
	CEdit	m_GUI_Edit7;
	CEdit	m_GUI_Edit_RotFac;
	CEdit	m_GUI_Edit_RotOff;
	CEdit	m_GUI_Edit_RotRad;
	CEdit	m_GUI_Edit_Len;
	CEdit	m_GUI_Edit_W;
	CEdit	m_GUI_Edit_H;
	CStatic	m_GUI_Static_Hi;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFluid3Dlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CFluid3Dlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnChangeEdit1();
	afx_msg void OnChangeEdit3();
	afx_msg void OnChangeEdit4();
	afx_msg void OnChangeEdit5();
	afx_msg void OnChangeEdit6();
	afx_msg void OnChangeEdit7();
	afx_msg void OnButton1();
	afx_msg void OnButton5();
	afx_msg void OnButton4();
	afx_msg void OnButton2();
	afx_msg void OnCheck1();
	afx_msg void OnCheck2();
	afx_msg void OnCheck3();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnButtonFr();
	afx_msg void OnButtonFf();
	afx_msg void OnButtonR();
	afx_msg void OnButtonF();
	afx_msg void OnButtonPause();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnCheck4();
	afx_msg void OnButton3();
	afx_msg void OnCheck5();
	afx_msg void OnChangeEdit8();
	afx_msg void OnChangeEdit9();
	afx_msg void OnButton7();
	afx_msg void OnButton6();
	afx_msg void OnButton8();
	afx_msg void OnButton9();
	afx_msg void OnButton10();
	afx_msg void OnButton11();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FLUID3DLG_H__6F4F1202_AD7A_4617_B886_4ABBD26643A5__INCLUDED_)
