// fluid3Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "fluid3.h"
#include "fluid3Dlg.h"
#include "oe_std.h"
#include "direct.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif





// initialized via oninit dialog
float	g_RotRad;
float	g_RotOff;
float	g_RotFac;

bool	g_DrawDot	=	1;
bool	g_DrawDash	=	1;
bool	g_DrawTail	=	1;
bool	g_DrawCross	=	1;

int		g_InitStyle	=	1;
int		g_RotStyle	=	1;

float	g_RotCenX	=	0.5f;
float	g_RotCenY	=	0.5f;

float	g_Len		=	0.7f;

int		g_ResetMode	=	0;


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFluid3Dlg dialog

CFluid3Dlg::CFluid3Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFluid3Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFluid3Dlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);





	m_pdcMemory = new CDC;
	m_pBitmap   = new CBitmap;
}


CFluid3Dlg::~CFluid3Dlg()
	{
	delete	m_pdcMemory;
	delete	m_pBitmap;
	}



void CFluid3Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFluid3Dlg)
	DDX_Control(pDX, IDC_BUTTON11, m_GUI_Button_11);
	DDX_Control(pDX, IDC_BUTTON10, m_GUI_Button_10);
	DDX_Control(pDX, IDC_BUTTON9, m_GUI_Button_9);
	DDX_Control(pDX, IDC_BUTTON8, m_GUI_Button_8);
	DDX_Control(pDX, IDC_BUTTON7, m_GUI_Button_7);
	DDX_Control(pDX, IDC_BUTTON6, m_GUI_Button_6);
	DDX_Control(pDX, IDC_STATIC_HO9, m_GUI_Static_Ho9);
	DDX_Control(pDX, IDC_STATIC_HO8, m_GUI_Static_Ho8);
	DDX_Control(pDX, IDC_EDIT9, m_GUI_Edit_Cen);
	DDX_Control(pDX, IDC_EDIT8, m_GUI_Edit_Rev);
	DDX_Control(pDX, IDC_CHECK5, m_GUI_Check_Phase);
	DDX_Control(pDX, IDC_STATIC_HO7, m_GUI_Static_Ho7);
	DDX_Control(pDX, IDC_BUTTON3, m_GUI_Button_3);
	DDX_Control(pDX, IDC_CHECK4, m_GUI_Check_Cross);
	DDX_Control(pDX, IDC_BUTTON_R, m_GUI_Button_R);
	DDX_Control(pDX, IDC_BUTTON_PAUSE, m_GUI_Button_P);
	DDX_Control(pDX, IDC_BUTTON_FR, m_GUI_Button_FR);
	DDX_Control(pDX, IDC_BUTTON_FF, m_GUI_Button_FF);
	DDX_Control(pDX, IDC_BUTTON_F, m_GUI_Button_F);
	DDX_Control(pDX, IDC_STATIC_HO6, m_GUI_Static_Ho6);
	DDX_Control(pDX, IDC_STATIC_HO5, m_GUI_Static_Ho5);
	DDX_Control(pDX, IDC_STATIC_HO4, m_GUI_Static_Ho4);
	DDX_Control(pDX, IDC_STATIC_HO3, m_GUI_Static_Ho3);
	DDX_Control(pDX, IDC_STATIC_HO2, m_GUI_Static_Ho2);
	DDX_Control(pDX, IDC_STATIC_HO1, m_GUI_Static_Ho1);
	DDX_Control(pDX, IDC_BUTTON5, m_GUI_Button_5);
	DDX_Control(pDX, IDC_BUTTON4, m_GUI_Button_4);
	DDX_Control(pDX, IDC_BUTTON2, m_GUI_Button_2);
	DDX_Control(pDX, IDC_BUTTON1, m_GUI_Button_1);
	DDX_Control(pDX, IDC_CHECK3, m_GUI_Check_Tail);
	DDX_Control(pDX, IDC_CHECK2, m_GUI_Check_Dash);
	DDX_Control(pDX, IDC_CHECK1, m_GUI_Check_Dot);
	DDX_Control(pDX, IDC_EDIT7, m_GUI_Edit7);
	DDX_Control(pDX, IDC_EDIT6, m_GUI_Edit_RotFac);
	DDX_Control(pDX, IDC_EDIT5, m_GUI_Edit_RotOff);
	DDX_Control(pDX, IDC_EDIT4, m_GUI_Edit_RotRad);
	DDX_Control(pDX, IDC_EDIT3, m_GUI_Edit_Len);
	DDX_Control(pDX, IDC_EDIT1, m_GUI_Edit_W);
	DDX_Control(pDX, IDC_EDIT2, m_GUI_Edit_H);
	DDX_Control(pDX, IDC_STATIC_HI, m_GUI_Static_Hi);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFluid3Dlg, CDialog)
	//{{AFX_MSG_MAP(CFluid3Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_CHANGE(IDC_EDIT1, OnChangeEdit1)
	ON_EN_CHANGE(IDC_EDIT3, OnChangeEdit3)
	ON_EN_CHANGE(IDC_EDIT4, OnChangeEdit4)
	ON_EN_CHANGE(IDC_EDIT5, OnChangeEdit5)
	ON_EN_CHANGE(IDC_EDIT6, OnChangeEdit6)
	ON_EN_CHANGE(IDC_EDIT7, OnChangeEdit7)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON5, OnButton5)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck2)
	ON_BN_CLICKED(IDC_CHECK3, OnCheck3)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_FR, OnButtonFr)
	ON_BN_CLICKED(IDC_BUTTON_FF, OnButtonFf)
	ON_BN_CLICKED(IDC_BUTTON_R, OnButtonR)
	ON_BN_CLICKED(IDC_BUTTON_F, OnButtonF)
	ON_BN_CLICKED(IDC_BUTTON_PAUSE, OnButtonPause)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_BN_CLICKED(IDC_CHECK4, OnCheck4)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_CHECK5, OnCheck5)
	ON_EN_CHANGE(IDC_EDIT8, OnChangeEdit8)
	ON_EN_CHANGE(IDC_EDIT9, OnChangeEdit9)
	ON_BN_CLICKED(IDC_BUTTON7, OnButton7)
	ON_BN_CLICKED(IDC_BUTTON6, OnButton6)
	ON_BN_CLICKED(IDC_BUTTON8, OnButton8)
	ON_BN_CLICKED(IDC_BUTTON9, OnButton9)
	ON_BN_CLICKED(IDC_BUTTON10, OnButton10)
	ON_EN_CHANGE(IDC_EDIT2, OnChangeEdit1)
	ON_BN_CLICKED(IDC_BUTTON11, OnButton11)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFluid3Dlg message handlers

BOOL CFluid3Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	DragAcceptFiles(TRUE);

	
	m_MoveCtrlsNum	=	0;

	
	m_ToolTips.Create(this);
	m_ToolTips.AddTool(&m_GUI_Edit_W		, "Number of spinners ACROSS");
	m_ToolTips.AddTool(&m_GUI_Edit_H		, "Number of spinners UP & DOWN");
	m_ToolTips.AddTool(&m_GUI_Edit_Len		, "Length of each spinner");
	m_ToolTips.AddTool(&m_GUI_Edit_RotRad	, "Spinner Speed Radial Factor");
	m_ToolTips.AddTool(&m_GUI_Edit_RotOff	, "Spinner Speed Constant");
	m_ToolTips.AddTool(&m_GUI_Edit_RotFac	, "Spinner Speed Global Factor");
	m_ToolTips.AddTool(&m_GUI_Edit_Rev		, "Reverse Direction Period");
	m_ToolTips.AddTool(&m_GUI_Edit_Cen		, "Change Center Spot Period");
	m_ToolTips.AddTool(&m_GUI_Check_Dot		, "Draw the Dot!");
	m_ToolTips.AddTool(&m_GUI_Check_Dash	, "Draw the Dash!");
	m_ToolTips.AddTool(&m_GUI_Check_Tail	, "Draw the Tail!");
	m_ToolTips.AddTool(&m_GUI_Check_Cross	, "Is it an X or a Plus ?!");
	m_ToolTips.AddTool(&m_GUI_Check_Phase	, "Store phase for each spinner option");
	m_ToolTips.AddTool(&m_GUI_Edit7			, "Current Stored Settings uh Slot");
	m_ToolTips.AddTool(&m_GUI_Button_FR		, "Fast Rewind");
	m_ToolTips.AddTool(&m_GUI_Button_FF		, "Fast Forward");
	m_ToolTips.AddTool(&m_GUI_Button_R		, "Forward");
	m_ToolTips.AddTool(&m_GUI_Button_F		, "Rewind");
	m_ToolTips.AddTool(&m_GUI_Button_P		, "Pause");
	m_ToolTips.AddTool(&m_GUI_Button_1		, "Store settings to next available slot");
	m_ToolTips.AddTool(&m_GUI_Button_3		, "Store settings to current slot");
	m_ToolTips.AddTool(&m_GUI_Button_2		, "Destory current slot");
	m_ToolTips.AddTool(&m_GUI_Button_4		, "Previous Stored Settings");
	m_ToolTips.AddTool(&m_GUI_Button_5		, "Next Stored Settings");
	m_ToolTips.AddTool(&m_GUI_Button_9		, "Heeellllppppp");
	

	m_GUI_Edit_W		.SetWindowText	("11"		);
	m_GUI_Edit_H		.SetWindowText	("11"		);
	m_GUI_Edit_Len		.SetWindowText	(".7"		);
	m_GUI_Edit_RotRad	.SetWindowText	(".001"		);
	m_GUI_Edit_RotOff	.SetWindowText	("-.1"		);
	m_GUI_Edit_RotFac	.SetWindowText	("1.0"		);
	m_GUI_Edit_Rev		.SetWindowText	("0"		);
	m_GUI_Edit_Cen		.SetWindowText	("0"		);
	m_GUI_Check_Dot		.SetCheck		(0			);
	m_GUI_Check_Dash	.SetCheck		(1			);
	m_GUI_Check_Tail	.SetCheck		(0			);
	m_GUI_Check_Cross	.SetCheck		(0			);
	m_GUI_Check_Phase	.SetCheck		(1			);
	m_GUI_Edit7			.SetWindowText	("0"		);

	AddMoveCtrl(&m_GUI_Edit_W		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Edit_H		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Edit_Len		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Edit_RotRad	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Edit_RotOff	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Edit_RotFac	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Edit_Rev		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Edit_Cen		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Check_Dot	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Check_Dash	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Check_Tail	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Check_Cross	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Check_Phase	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Edit7		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Static_Hi	, OE_MOVECTRLS_MODE_BR);
	AddMoveCtrl(&m_GUI_Button_1		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_3		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_2		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_4		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_5		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_6		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_7		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_8		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_9		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_10	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_11	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Static_Ho1	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Static_Ho2	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Static_Ho3	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Static_Ho4	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Static_Ho5	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Static_Ho6	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Static_Ho7	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Static_Ho8	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Static_Ho9	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_FR	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_FF	, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_R		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_F		, OE_MOVECTRLS_MODE_H);
	AddMoveCtrl(&m_GUI_Button_P		, OE_MOVECTRLS_MODE_H);
	


	m_PlaySpeed		=	1.0f;
	m_PauseSpeed	=	0.0f;
	m_StorePhase	=	true;

	LoadSettings("0.spinnerjoy");
		
	return TRUE;  // return TRUE  unless you set the focus to a control
}


void	CFluid3Dlg::AddMoveCtrl(CWnd* cwnd, int mode)
	{
	if (m_MoveCtrlsNum > OE_ASZ(m_MoveCtrls))
		return;


	RECT	r1;

	cwnd ->	GetWindowRect(&r1);
	ScreenToClient(&r1);

	m_MoveCtrls			[m_MoveCtrlsNum]	=	cwnd;
	m_MoveCtrlsInitialX	[m_MoveCtrlsNum]	=	r1.left;
	m_MoveCtrlsInitialY	[m_MoveCtrlsNum]	=	r1.top;
	m_MoveCtrlsMode		[m_MoveCtrlsNum]	=	mode;

	m_MoveCtrlsNum++;
	}


void CFluid3Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFluid3Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
		FluidDisplay();
	}
}

HCURSOR CFluid3Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CFluid3Dlg::OnOK() 
{
}

void CFluid3Dlg::OnCancel() 
{
	PostQuitMessage(0);
	CDialog::OnCancel();
}






void	CFluid3Dlg::Pulse()
	{
	float	hi;

	if (m_ReversePeriod > 0)
		{
		if (m_ReversePeriodCountDown <= 0)
			{
			char	s[32];
			g_RotFac	*=	-1.0f;
			sprintf(s, "%f", g_RotFac);
			m_GUI_Edit_RotFac.SetWindowText(s);
			m_ReversePeriodCountDown	=	m_ReversePeriod;
			}
		else
			{
			m_ReversePeriodCountDown--;
			}
		}

	if (m_RecenterPeriod > 0)
		{
		if (m_RecenterPeriodCountDown <= 0)
			{
			g_RotCenX	= (float)(rand() % 33333) / 33333.0f;
			g_RotCenY	= (float)(rand() % 33333) / 33333.0f;
			m_RecenterPeriodCountDown	=	m_RecenterPeriod;
			}
		else
			{
			m_RecenterPeriodCountDown--;
			}
		}
	
	
	hi	=	g_RotFac;

	g_RotFac	*=	m_PlaySpeed;

	if (g_RotFac != 0.0)
		m_Fluid.Pulse();

	g_RotFac	=	hi;
	}


// this converts m_Fluid to the display.
void	CFluid3Dlg::FluidDisplay()
	{
	Pulse		();

	RECT	r;
	m_GUI_Static_Hi.GetClientRect(&r);


	// creates the memory device context and the bitmap
	if (m_pdcMemory->GetSafeHdc() == NULL || m_NeedResize) 
		{
		CClientDC dc	(&m_GUI_Static_Hi);
//		OnPrepareDC		(&dc);
		CRect rectMax	(0, 0, r.right - r.left, r.bottom - r.top);
		dc.LPtoDP		(rectMax);


		delete	m_pdcMemory;
		delete	m_pBitmap;
		m_pdcMemory = new CDC;
		m_pBitmap   = new CBitmap;
		
		// The order of the next 2 statements is very critical
		m_pdcMemory->CreateCompatibleDC(&dc);

		// makes bitmap same size as display window
		m_pBitmap->CreateCompatibleBitmap(&dc, rectMax.right, rectMax.bottom);

		m_NeedResize	=	false;		
		}

	m_pdcMemory->SelectObject(m_pBitmap);
	m_pdcMemory->Rectangle(&r);


	CDC*	cdc;
	HDC		hdc;
	
	cdc	=	m_pdcMemory;
	hdc	=	cdc	->	m_hDC;
	
	int	i, inum;
	int	j, jnum;
	oe_fluid2cell*	fc;
	float	zx, zy;
	float	sx, sy;
	int		ix, iy;

	jnum	=	m_Fluid.m_CellsH;
	inum	=	m_Fluid.m_CellsW;

	fc		=	m_Fluid.m_Cells;

	m_GUI_Static_Hi.GetClientRect(&r);
	sx		=	(float)(r.right	- r.left) / m_Fluid.m_CellsW;
	sy		=	(float)(r.bottom- r.top	) / m_Fluid.m_CellsH;



	for (j = 0; j < jnum; j++)
		{
		for (i = 0; i < inum; i++)
			{
			zx	=	(float)i			+ 0.5f;
			zy	=	(float)(jnum - j)	- 0.5f;

			if (g_DrawTail && !g_DrawDash)
				{
				cdc -> MoveTo((int)(zx * sx), (int)(zy * sy));
				zx	-=	fc ->m_Velocity.m_Value[0];
				zy	+=	fc ->m_Velocity.m_Value[1];
				cdc -> LineTo((int)(zx * sx), (int)(zy * sy));
				}

			if (!g_DrawTail && g_DrawDash)
				{
				cdc -> MoveTo((int)(zx * sx), (int)(zy * sy));
				zx	+=	fc ->m_Velocity.m_Value[0];
				zy	-=	fc ->m_Velocity.m_Value[1];
				cdc -> LineTo((int)(zx * sx), (int)(zy * sy));
				}
			
			if (g_DrawTail && g_DrawDash)
				{
				zx	-=	fc ->m_Velocity.m_Value[0];
				zy	+=	fc ->m_Velocity.m_Value[1];
				cdc -> MoveTo((int)(zx * sx), (int)(zy * sy));
				zx	+=	fc ->m_Velocity.m_Value[0] * 2.0f;
				zy	-=	fc ->m_Velocity.m_Value[1] * 2.0f;
				cdc -> LineTo((int)(zx * sx), (int)(zy * sy));
				}
			
			if (g_DrawDot)
				{
				zx	=	(float)i			+ 0.5f;
				zy	=	(float)(jnum - j)	- 0.5f;
				zx	+=	fc ->m_Velocity.m_Value[0];
				zy	-=	fc ->m_Velocity.m_Value[1];
				
				ix	=	(int)(zx * sx);
				iy	=	(int)(zy * sy);
				ix	+=	1;
				cdc	-> MoveTo(ix, iy);
				ix	-=	3;
				cdc	-> LineTo(ix, iy);
				ix	+=	2;
				iy	+=	1;
				cdc	-> MoveTo(ix, iy);
				iy	-=	3;
				cdc	-> LineTo(ix, iy);
				}

			if (g_DrawCross)
				{
				zx	=	(float)i			+ 0.5f;
				zy	=	(float)(jnum - j)	- 0.5f;
				zx	+=	fc ->m_Velocity.m_Value[1];
				zy	+=	fc ->m_Velocity.m_Value[0];
				cdc -> MoveTo((int)(zx * sx), (int)(zy * sy));
				zx	-=	fc ->m_Velocity.m_Value[1] * 2.0f;
				zy	-=	fc ->m_Velocity.m_Value[0] * 2.0f;
				cdc -> LineTo((int)(zx * sx), (int)(zy * sy));
				}

			fc++;
			}
		}


	CDC*	cdc1;

	cdc1	=	m_GUI_Static_Hi.GetDC();
	cdc1	->BitBlt(r.left, r.top, r.right - r.left, r.bottom - r.top, cdc, 0, 0, SRCCOPY);
	m_GUI_Static_Hi.ReleaseDC(cdc1);
	
	}






void CFluid3Dlg::OnChangeEdit1() 
{
	CString	cs;
	int		w;
	int		h;

	m_GUI_Edit_Len.GetWindowText(cs);
	g_Len	=	(float)atof(cs);
	
	if (fabsf(g_Len) < .001)
		g_Len	=	.001f;
	m_GUI_Edit_W.GetWindowText(cs);
	w	=	atoi(cs);
	m_GUI_Edit_H.GetWindowText(cs);
	h	=	atoi(cs);

	
	m_Fluid.SizeSet(w, h);
	m_Fluid.VelocitySet	(.5f, .1f);
	OnChangeEdit3();

	return;

	int				i, inum;
	oe_fluid2cell*	fc;
	oe_v2			cen;
	oe_v2			pos;
	inum	=	w * h;
	fc		=	m_Fluid.m_Cells;
	cen.Set((oe_scalar)(w-1)/2.0f, (oe_scalar)(h-1)/2.0f);
	for (i = 0; i < inum; i++)
		{
		pos.Set((oe_scalar)fc -> m_PosX, (oe_scalar)fc -> m_PosY);
		fc -> m_Velocity = pos - cen;
//		fc -> m_Velocity.Norm(len, fc -> m_Velocity);
//		fc -> m_Velocity.Rot90(fc ->m_Velocity);
		fc++;
		}

}

void CFluid3Dlg::OnChangeEdit3() 
		{
		CString	cs;

		m_GUI_Edit_Len.GetWindowText(cs);
		g_Len	=	(float)atof(cs);

		if (fabsf(g_Len) < .001)
			g_Len	=	.001f;

		int				i, inum;
		oe_fluid2cell*	fc;
		inum	=	m_Fluid.m_CellsW * m_Fluid.m_CellsH;
		fc		=	m_Fluid.m_Cells;
		for (i = 0; i < inum; i++)
			{
			fc -> m_Velocity.Norm(g_Len, fc -> m_Velocity);
			fc++;
			}

		g_RotCenX					=	0.5f;
		g_RotCenY					=	0.5f;
		m_RecenterPeriodCountDown	=	m_RecenterPeriod	/	2;
		m_ReversePeriodCountDown	=	m_ReversePeriod		/	2;		
		}

void CFluid3Dlg::OnChangeEdit4() 
{
	CString	cs;
	m_GUI_Edit_RotRad.GetWindowText(cs);
	g_RotRad	=	(float)atof(cs);
}

void CFluid3Dlg::OnChangeEdit5() 
{
	CString	cs;
	m_GUI_Edit_RotOff.GetWindowText(cs);
	g_RotOff	=	(float)atof(cs);
}

void CFluid3Dlg::OnChangeEdit6() 
	{
	CString	cs;
	m_GUI_Edit_RotFac.GetWindowText(cs);
	g_RotFac	=	(float)atof(cs);
	}



void CFluid3Dlg::OnChangeEdit8() 
	{
	CString	cs;
	m_GUI_Edit_Rev.GetWindowText(cs);
	m_ReversePeriod	=	atoi(cs);
	m_RecenterPeriodCountDown	=	m_RecenterPeriod	/	2;
	m_ReversePeriodCountDown	=	m_ReversePeriod		/	2;		
	}

void CFluid3Dlg::OnChangeEdit9() 
	{
	CString	cs;
	m_GUI_Edit_Cen.GetWindowText(cs);
	m_RecenterPeriod	=	atoi(cs);
	m_RecenterPeriodCountDown	=	m_RecenterPeriod	/	2;
	m_ReversePeriodCountDown	=	m_ReversePeriod		/	2;		
	}



BOOL CFluid3Dlg::PreTranslateMessage(MSG* pMsg) 
{

	m_ToolTips.RelayEvent(pMsg);
	
	return CDialog::PreTranslateMessage(pMsg);
}


static void	ShowSJFileName(CString& fn, CWnd* wnd)
	{
	int	dot;
	int	slash;
	dot		=	fn.ReverseFind('.');
	slash	=	fn.ReverseFind('\\');
	if (dot < 0)
		dot	=	fn.GetLength();
	
	slash++;
	
	wnd	->	SetWindowText(fn.Mid(slash, dot - slash));
	}


void	CFluid3Dlg::LoadSettings(const char* name)
	{
	CString	fn;
	FILE*	fp;
	
	fn	=	name;
	
	fp	=	fopen(fn, "r");
	if (!fp)
		return;
	
	char	buf[1024];
	char	token	[64];
	char	value	[64];
	int		i0;
	float	f0, f1;
	bool	firstline;

	i0			=	0;

	g_ResetMode	=	0;
	g_RotCenX	=	0.5f;
	g_RotCenY	=	0.5f;
	m_GUI_Edit_Rev		.SetWindowText("0");
	m_GUI_Edit_Cen		.SetWindowText("0");

	firstline	=	true;
				
	while (!feof(fp))
		{
		fgets(buf, 1023, fp);
		if (firstline)
			{
			if (!strstr(buf, "# SpinnerJoy settings file"))
				{
				MessageBox("This ain't a SpinnerJoy file.\nSpinnerJoy files start with \"# SpinnerJoy settings file\".", fn, MB_OK);
				fclose(fp);
				return;
				}
			firstline	=	false;
			}

		sscanf(buf, "%s %s", token, value);

		if (token[0] != '#')
			{
			if (!stricmp(token, "ResetMode"		))
				g_ResetMode			=	atoi(value);
			if (!stricmp(token, "W"		))
				m_GUI_Edit_W		.SetWindowText(value);
			if (!stricmp(token, "H"		))
				m_GUI_Edit_H		.SetWindowText(value);
			if (!stricmp(token, "Len"	))
				m_GUI_Edit_Len		.SetWindowText(value);
			if (!stricmp(token, "RotRad"))
				m_GUI_Edit_RotRad	.SetWindowText(value);
			if (!stricmp(token, "RotOff"))
				m_GUI_Edit_RotOff	.SetWindowText(value);
			if (!stricmp(token, "RotFac"))
				m_GUI_Edit_RotFac	.SetWindowText(value);
			if (!stricmp(token, "Reverse"))
				m_GUI_Edit_Rev		.SetWindowText(value);
			if (!stricmp(token, "Recenter"))
				m_GUI_Edit_Cen		.SetWindowText(value);
			if (!stricmp(token, "DrawDot"))
				m_GUI_Check_Dot		.SetCheck(atoi(value));
			if (!stricmp(token, "DrawDash"))
				m_GUI_Check_Dash	.SetCheck(atoi(value));
			if (!stricmp(token, "DrawTail"))
				m_GUI_Check_Tail	.SetCheck(atoi(value));
			if (!stricmp(token, "DrawCross"))
				m_GUI_Check_Cross	.SetCheck(atoi(value));
			if (!stricmp(token, "RotCenX"))
				g_RotCenX			=	(float)atof(value);
			if (!stricmp(token, "RotCenY"))
				g_RotCenY			=	(float)atof(value);
			if (!stricmp(token, "DrawCross"))
				m_GUI_Check_Cross	.SetCheck(atoi(value));

			if (!stricmp(token, "Vel"))
				{
				sscanf(buf, "%s %f %f", token, &f0, &f1);
				if (i0 < m_Fluid.m_CellsH * m_Fluid.m_CellsH)
					{
					m_Fluid.m_Cells[i0].m_Velocity.Set(f0, f1);
					i0++;
					}
				}
			}
		}
	fclose(fp);

	OnCheck1();
	OnCheck2();
	OnCheck3();
	OnCheck4();

	ShowSJFileName(fn, &m_GUI_Edit7);
	}

void	CFluid3Dlg::SaveSettings(const char* name)
	{
	CString	fn;
	CString	cs;
	FILE*	fp;
	int		ck;
	
	fn	=	name;
	
	fp	=	fopen(fn, "w");
	if (!fp)
		return;
	
	fprintf(fp, "# SpinnerJoy settings file\n");
	fprintf(fp, "# orion x elenzil 200303\n");
	fprintf(fp, "\n");
	fprintf(fp, "%20s %10d\n", "ResetMode"		, g_ResetMode);
	m_GUI_Edit_W		.GetWindowText(cs);
	fprintf(fp, "%20s %10s\n", "W"		, cs);
	m_GUI_Edit_H		.GetWindowText(cs);
	fprintf(fp, "%20s %10s\n", "H"		, cs);
	m_GUI_Edit_Len		.GetWindowText(cs);
	fprintf(fp, "%20s %10s\n", "Len"	, cs);
	m_GUI_Edit_RotRad	.GetWindowText(cs);
	fprintf(fp, "%20s %10s\n", "RotRad"	, cs);
	m_GUI_Edit_RotOff	.GetWindowText(cs);
	fprintf(fp, "%20s %10s\n", "RotOff"	, cs);
	m_GUI_Edit_RotFac	.GetWindowText(cs);
	fprintf(fp, "%20s %10s\n", "RotFac"	, cs);
	m_GUI_Edit_Rev		.GetWindowText(cs);
	fprintf(fp, "%20s %10s\n", "Reverse", cs);
	m_GUI_Edit_Cen		.GetWindowText(cs);
	fprintf(fp, "%20s %10s\n", "Recenter", cs);

	ck	=	m_GUI_Check_Dot		.GetCheck() & 3;
	fprintf(fp, "%20s %10d\n", "DrawDot", ck);
	ck	=	m_GUI_Check_Dash	.GetCheck() & 3;
	fprintf(fp, "%20s %10d\n", "DrawDash", ck);
	ck	=	m_GUI_Check_Tail	.GetCheck() & 3;
	fprintf(fp, "%20s %10d\n", "DrawTail", ck);
	ck	=	m_GUI_Check_Cross	.GetCheck() & 3;
	fprintf(fp, "%20s %10d\n", "DrawCross", ck);

	fprintf(fp, "%20s %10f\n", "RotCenX", g_RotCenX);
	fprintf(fp, "%20s %10f\n", "RotCenY", g_RotCenY);
	
	if (m_StorePhase)
		{
		fprintf(fp, "\n");
		fprintf(fp, "# Phase/Velocity info:\n");
		int	i, inum;
		inum	=	m_Fluid.m_CellsH * m_Fluid.m_CellsW;
		for (i = 0; i < inum; i++)
			{
			fprintf(fp, "Vel %7.2f %7.2f\n", m_Fluid.m_Cells[i].m_Velocity.m_Value[0], m_Fluid.m_Cells[i].m_Velocity.m_Value[1]);
			}
		}

	fclose(fp);

	ShowSJFileName(fn, &m_GUI_Edit7);
	}


CFileDialog*	g_FD_Save		=	NULL;
CFileDialog*	g_FD_Load		=	NULL;
char			g_FD_Dir[1024]	=	"";

void CFluid3Dlg::OnButton10() 
	{
	if (!g_FD_Save)
		{
		if (!g_FD_Load)
			getcwd(g_FD_Dir, OE_ASZM1(g_FD_Dir));
		g_FD_Save	=	new	CFileDialog(FALSE, ".spinnerjoy", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "SpinnerJoy Files (*.spinnerjoy)|*.spinnerjoy|All Files (*.*)|*.*||", this);
		g_FD_Save	->	m_ofn.lpstrInitialDir	=	g_FD_Dir;
		}

	if (IDOK != g_FD_Save	->	DoModal())
		return;

	SaveSettings(g_FD_Save->GetPathName());
	}

void CFluid3Dlg::OnButton11() 
	{
	if (!g_FD_Load)
		{
		if (!g_FD_Save)
			getcwd(g_FD_Dir, OE_ASZM1(g_FD_Dir));
		g_FD_Load	=	new	CFileDialog(!FALSE, ".spinnerjoy", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "SpinnerJoy Files (*.spinnerjoy)|*.spinnerjoy|All Files (*.*)|*.*||", this);
		g_FD_Load	->	m_ofn.lpstrInitialDir	=	g_FD_Dir;

		MessageBox("You can also load SpinnerJoy files by dragging and dropping them onto the program\nand let us not forget all the Preset files, which you can flip between with the < and > buttons.", "About to load file, but Did You Know..", MB_OK);
		}
	
	if (IDOK != g_FD_Load	->	DoModal())
		return;
	
	LoadSettings(g_FD_Load->GetPathName());
	}


void CFluid3Dlg::OnChangeEdit7() 
{
}

void CFluid3Dlg::OnButton1() 
{

	int		i;
	int		found;
	char	fn[32];
	FILE*	fp;

	found	=	-1;

	for (i = 1; i < 1000 && found == -1; i++)
		{
		sprintf(fn, "%d.spinnerjoy", i);
		fp	=	fopen(fn, "r");
		if (!fp)
			found	=	i;
		else
			fclose(fp);
		}

	if (found == -1)
		{
		MessageBox("No Really, i checked 1,000 files!", "No More Room to Store Settings", MB_OK);
		return;
		}

	sprintf(fn, "%d.spinnerjoy", found);
	SaveSettings(fn);
}


void CFluid3Dlg::OnButton3() 
	{
	CString	cs;

	m_GUI_Edit7.GetWindowText(cs);
	cs	+=	".spinnerjoy";
	SaveSettings(cs);
	}




void CFluid3Dlg::OnButton4() 
	{
	CString	cs;
	char	s[32];
	int		i;
	int		found;
	FILE*	fp;

	m_GUI_Edit7.GetWindowText(cs);
	
	
	i	=	atoi(cs) - 1;

	for (found = -1; i >= 0 && found == -1; i--)
		{
		sprintf(s, "%d.spinnerjoy", i);
		fp	=	fopen(s, "r");
		if (fp)
			{
			fclose(fp);
			found	=	i;
			}
		}

	if (found != -1)
		{
		sprintf(s, "%d.spinnerjoy", found);
		LoadSettings(s);
		}
	}

void CFluid3Dlg::OnButton5() 
	{
	CString	cs;
	char	s[32];
	int		i;
	int		found;
	FILE*	fp;
	
	m_GUI_Edit7.GetWindowText(cs);
	
	
	i	=	atoi(cs) + 1;
	
	for (found = -1; i < 1000 && found == -1; i++)
		{
		sprintf(s, "%d.spinnerjoy", i);
		fp	=	fopen(s, "r");
		if (fp)
			{
			fclose(fp);
			found	=	i;
			}
		}

	if (found != -1)
		{
		sprintf(s, "%d.spinnerjoy", found);
		LoadSettings(s);
		}
	}


void CFluid3Dlg::OnButton2() 
	{
	CString	cs;
	
	m_GUI_Edit7.GetWindowText(cs);
	if (cs == "0")
		{
		m_GUI_Edit7.SetWindowText("ixnay!");
		return;
		}

	cs	+=	".spinnerjoy";
	unlink(cs);
	}

void CFluid3Dlg::OnCheck1() 
{
	g_DrawDot	=	m_GUI_Check_Dot.GetCheck() & 3;
}

void CFluid3Dlg::OnCheck2() 
{
	g_DrawDash	=	m_GUI_Check_Dash.GetCheck() & 3;
}

void CFluid3Dlg::OnCheck3() 
{
	g_DrawTail	=	m_GUI_Check_Tail.GetCheck() & 3;
}

void CFluid3Dlg::OnCheck4() 
{
	g_DrawCross	=	m_GUI_Check_Cross.GetCheck() & 3;
}

void CFluid3Dlg::OnCheck5() 
	{
	m_StorePhase=	m_GUI_Check_Phase.GetCheck() & 3;
	}

void CFluid3Dlg::OnSize(UINT nType, int cx, int cy) 
	{

	if (!GetSafeHwnd())
		return;

	RECT	r1;
	GetWindowRect(&r1);

	
	if (m_OrigSX < 0)
		{
		m_OrigSX = r1.right		-	r1.left;
		m_OrigSY = r1.bottom	-	r1.top;
		return;
		}


	int	dx, dy;

	dx	=	(r1.right	- r1.left	) - m_OrigSX;
	dy	=	(r1.bottom	- r1.top	) - m_OrigSY;

	m_OrigSX	+=	dx;
	m_OrigSY	+=	dy;

	int		i;
	CWnd*	cwnd;
	int		px, py;
	int		sx, sy;
	
	for (i = 0; i < m_MoveCtrlsNum; i++)
		{
		cwnd	=	m_MoveCtrls[i];
		cwnd	->	GetWindowRect(&r1);
		ScreenToClient(&r1);

		if (m_MoveCtrlsMode[i] & OE_MOVECTRLS_MODE_TOP		)
			r1.top		+=	dy;

		if (m_MoveCtrlsMode[i] & OE_MOVECTRLS_MODE_BOT		)
			r1.bottom	+=	dy;

		if (m_MoveCtrlsMode[i] & OE_MOVECTRLS_MODE_LEFT		)
			r1.left		+=	dx;

		if (m_MoveCtrlsMode[i] & OE_MOVECTRLS_MODE_RIGHT	)
			r1.right	+=	dx;

		cwnd -> SetWindowPos(NULL, r1.left, r1.top, r1.right - r1.left, r1.bottom - r1.top, SWP_NOZORDER | SWP_NOACTIVATE);
		}

	CDialog::OnSize(nType, cx, cy);
	Invalidate();
	m_NeedResize	=	true;
	}

void CFluid3Dlg::OnButtonFr() 
{
	m_PlaySpeed		+=	-2.0f;
	m_PauseSpeed	=	0.0f;
}

void CFluid3Dlg::OnButtonFf() 
{
	m_PlaySpeed		+=	2.0f;
	m_PauseSpeed	=	0.0f;
}

void CFluid3Dlg::OnButtonR() 
{
	m_PlaySpeed		=	-1.0f;
	m_PauseSpeed	=	0.0f;
}

void CFluid3Dlg::OnButtonF() 
{
	m_PlaySpeed		=	1.0f;
	m_PauseSpeed	=	0.0f;
}

void CFluid3Dlg::OnButtonPause() 
{
	if (m_PauseSpeed	== 0.0f)
		{
		m_PauseSpeed	=	m_PlaySpeed;
		m_PlaySpeed		=	0.0f;
		}
	else
		{
		m_PlaySpeed		=	m_PauseSpeed;
		m_PauseSpeed	=	0.0f;
		}
	}

void CFluid3Dlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	CPoint	pt;
	RECT	r1;

	pt	=	point;

	ClientToScreen(&pt);
	m_GUI_Static_Hi.ScreenToClient	(&pt);
	m_GUI_Static_Hi.GetClientRect	(&r1);
	if (pt.x > 0		&& pt.y > 0			&&
		pt.x < r1.right	&& pt.y	< r1.bottom	)
		{
		m_RotCenX	= (float)pt.x / (float)r1.right;
		m_RotCenY	= (float)pt.y / (float)r1.bottom;
		m_RotCenY	=	1.0f - m_RotCenY;

		if (nFlags & 1)
			{
			g_RotCenX	=	m_RotCenX;
			g_RotCenY	=	m_RotCenY;
			}
		}
	
	CDialog::OnMouseMove(nFlags, point);
}


void CFluid3Dlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CPoint	pt;
	RECT	r1;

	pt	=	point;

	ClientToScreen(&pt);
	m_GUI_Static_Hi.ScreenToClient	(&pt);
	m_GUI_Static_Hi.GetClientRect	(&r1);
	if (pt.x > 0		&& pt.y > 0			&&
		pt.x < r1.right	&& pt.y	< r1.bottom	)
		{
		m_RotCenX	= (float)pt.x / (float)r1.right;
		m_RotCenY	= (float)pt.y / (float)r1.bottom;
		m_RotCenY	=	1.0f - m_RotCenY;
		
		if (nFlags & 1)
			{
			g_RotCenX	=	m_RotCenX;
			g_RotCenY	=	m_RotCenY;
			}
		}

	CDialog::OnLButtonDown(nFlags, point);
}


void CFluid3Dlg::OnButton7() 
	{
	m_Fluid.VelocitySet	(.5f, .1f);
	}

void CFluid3Dlg::OnButton6() 
	{
	if (g_ResetMode > 0)
		g_ResetMode--;

	m_Fluid.VelocitySet	(.5f, .1f);
	}

void CFluid3Dlg::OnButton8() 
	{
	if (g_ResetMode < 2)
		g_ResetMode++;
	m_Fluid.VelocitySet	(.5f, .1f);
	}

void CFluid3Dlg::OnButton9() 
{
	WinExec("explorer docs\\spinnerjoy.html", SW_SHOWNORMAL);
}


void	CFluid3Dlg::DoDrop(HDROP hDrop)
	{
	char	fn[1024];

	DragQueryFile(hDrop, 0, fn, OE_ASZM1(fn));
	if (fn[0] == '\0')
		return;

	DragFinish(hDrop);

	LoadSettings(fn);
	}


LRESULT CFluid3Dlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	switch (message)
		{
		default:
			break;
		case	WM_DROPFILES:
			DoDrop((HDROP)wParam);
			break;
		}

	return CDialog::WindowProc(message, wParam, lParam);
}
