/*

  oxe_RendDX2.h

  muthafuckin direct x renderin

  */

#include <windows.h>
#include <windowsx.h>
#include <basetsd.h>
#include <mmsystem.h>
#include <stdio.h>
#include <tchar.h>
#include <D3D8.h>


#include "oe_matrix.h"
#include "oe_voidlist.h"
#include "oxe_3DLight.h"
#include "oxe_3DMaterial.h"

#ifndef OXE_INITDXSTRUCT
#define	OXE_INITDXSTRUCT(a) ZeroMemory(&a, sizeof(a)); a.dwSize	= sizeof(a);
#endif
#ifndef OXE_INITDXSTRUCT8
#define	OXE_INITDXSTRUCT8(a) ZeroMemory(&a, sizeof(a)); a.Size	= sizeof(a);
#endif





enum	{
		OXE_MATRIX_WRLD	=	1,
		OXE_MATRIX_PROJ,
		OXE_MATRIX_VIEW
		};



///////////////////////////////////////////////
// class	HR_Mode_State
// class	HR_Mode_State
// class	HR_Mode_State
// class	HR_Mode_State
// This class contains all/misc the Mode-type settings for the renderer.
// ie NOT things which have instances, eg matrices, current texture, current material.
// ie YES fill mode, cullmode, zbuffer mode, alpha enable mode etc.
//
// How to use this class:
// Set the values you want, and set their touched flags to TRUE.
// Then call ModePush(), then ModeSet(), and finally, when you're done, ModePop().
// NOTE
// Fields whose touched flags are not set to TRUE will be ignored.

#include "oxe_Rend.h"

class	HR_Mode_State
	{
	public:

	int			m_AllInvalid;			// Says that ALL my state flags are in an unknown/invalid state.
										// Used when you want another state to win. Used mainly internally
										// as the initial state against which others are compared.

#define	HR_MODE_DECLARE(param, care) DWORD param; BOOL care;
	// If you add a parameter Here, be sure to add a Care_ field!!
	// be sure to update CareReset() Diff() MakeDefault().
	public:
	HR_MODE_DECLARE	(m_Cull			, m_Care_Cull			)	// front back etc culling
	HR_MODE_DECLARE	(m_Fill			, m_Care_Fill			)	// point wire line etc
	HR_MODE_DECLARE	(m_ZWrite		, m_Care_ZWrite			)	// write to zbuffer enable
	HR_MODE_DECLARE	(m_ZTest		, m_Care_ZTest			)	// test zbuffer enable
	HR_MODE_DECLARE	(m_ZFunc		, m_Care_ZFunc			)	// z buffer test function
	HR_MODE_DECLARE	(m_ZBias		, m_Care_ZBias			)	// z bias
	HR_MODE_DECLARE	(m_AlphaBlend	, m_Care_AlphaBlend		)	// alpha blending enable
	HR_MODE_DECLARE	(m_AlphaBlendSrc, m_Care_AlphaBlendSrc	)
	HR_MODE_DECLARE	(m_AlphaBlendDst, m_Care_AlphaBlendDst	)
	HR_MODE_DECLARE	(m_Specular		, m_Care_Specular		)	// enable specular
	HR_MODE_DECLARE	(m_Shade		, m_Care_Shade			)	// flat, guaraud
	HR_MODE_DECLARE	(m_Fog			, m_Care_Fog			)	// fog not implemented yet
	HR_MODE_DECLARE	(m_FogIParam1	, m_Care_FogIParam1		)	// fog not implemented yet
	HR_MODE_DECLARE	(m_FogIParam2	, m_Care_FogIParam2		)	// fog not implemented yet
	HR_MODE_DECLARE	(m_FogIParam3	, m_Care_FogIParam3		)	// fog not implemented yet
	HR_MODE_DECLARE	(m_FogIParam4	, m_Care_FogIParam4		)	// fog not implemented yet
	HR_MODE_DECLARE	(m_FogFParam1	, m_Care_FogFParam1		)	// fog not implemented yet
	HR_MODE_DECLARE	(m_FogFParam2	, m_Care_FogFParam2		)	// fog not implemented yet
	HR_MODE_DECLARE	(m_FogFParam3	, m_Care_FogFParam3		)	// fog not implemented yet
	HR_MODE_DECLARE	(m_FogFParam4	, m_Care_FogFParam4		)	// fog not implemented yet
	// If you add a parameter Here, be sure to add a Care_ field!!
	// be sure to update CareReset() Diff() MakeDefault().
#undef	HR_MODE_STATE_DECLARE

	public:
			HR_Mode_State	()		{ CareReset();	}
	int		Diff			(HR_Mode_State* first, HR_Mode_State* second);	// make THIS the diff from first to second.
	void	CareReset		(BOOL care = false);
	void	MakeDefault		();

	};



inline void	HR_Mode_State::CareReset(BOOL care)
	{
	m_AllInvalid			=	false;
	m_Care_Cull				=	care;
	m_Care_Fill				=	care;
	m_Care_ZWrite			=	care;
	m_Care_ZTest			=	care;
	m_Care_ZFunc			=	care;
	m_Care_ZBias			=	care;
	m_Care_AlphaBlend		=	care;
	m_Care_AlphaBlendSrc	=	care;
	m_Care_AlphaBlendDst	=	care;
	m_Care_Specular			=	care;
	m_Care_Shade			=	care;
	m_Care_Fog				=	care;
	m_Care_FogIParam1		=	care;
	m_Care_FogIParam2		=	care;
	m_Care_FogIParam3		=	care;
	m_Care_FogIParam4		=	care;
	m_Care_FogFParam1		=	care;
	m_Care_FogFParam2		=	care;
	m_Care_FogFParam3		=	care;
	m_Care_FogFParam4		=	care;
	
	// don't forget to update Diff(), Reset() and Default() also!
	}


// This copies all the flags from second into THIS,
// and then sets the Touched flags true on thise
// items which are differend in first.
// Returns the # of items which changed
// NOTE
// Only cares about fields in second who's Care field is true.
inline int	HR_Mode_State::Diff(HR_Mode_State* first, HR_Mode_State* second)
	{
	if (!first || !second)
		return	0;

	*this = *second;		// wow! spooky beans, huh?

	CareReset();

	int	rtn;
	rtn	=	0;

#define	HR_MODE_STATE_DIFF_COMPARE(param, careParam, first, second, sum) if (second -> careParam && (first -> m_AllInvalid || param != first -> param)) {careParam = true; sum++;}

	HR_MODE_STATE_DIFF_COMPARE(m_Cull			, m_Care_Cull			, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_Fill			, m_Care_Fill			, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_ZWrite			, m_Care_ZWrite			, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_ZTest			, m_Care_ZTest			, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_ZFunc			, m_Care_ZFunc			, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_ZBias			, m_Care_ZBias			, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_AlphaBlend		, m_Care_AlphaBlend		, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_AlphaBlendSrc	, m_Care_AlphaBlendSrc	, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_AlphaBlendDst	, m_Care_AlphaBlendDst	, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_Specular		, m_Care_Specular		, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_Shade			, m_Care_Shade			, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_Fog			, m_Care_Fog			, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_FogIParam1		, m_Care_FogIParam1		, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_FogIParam2		, m_Care_FogIParam2		, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_FogIParam3		, m_Care_FogIParam3		, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_FogIParam4		, m_Care_FogIParam4		, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_FogFParam1		, m_Care_FogFParam1		, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_FogFParam2		, m_Care_FogFParam2		, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_FogFParam3		, m_Care_FogFParam3		, first, second, rtn);
	HR_MODE_STATE_DIFF_COMPARE(m_FogFParam4		, m_Care_FogFParam4		, first, second, rtn);

#undef HR_MODE_STATE_DIFF_COMPARE

	return rtn;
	}

inline	void	HR_Mode_State::MakeDefault()
	{
	CareReset(true);

	m_Cull				=	HR_CULL_BACK;
	m_Fill				=	HR_FILL_SOLID;
	m_ZWrite			=	TRUE;
	m_ZTest				=	TRUE;
	m_ZFunc				=	HR_CMP_LESS;
	m_ZBias				=	0;
	m_AlphaBlend		=	FALSE;
	m_AlphaBlendSrc		=	HR_BLEND_ONE;
	m_AlphaBlendDst		=	HR_BLEND_ZERO;
	m_Specular			=	TRUE;
	m_Shade				=	HR_SHADE_GOURAUD;
	m_Fog				=	FALSE;
	m_FogIParam1		=	0;
	m_FogIParam2		=	0;
	m_FogIParam3		=	0;
	m_FogIParam4		=	0;
	m_FogFParam1		=	0;
	m_FogFParam2		=	0;
	m_FogFParam3		=	0;
	m_FogFParam4		=	0;
	}




class	oxe_RendDX2
	{
	public:

	HWND	m_HWnd;	


	LPDIRECT3D8				m_pD3D;              // The main D3D object
	LPDIRECT3DDEVICE8		m_pd3dDevice;        // The D3D rendering device
	LPDIRECT3DDEVICE8		m_lpD3DDevice;			// the device
	
	RECT					m_WindowRect;			// client rect of window
	RECT					m_ViewportRect;			// client rect of window
	D3DMATRIX				m_MatrixWrld;			// current
	D3DMATRIX				m_MatrixProj;			// current
	D3DMATRIX				m_MatrixView;			// current

	char*					m_DevName;
	char					m_Hoot	[512];			// used in debugging

	oe_VoidList				m_Lights;
	oe_VoidList				m_Materials;

	HR_Mode_State			m_Mode_State;			// current

	oe_v3					m_ClearColor;


	public:

		oxe_RendDX2();
	~	oxe_RendDX2();



	int					MatrixSet			(int which, oe_matrix4* mat);
	int					MatrixGet			(int which, oe_matrix4* mat);
	int					MatrixSetD3D		(int which);

	int	ModeSetD3D	(HR_Mode_State* hrms);		// not in base class
	int	ModeSet		(HR_Mode_State* hrms);
	int	ModeGet		(HR_Mode_State* hrms);
	
	void				WindowDimensionsGet	(bool doResize);
	int					SizeChanged			();
	int					BackgroundDraw		();

	int					OnMove				();
	int					OnSize				();
	int					SceneBegin			();
	int					SceneEnd			();
	int					Clear				();
	int					BackBufferShow		();


	/////////////////////////////
	// Light routines.
	// Add a light, set its properties later,
	// delete it after that.
	int					LightAdd			(oxe_3DLight* lit	);
	int					LightDel			(oxe_3DLight* lit	);
	oxe_3DLight*		LightGet			(int		  num	);
	int					LightsGetNum		(					);
	int					LightsUntouch		(					);
	int					LightUntouch		(oxe_3DLight* lit	);				// do not call
	int					LightUntouchAmbient	(oxe_3DLight* lit	);				// do not call
	int					LightReallocate		(oxe_3DLight* lit	);				// do not call
	int					LightDelD3D			(oxe_3DLight* lit	);				// do not call
	int					LightHapToD3D		(oxe_3DLight* litsrc, D3DLIGHT8* litdst);	// do not call
	int					LightsClearD3D		(					);				// do not call


	/////////////////////////////
	// Material routines.
	// Add a material, set its properties later,
	// set em all you want in fact,
	// delete it after that.
	int					MaterialAdd			(oxe_3DMaterial*	mtl	);
	int					MaterialDel			(oxe_3DMaterial*	mtl	);
	oxe_3DMaterial*		MaterialGet			(int num				);
	int					MaterialsGetNum		(						);
	int					MaterialUntouch		(oxe_3DMaterial*	mtl	);
	int					MaterialSet			(oxe_3DMaterial*	mtl	);
	int					MaterialReallocate	(oxe_3DMaterial*	mtl	);						// do not call
	int					MaterialDelD3D		(oxe_3DMaterial*	mtl	);						// do not call
	int					MaterialHapToD3D	(oxe_3DMaterial* mtlSrc, D3DMATERIAL8* mtlDst);	// do not call
	int					MaterialsClearD3D	(						);						// do not call


	};
