/*

  oxe_Registry

  a class to store pointers-to-values and names for the values.
  whoop, whoo, and weehee

  */

#include "oe_std.h"
#include "oxe_Registry.h"
#include <string.h>
#include <ctype.h>

oxe_RegistryEntry::oxe_RegistryEntry()
	{
	m_Name	=	NULL;
	m_Value	=	NULL;
	m_Type	=	OXE_REG_TYPE_VOID;
	}

oxe_RegistryEntry::~oxe_RegistryEntry()
	{
	}

static	char* L_Types[]	=	{"void", "oescalar", "oe_v2", "oe_v3", "oe_v4", "int", "string"};
	
void oxe_RegistryEntry::SetName(const char	*n)
	{
	OE_DELETEARRAY(m_Name);

	if (!n)
		return;
	
	m_Name	=	new	char[strlen(n) + 1];
	strcpy(m_Name, n);
	}

static	char	L_EmptyString[]	=	"";

const char* oxe_RegistryEntry::GetName()
	{
	if (!m_Name)
		return L_EmptyString;

	return m_Name;
	}

void oxe_RegistryEntry::SetValue(void* p)
	{
	m_Value	=	p;
	m_Type	=	OXE_REG_TYPE_VOID;
	}

void oxe_RegistryEntry::SetValue(oe_scalar* p)
	{
	m_Value	=	p;
	m_Type	=	OXE_REG_TYPE_OESCALAR;
	}

void oxe_RegistryEntry::SetValue(oe_v2* p)
	{
	m_Value	=	p;
	m_Type	=	OXE_REG_TYPE_OEV2;
	}

void oxe_RegistryEntry::SetValue(oe_v3* p)
	{
	m_Value	=	p;
	m_Type	=	OXE_REG_TYPE_OEV3;
	}

void oxe_RegistryEntry::SetValue(oe_v4* p)
	{
	m_Value	=	p;
	m_Type	=	OXE_REG_TYPE_OEV4;
	}

void oxe_RegistryEntry::SetValue(int* p)
	{
	m_Value	=	p;
	m_Type	=	OXE_REG_TYPE_INT;
	}

void oxe_RegistryEntry::SetValue(char* p)
	{
	m_Value	=	p;
	m_Type	=	OXE_REG_TYPE_STRING;
	}

void* oxe_RegistryEntry::GetValue()
	{
	return m_Value;
	}

void oxe_RegistryEntry::SetType(int t)
	{
	m_Type	=	t;
	}

int	 oxe_RegistryEntry::GetType()
	{
	return	m_Type;
	}

int	oxe_RegistryEntry::Write(FILE* fp)
	{
	if (!fp)
		return	1;

	if (!m_Name || *m_Name == '\0')
		return	2;

	if (!GetValue())
		return	3;

	fprintf(fp, "%s\n", m_Name);
	switch(GetType())
		{
		default:
		case OXE_REG_TYPE_VOID:
			{
			fprintf(fp, "0x%8X\n", GetValue());
			}
			break;
		case OXE_REG_TYPE_OESCALAR:
			{
			oe_scalar*	v;
			v	=	(oe_scalar*)GetValue();
			fprintf(fp, "%13.7f\n", *v);
			}
			break;

		case OXE_REG_TYPE_OEV2:
			{
			oe_v2*	v;
			v	=	(oe_v2*)GetValue();
			fprintf(fp, "%13.7f %13.7f\n", v -> m_Value[0], v -> m_Value[1]);
			}
			break;

		case OXE_REG_TYPE_OEV3:
			{
			oe_v3*	v;
			v	=	(oe_v3*)GetValue();
			fprintf(fp, "%13.7f %13.7f %13.7f\n", v -> m_Value[0], v -> m_Value[1], v -> m_Value[2]);
			}
			break;

		case OXE_REG_TYPE_OEV4:
			{
			oe_v4*	v;
			v	=	(oe_v4*)GetValue();
			fprintf(fp, "%13.7f %13.7f %13.7f %13.7f\n", v -> m_Value[0], v -> m_Value[1], v -> m_Value[2], v -> m_Value[3]);
			}
			break;

		case OXE_REG_TYPE_INT:
			{
			int*	v;
			v	=	(int*)GetValue();
			fprintf(fp, "%13d\n", *v);
			}
			break;

		case OXE_REG_TYPE_STRING:
			{
			char*	v;
			v	=	(char*)GetValue();
			fprintf(fp, "%s\n", v);
			}
			break;
		}

	return 0;

	}

// this expects to be called only for the value -
// the name & type should already be read/set.
int	oxe_RegistryEntry::ReadValue(FILE* fp)
	{
	if (!fp)
		return 1;

	if (!m_Value)
		return 2;

	char	s[1024];

	fgets(s, OE_ASZM1(s), fp);

	switch(GetType())
		{
		default:
		case OXE_REG_TYPE_VOID:
			{
			sscanf(s, "0x%8X\n", m_Value);
			}
			break;
		case OXE_REG_TYPE_OESCALAR:
			{
			oe_scalar*	v;
			v	=	(oe_scalar*)GetValue();
			sscanf(s, "%13.7f\n", v);
			}
			break;

		case OXE_REG_TYPE_OEV2:
			{
			oe_v2*	v;
			v	=	(oe_v2*)GetValue();
			sscanf(s, "%13.7f %13.7f\n", v -> m_Value + 0, v -> m_Value + 1);
			}
			break;

		case OXE_REG_TYPE_OEV3:
			{
			oe_v3*	v;
			v	=	(oe_v3*)GetValue();
			sscanf(s, "%13.7f %13.7f %13.7f\n", v -> m_Value + 0, v -> m_Value + 1, v -> m_Value + 2);
			}
			break;

		case OXE_REG_TYPE_OEV4:
			{
			oe_v4*	v;
			v	=	(oe_v4*)GetValue();
			sscanf(s, "%f %f %f %f\n", v -> m_Value + 0, v -> m_Value + 1, v -> m_Value + 2, v -> m_Value + 3);
			}
			break;

		case OXE_REG_TYPE_INT:
			{
			int*	v;
			v	=	(int*)GetValue();
			sscanf(s, "%13d\n", v);
			}
			break;

		case OXE_REG_TYPE_STRING:
			{
			char*	v;
			v	=	(char*)GetValue();
			sscanf(s, "%s\n", v);
			}
			break;
		}

	
	return 0;
	}



oxe_RegistryEntry*	oxe_Registry::AddEntry(const char* name)
	{
	oxe_RegistryEntry*	rtn;

	rtn	=	Find(name);

	// new entry
	if (!rtn)
		{
		rtn	=	new	oxe_RegistryEntry;
		rtn	->	SetName(name);
		m_Entries.Append(rtn);
		}

	return rtn;
	}

oxe_RegistryEntry*	oxe_Registry::AddEntry(const char* name, void* value)
	{
	oxe_RegistryEntry*	rtn;

	rtn	=	AddEntry(name);
	rtn	->	SetValue(value);

	return rtn;
	}

oxe_RegistryEntry*	oxe_Registry::AddEntry(const char* name, oe_scalar* value)
	{
	oxe_RegistryEntry*	rtn;

	rtn	=	AddEntry(name);
	rtn	->	SetValue(value);

	return rtn;
	}

oxe_RegistryEntry*	oxe_Registry::AddEntry(const char* name, oe_v2* value)
	{
	oxe_RegistryEntry*	rtn;

	rtn	=	AddEntry(name);
	rtn	->	SetValue(value);

	return rtn;
	}

oxe_RegistryEntry*	oxe_Registry::AddEntry(const char* name, oe_v3* value)
	{
	oxe_RegistryEntry*	rtn;

	rtn	=	AddEntry(name);
	rtn	->	SetValue(value);

	return rtn;
	}

oxe_RegistryEntry*	oxe_Registry::AddEntry(const char* name, oe_v4* value)
	{
	oxe_RegistryEntry*	rtn;

	rtn	=	AddEntry(name);
	rtn	->	SetValue(value);

	return rtn;
	}

oxe_RegistryEntry*	oxe_Registry::AddEntry(const char* name, int* value)
	{
	oxe_RegistryEntry*	rtn;

	rtn	=	AddEntry(name);
	rtn	->	SetValue(value);

	return rtn;
	}

oxe_RegistryEntry*	oxe_Registry::AddEntry(const char* name, char* value)
	{
	oxe_RegistryEntry*	rtn;

	rtn	=	AddEntry(name);
	rtn	->	SetValue(value);

	return rtn;
	}


oxe_RegistryEntry*	oxe_Registry::Find(const char* name)
	{
	oxe_RegistryEntry*	rtn;
	int					i, inum;

	rtn	=	NULL;

	inum	=	m_Entries.GetNum();
	for (i = 0; i < inum && rtn == NULL; i++)
		{
		rtn	=	(oxe_RegistryEntry*)(m_Entries[i]);

		if (stricmp(rtn -> GetName(), name))
			rtn	=	NULL;
		}

	return rtn;
	}



void	oxe_Registry::Save(FILE* fp)
	{
	if (!fp)
		return;

	int	i, inum;

	inum	=	m_Entries.GetNum();

	for (i = 0; i < inum; i++)
		{
		((oxe_RegistryEntry*)(m_Entries[i])) -> Write(fp);
		fprintf(fp, "\n");
		}
	}



void	oxe_Registry::Save(const char* fn)
	{
	if (!fn)
		return;

	FILE* fp;

	fp	=	fopen(fn, "w");
	if (!fp)
		return;

	Save(fp);

	fclose(fp);
	}


void	oxe_Registry::Load(FILE* fp)
	{
	if (!fp)
		return;

	oxe_RegistryEntry*	entry;
	char				line[1024];
	char*				s;

	while (!feof(fp))
		{
		fgets(line, OE_ASZM1(line), fp);
		if (*line != '#')
			{
			s	=	line + strlen(line) - 1;

			// strip white space
			while (s > line && isspace(*s))
				{
				*s--	=	'\0';
				}

			entry	=	Find(line);
			if (entry)
				{
				entry -> ReadValue(fp);
				}
			}
		}
	}



void	oxe_Registry::Load(const char* fn)
	{
	if (!fn)
		return;

	FILE* fp;

	fp	=	fopen(fn, "r");
	if (!fp)
		return;

	Load(fp);

	fclose(fp);
	}



