/*

/*

  oxw_MagicDiscontinuityFixer.cpp

  This class is for taking a 1-D array of (floats)
  which is intended to wrap-around,
  and making it so the left & right ends match,
  by spreading the discontinuity over the entire array.

  That is, spreading it linearly 'inwards' from each edge.
  So the center element (if one exists) shouldn't be affected.

  Usage:
  Call DataNumSet().
  Write data to m_Data.
  Optionally set threshhold.
  Call DoIt().

  NOTE
  if the input data is Linear (eg a straight line),
  this function will make it horizontal, flat, monovalued!
  (draw a picture)

  */


#ifndef _OXE_MDF_H_
#define _OXE_MDF_H_


#include "oe_std.h"
#include "oe_v3.h"	// for oe_scalar



class oxe_MDF
	{
	public:

	oe_scalar*	m_Data;
	int			m_DataNum;
	oe_scalar	m_GapThreshhold;

			oxe_MDF		();
	~		oxe_MDF		();
	void	DataNumSet	(int num);
	void	DoIt		();

	};


#endif	// _OXE_MDF_H_
