/*

	oxe_MFCUtils


  */

#include "stdafx.h"
#include "oe_v3.h"

int	oxe_G_SliderMin	=	0;
int	oxe_G_SliderMax	=	128;

void oxe_SliderInit(CSliderCtrl* slider)
	{
	if (!slider)
		return;

	slider	->	SetRange(oxe_G_SliderMin, oxe_G_SliderMax);
	}


void oxe_SliderSet(CSliderCtrl* slider, oe_scalar min, oe_scalar max, oe_scalar val)
	{
	if (!slider)
		return;

	if (max == min)
		return;

	if (slider -> GetStyle() & TBS_VERT)
		{
		oe_scalar	tmp;

		tmp	=	min;
		min	=	max;
		max	=	tmp;
		}

	slider -> SetPos((int)( (val - min) / (max - min) * (oe_scalar)(oxe_G_SliderMax - oxe_G_SliderMin) + (oe_scalar)oxe_G_SliderMin));
	}

oe_scalar oxe_SliderGet(CSliderCtrl* slider, oe_scalar min, oe_scalar max, oe_scalar* val)
	{
	if (!slider)
		return 0.0f;

	if (slider -> GetStyle() & TBS_VERT)
		{
		oe_scalar	tmp;

		tmp	=	min;
		min	=	max;
		max	=	tmp;
		}

	oe_scalar rtn;


	rtn	=	(oe_scalar)(slider -> GetPos() - oxe_G_SliderMin) / (oe_scalar)(oxe_G_SliderMax - oxe_G_SliderMin) * (max - min) + min;

	if (val)
		*val = rtn;

	return rtn;
	}

