/*

  oxe_3DObjDX9

  a subclass of oxe_3DObj

  */

#include <d3dx9.h>
#include "oe_std.h"
#include "oxe_3DObjDX9.h"

#ifndef OXE_INITDXSTRUCT
#define	OXE_INITDXSTRUCT(a) ZeroMemory(&a, sizeof(a)); a.dwSize	= sizeof(a);
#endif



oxe_3DObjDX9::oxe_3DObjDX9()
	{
	m_pd3dDevice	=	NULL;
	m_VB			=	NULL;
	m_IB			=	NULL;
	m_Tx			=	NULL;
	m_BPV			=	0;
	m_TotalBytes	=	0;
	}

oxe_3DObjDX9::~oxe_3DObjDX9()
	{
	VerticesNumSet	(0);
	IndicesNumSet	(0);
	TexSet			(NULL);
	}


void	oxe_3DObjDX9::Realloc()
	{
	if (!m_pd3dDevice)
		return;

	DWORD	totalBytes;

	// Determine length

	m_BPV	=	0;
	m_FVF	=	0;


	m_FVF		|=	D3DFVF_XYZ;
	m_BPV		+=	4 * 3;

	if (m_NormalsUse)
		{
		m_FVF	|=	D3DFVF_NORMAL;
		m_BPV	+=	4 * 3;
		}

	if ( m_TexCoords0Use && !m_TexCoords1Use)
		{
		m_FVF	|=	D3DFVF_TEX1;
		m_BPV	+=	4 * 2;
		}


	if (!m_TexCoords0Use &&  m_TexCoords1Use)
		{
		m_FVF	|=	D3DFVF_TEX1;
		m_BPV	+=	4 * 2;
		}

	if ( m_TexCoords0Use &&  m_TexCoords1Use)
		{
		m_FVF	|=	D3DFVF_TEX2;
		m_BPV	+=	4 * 4;
		}

	totalBytes		=	m_VerticesNum	*	m_BPV;

	if (totalBytes == m_TotalBytes)
		return;

	m_TotalBytes = totalBytes;

	if (m_VB != NULL)
		m_VB -> Release();

	m_VB = NULL;

	Touch();

	if (totalBytes <= 0)
		return;

	m_pd3dDevice	->	CreateVertexBuffer(totalBytes, D3DUSAGE_WRITEONLY, m_FVF, D3DPOOL_DEFAULT, &m_VB, NULL);

	}

void	oxe_3DObjDX9::UnTouchVerts()
	{
	if (!m_TouchedVerts)
		return;

	Realloc();

	VOID*			VBStart;
	unsigned char*	vertex;
	float*			vertexF;
	int				i, inum;
	oe_scalar*		v;
	oe_scalar*		n;
	oe_scalar*		t0;
	oe_v3*			v3;
	oe_v3*			n3;
	oe_v2*			t02;


	if (FAILED(m_VB ->Lock(0, 0, &VBStart, D3DLOCK_DISCARD)))
		return;

	// since this loop will be called all the time,
	// i'm taking all the if statements i can outside of it.
	// todo  - This could be further optimized to eliminate the
	// += stride in each loop, by having 16 (15?) different for/loops,
	// one for each combo of v, n, t1, t2. This would also eliminate
	// most of the i < inum compares and i++ ops.
	// todo - This would benefit from any optimization: assembly, mmx, pIII, PIV etc.

	v3	=	m_Vertices;
	n3	=	m_Normals;

	inum	=	m_VerticesNum;
	vertex	=	(unsigned char*)VBStart;
	vertex	+=	0;
	for (i = 0; i < inum; i++)
		{
		vertexF		=	(float*)vertex;
		v			=	v3++ -> m_Value;

		// Vertex
		*vertexF++	=	*v++;
		*vertexF++	=	*v++;
		*vertexF++	=	*v;

		if (m_NormalsUse)
			{
			// Normal
			n			=	n3++ -> m_Value;
			*vertexF++	=	*n++;
			*vertexF++	=	*n++;
			*vertexF++	=	*n;
			}

		vertex		+=	m_BPV;
		}
	
	if (m_TouchedTexs0 && m_TexCoords0Use)
		{
		inum	=	m_VerticesNum;
		vertex	=	(unsigned char*)VBStart;
		vertex	+=	6 * 4;
		t02		=	m_TexCoords0;
		for (i = 0; i < inum; i++)
			{
			vertexF		=	(float*)vertex;
			t0			=	t02++ -> m_Value;
			
			*vertexF++	=	*t0++;
			*vertexF++	=	*t0;
			
			vertex		+=	m_BPV;
			}
		}

	m_VB -> Unlock();

	m_TouchedVerts	=	false;
	m_TouchedNorms	=	false;
	m_TouchedTexs0	=	false;
	m_TouchedTexs1	=	false;

//	UnTouch();
	}

void	oxe_3DObjDX9::UnTouchNorms()
	{
	if (!m_TouchedNorms)
		return;

	Realloc();

	m_TouchedNorms	=	false;
	}

void	oxe_3DObjDX9::UnTouchTexs0()
	{


	this ->m_Tx->LockRect(

	if (!m_TouchedTexs0)
		return;

	Realloc();





	m_TouchedTexs0	=	false;
	}

void	oxe_3DObjDX9::UnTouchTexs1()
	{
	if (!m_TouchedTexs1)
		return;

	Realloc();

	m_TouchedTexs1	=	false;
	}

void	oxe_3DObjDX9::UnTouchIndxs()
	{
	if (!m_TouchedIndxs)
		return;

	if (m_IB != NULL)
		m_IB -> Release();
	
	m_IB = NULL;

	if (m_IndicesNum <= 0)
		return;
	
	m_pd3dDevice	->	CreateIndexBuffer(m_IndicesNum * 2, 0, D3DFMT_INDEX16, D3DPOOL_DEFAULT, &m_IB, NULL);

	if (!m_IB)
		return;

	void*			ib;
	unsigned short*	ibw;
	unsigned short*	ibw2;
	int				i;
	HRESULT			poo;

	poo	=	m_IB -> Lock(0, 0, &ib, 0);

	if (!ib)
		return;

	ibw		=	(unsigned short*)ib;
	ibw2	=	ibw;

	for (i = 0; i < m_IndicesNum; i++)
		{
		*ibw2++	=	(unsigned short)m_Indices[i];
		}

	poo	=	m_IB -> Unlock();

	m_TouchedIndxs	=	false;
	}



void	oxe_3DObjDX9::Render()
	{
	if (!m_pd3dDevice)
		return;

	UnTouch();


	m_pd3dDevice ->	SetTexture( 0, m_Tx );
	m_pd3dDevice ->	SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	m_pd3dDevice ->	SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
	m_pd3dDevice ->	SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_SPECULAR );
	m_pd3dDevice ->	SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );

	m_pd3dDevice ->	SetStreamSource	(0, m_VB, 0, m_BPV);
	m_pd3dDevice ->	SetIndices		(m_IB);
	m_pd3dDevice -> SetFVF			(m_FVF);
	m_pd3dDevice ->	DrawIndexedPrimitive
						(
						D3DPT_TRIANGLELIST,
						0,
						0,
						m_VerticesNum,
						0,
						m_IndicesNum / 3);
//	if (m_Material.m_DrawNormals)
//		RenderNorms();
	}

void	oxe_3DObjDX9::TexSet(const char* fn)
	{
	if (!m_pd3dDevice)
		return;
	
    if (m_Tx	!=	NULL)
        m_Tx	->	Release();
	
	m_Tx	=	NULL;

	if (fn == NULL)
		return;

    if (FAILED(D3DXCreateTextureFromFile(m_pd3dDevice, fn, &m_Tx)))
		return;

	m_Tx = m_Tx;
	}


/*
void	oxe_3DObjDX9::RenderNorms()
	{
	if (!m_RendDX || !m_RendDX -> m_lpD3DDevice)
		return;

	oe_v3	v1;
	float	data[6];
	WORD	i;

	for (i = 0; i < m_VerticesNum; i++)
		{
		v1		=	m_Vertices	[i];
		data[0]	=	v1.m_Value	[0];
		data[1]	=	v1.m_Value	[1];
		data[2]	=	v1.m_Value	[2];

		v1		+=	m_Normals	[i] * 0.05f;

		data[3]	=	v1.m_Value	[0];
		data[4]	=	v1.m_Value	[1];
		data[5]	=	v1.m_Value	[2];

		m_RendDX -> m_pd3dDevice ->DrawPrimitive(
										D3DPT_LINELIST,
										D3DFVF_XYZ,
										data,
										2,
										0);
		}
	}

*/






















