/*

  oxe_3DObjDX

  a subclass of oxe_3DObj

  */

#include "oe_std.h"
#include "oxe_3DObjDX.h"
#include "oxe_RendDX2.h"

#ifndef OXE_INITDXSTRUCT
#define	OXE_INITDXSTRUCT(a) ZeroMemory(&a, sizeof(a)); a.dwSize	= sizeof(a);
#endif



oxe_3DObjDX::oxe_3DObjDX()
	{
	m_RendDX	=	NULL;
	m_VB		=	NULL;
	m_BPV		=	0;
	m_FVF		=	D3DFVF_XYZ|D3DFVF_NORMAL;

	OXE_INITDXSTRUCT8(m_VBDesc);
	}

oxe_3DObjDX::~oxe_3DObjDX()
	{
	}


void	oxe_3DObjDX::Realloc()
	{
	if (!m_RendDX)
		return;

	DWORD	totalBytes;

	// Determine length

	m_BPV	=	0;
	m_FVF	=	0;

	if ( m_TexCoords0Use && !m_TexCoords1Use)
		{
		m_FVF	|=	D3DFVF_TEX1;
		m_BPV	+=	4 * 2;
		}

	if (!m_TexCoords0Use &&  m_TexCoords1Use)
		{
		m_FVF	|=	D3DFVF_TEX1;
		m_BPV	+=	4 * 2;
		}

	if ( m_TexCoords0Use &&  m_TexCoords1Use)
		{
		m_FVF	|=	D3DFVF_TEX2;
		m_BPV	+=	4 * 4;
		}

	m_FVF		|=	D3DFVF_XYZ;
	m_BPV		+=	4 * 3;

	m_FVF		|=	D3DFVF_NORMAL;
	m_BPV		+=	4 * 3;

	totalBytes		=	m_VerticesNum	*	m_BPV;

	m_RendDX -> m_pd3dDevice -> CreateVertexBuffer(totalBytes, D3DUSAGE_WRITEONLY, FVF, D3DPOOL_DEFAULT, &m_VB);
	}

void	oxe_3DObjDX::UnTouchVerts()
	{
	if (!m_TouchedVerts)
		return;

	Realloc();

	DWORD			stride;
	unsigned char*	VBStart;
	unsigned char*	vertex;
	float*			vertexF;
	DWORD			size;
	int				i, inum;
	oe_scalar*		v;
	oe_scalar*		n;
	oe_v3*			v3;
	oe_v3*			n3;

	stride	=	0;
	
	if (1)
		stride	+=	sizeof(float)	*	3;
	if (m_NormalsUse)
		stride	+=	sizeof(float)	*	3;
	if (m_TexCoords0Use)
		stride	+=	sizeof(float)	*	2;
	if (m_TexCoords0Use)
		stride	+=	sizeof(float)	*	2;

	if (FAILED(m_VB ->Lock(0, 0, (unsigned char**)(&VBStart), D3DLOCK_DISCARD)))
		return;

	// since this loop will be called all the time,
	// i'm taking all the if statements i can outside of it.
	// todo  - This could be further optimized to eliminate the
	// += stride in each loop, by having 16 (15?) different for/loops,
	// one for each combo of v, n, t1, t2. This would also eliminate
	// most of the i < inum compares and i++ ops.
	// todo - This would benefit from any optimization: assembly, mmx, pIII, PIV etc.

	v3	=	m_Vertices;
	n3	=	m_Normals;

	inum	=	m_VerticesNum;
	vertex	=	VBStart;
	vertex	+=	0;
	for (i = 0; i < inum; i++)
		{
		vertexF		=	(float*)vertex;
		v			=	v3++ -> m_Value;
		n			=	n3++ -> m_Value;

		// Vertex
		*vertexF++	=	*v++;
		*vertexF++	=	*v++;
		*vertexF++	=	*v;

		// Normal
		*vertexF++	=	*n++;
		*vertexF++	=	*n++;
		*vertexF	=	*n;

		vertex		+=	stride;
		}
	
	m_VB -> Unlock();

	m_TouchedVerts	=	false;
	m_TouchedNorms	=	false;
	m_TouchedTexs0	=	false;
	m_TouchedTexs1	=	false;
	}

void	oxe_3DObjDX::UnTouchNorms()
	{
	if (!m_TouchedNorms)
		return;

	Realloc();

	m_TouchedNorms	=	false;
	}

void	oxe_3DObjDX::UnTouchTexs0()
	{
	if (!m_TouchedTexs0)
		return;

	Realloc();

	m_TouchedTexs0	=	false;
	}

void	oxe_3DObjDX::UnTouchTexs1()
	{
	if (!m_TouchedTexs1)
		return;

	Realloc();

	m_TouchedTexs1	=	false;
	}

void	oxe_3DObjDX::Render()
	{
	if (!m_RendDX || !m_RendDX -> m_lpD3DDevice)
		return;

	UnTouch();

	m_RendDX ->	m_Mode_State.m_Cull			=	m_Material.m_Cull;
	m_RendDX ->	m_Mode_State.m_Care_Cull	=	TRUE;
	m_RendDX ->	m_Mode_State.m_Fill			=	m_Material.m_Fill;
	m_RendDX ->	m_Mode_State.m_Care_Fill	=	TRUE;

	m_RendDX -> ModeSet(&m_RendDX ->m_Mode_State);

	m_RendDX -> m_pd3dDevice ->	SetStreamSource(0, m_VB, 
		
	m_pd3dDevice->SetVertexShader(m_FVF);



	m_RendDX -> m_pd3dDevice ->	DrawIndexedPrimitive
									(
									D3DPT_TRIANGLELIST,
									0,
									m_IndicesNum,
									0,
									m_IndicesNum
									);

	if (m_Material.m_DrawNormals)
		RenderNorms();
	}

void	oxe_3DObjDX::RenderNorms()
	{
	if (!m_RendDX || !m_RendDX -> m_lpD3DDevice)
		return;

	oe_v3	v1;
	float	data[6];
	WORD	i;

	for (i = 0; i < m_VerticesNum; i++)
		{
		v1		=	m_Vertices	[i];
		data[0]	=	v1.m_Value	[0];
		data[1]	=	v1.m_Value	[1];
		data[2]	=	v1.m_Value	[2];

		v1		+=	m_Normals	[i] * 0.05f;

		data[3]	=	v1.m_Value	[0];
		data[4]	=	v1.m_Value	[1];
		data[5]	=	v1.m_Value	[2];

		m_RendDX -> m_pd3dDevice ->DrawPrimitive(
										D3DPT_LINELIST,
										D3DFVF_XYZ,
										data,
										2,
										0);
		}
	}

void oxe_3DObjDX::TexSet(const char* fn)
	{

	}

