
/*

  oxe_3DObj

  a 3d object class

  This is the render-independant base class.

  */

#include "oe_std.h"
#include "oxe_3DObj.h"


oxe_3DObj::oxe_3DObj()
	{
	m_VerticesNum	=	0;
	m_Vertices		=	NULL;
	m_Normals		=	NULL;
	m_TexCoords0	=	NULL;
	m_TexCoords1	=	NULL;
	m_TexCoords0Use	=	false;
	m_TexCoords1Use	=	false;
	m_NormalsUse	=	false;
	m_IndexMode		=	0;
	m_IndicesNum	=	0;
	m_Indices		=	NULL;
	}

oxe_3DObj::~oxe_3DObj()
	{
	VerticesNumSet	(0);
	IndicesNumSet	(0);
	}

// return 0 on success
int	oxe_3DObj::VerticesNumSet(int num)
	{
	if (num == m_VerticesNum)
		return	0;

	if (m_VerticesNum != 0 && m_Vertices != NULL)
		{
		OE_DELETEARRAY(m_Vertices	);
		OE_DELETEARRAY(m_Normals	);
		OE_DELETEARRAY(m_TexCoords0	);
		OE_DELETEARRAY(m_TexCoords1	);
		m_VerticesNum	=	0;
		}

	if (num <= 0)
		return 0;

	m_Vertices			=	new	oe_v3[num];
	if (m_NormalsUse)
		m_Normals		=	new	oe_v3[num];
	if (m_TexCoords0Use)
		m_TexCoords0	=	new	oe_v2[num];
	if (m_TexCoords1Use)
		m_TexCoords1	=	new	oe_v2[num];

	if (m_Vertices)
		m_VerticesNum	=	num;

	return num - m_VerticesNum;
	}

// return 0 on success
int	oxe_3DObj::IndicesNumSet(int num)
	{
	if (num == m_IndicesNum)
		return	0;

	if (m_IndicesNum != 0 && m_Indices != NULL)
		{
		delete	[]	m_Indices;
		m_IndicesNum	=	0;
		}

	TouchIndxs();

	if (num <= 0)
		return 0;

	m_Indices	=	new	int[num];
	if (m_Indices)
		m_IndicesNum	=	num;

	return num - m_IndicesNum;
	}


void	oxe_3DObj::MakeCube(oe_scalar r)
	{
	VerticesNumSet(8);

	int			i;

	m_Vertices	[0].m_Value[0]	=	-r;
	m_Vertices	[0].m_Value[1]	=	-r;
	m_Vertices	[0].m_Value[2]	=	-r;

	m_TexCoords0[0].m_Value[0]	=	-r;
	m_TexCoords0[0].m_Value[1]	=	-r;


	m_Vertices	[1].m_Value[0]	=	 r;
	m_Vertices	[1].m_Value[1]	=	-r;
	m_Vertices	[1].m_Value[2]	=	-r;
	
	m_TexCoords0[1].m_Value[0]	=	-r;
	m_TexCoords0[1].m_Value[1]	=	-r;


	m_Vertices	[2].m_Value[0]	=	-r;
	m_Vertices	[2].m_Value[1]	=	 r;
	m_Vertices	[2].m_Value[2]	=	-r;
	
	m_TexCoords0[2].m_Value[0]	=	-r;
	m_TexCoords0[2].m_Value[1]	=	 r;


	m_Vertices	[3].m_Value[0]	=	 r;
	m_Vertices	[3].m_Value[1]	=	 r;
	m_Vertices	[3].m_Value[2]	=	-r;
	
	m_TexCoords0[3].m_Value[0]	=	-r;
	m_TexCoords0[3].m_Value[1]	=	 r;


	m_Vertices	[4].m_Value[0]	=	-r;
	m_Vertices	[4].m_Value[1]	=	-r;
	m_Vertices	[4].m_Value[2]	=	 r;
	
	m_TexCoords0[4].m_Value[0]	=	 r;
	m_TexCoords0[4].m_Value[1]	=	-r;


	m_Vertices	[5].m_Value[0]	=	 r;
	m_Vertices	[5].m_Value[1]	=	-r;
	m_Vertices	[5].m_Value[2]	=	 r;
	
	m_TexCoords0[5].m_Value[0]	=	 r;
	m_TexCoords0[5].m_Value[1]	=	-r;


	m_Vertices	[6].m_Value[0]	=	-r;
	m_Vertices	[6].m_Value[1]	=	 r;
	m_Vertices	[6].m_Value[2]	=	 r;
	
	m_TexCoords0[6].m_Value[0]	=	 r;
	m_TexCoords0[6].m_Value[1]	=	 r;


	m_Vertices	[7].m_Value[0]	=	 r;
	m_Vertices	[7].m_Value[1]	=	 r;
	m_Vertices	[7].m_Value[2]	=	 r;
	
	m_TexCoords0[7].m_Value[0]	=	 r;
	m_TexCoords0[7].m_Value[1]	=	 r;


	IndicesNumSet(6 * 2 * 3);

	i	=	0;
	m_Indices[i++]	=	0;
	m_Indices[i++]	=	2;
	m_Indices[i++]	=	1;

	m_Indices[i++]	=	3;
	m_Indices[i++]	=	1;
	m_Indices[i++]	=	2;

	m_Indices[i++]	=	1;
	m_Indices[i++]	=	3;
	m_Indices[i++]	=	5;

	m_Indices[i++]	=	7;
	m_Indices[i++]	=	5;
	m_Indices[i++]	=	3;

	m_Indices[i++]	=	5;
	m_Indices[i++]	=	7;
	m_Indices[i++]	=	4;

	m_Indices[i++]	=	6;
	m_Indices[i++]	=	4;
	m_Indices[i++]	=	7;
	
	m_Indices[i++]	=	4;
	m_Indices[i++]	=	6;
	m_Indices[i++]	=	0;

	m_Indices[i++]	=	2;
	m_Indices[i++]	=	0;
	m_Indices[i++]	=	6;

	m_Indices[i++]	=	3;
	m_Indices[i++]	=	2;
	m_Indices[i++]	=	7;
	
	m_Indices[i++]	=	6;
	m_Indices[i++]	=	7;
	m_Indices[i++]	=	2;

	m_Indices[i++]	=	0;
	m_Indices[i++]	=	1;
	m_Indices[i++]	=	4;

	m_Indices[i++]	=	5;
	m_Indices[i++]	=	4;
	m_Indices[i++]	=	1;

	MakeNormalsSpherical();


	TouchVerts();
	TouchNorms();
	TouchTexs0();
//	TouchIndxs();
	}

void	oxe_3DObj::MakeNormalsSpherical(oe_v3& origin)
	{
	oe_v3	v1;
	long	i;

	if (!m_NormalsUse)
		return;

	for (i = 0; i < m_VerticesNum; i++)
		{
		m_Vertices[i].Minus(origin, v1);
		v1.Norm(m_Normals[i]);
		}

	TouchNorms();
	}

void	oxe_3DObj::MakeNormalsSpherical()
	{
	oe_v3	origin;

	origin.Set(0.0, 0.0, 0.0);

	MakeNormalsSpherical(origin);
	}


void	oxe_3DObj::MakeDonut(
							oe_scalar	rMajor,
							oe_scalar	rMinor,
							unsigned short	segsMajor,
							unsigned short	segsMinor,
							oe_scalar	majPertFreq,
							oe_scalar	majPertAmp,
							oe_scalar	majPertPhase,
							oe_scalar	majTwists,
							oe_scalar	twistAmp,
							oe_scalar	twistOffset,
							oe_scalar	twistRate,
							oe_scalar	t,
							int			flags
							)
	{
	int	prevVertsNum;
	
	prevVertsNum	=	m_VerticesNum;

	VerticesNumSet	(segsMajor * segsMinor			);
	IndicesNumSet	(segsMajor * segsMinor * 2 * 3	);


	// Calculate the spine along the major axis (Y)
	// Then calculate the ribs.
	// In each case, derive "axis vectors" and manipulate.

	oe_v3		vMajX;
	oe_v3		vMajZ;
	oe_v3		vMinX;
	oe_v3		vMinY;
	oe_v3		vSpine;
	oe_v3		vN;
	oe_scalar	aMaj;	// angle major
	oe_scalar	aMin;	// angle minor
	oe_scalar	daMaj;
	oe_scalar	daMin;
	int			smaj;
	int			smin;
	oe_v3*		v;
	oe_v3*		n;
	oe_scalar	aPertMaj;
	oe_scalar	daPertMaj;
	oe_scalar	pertMaj;

	oe_scalar	aMajTwists;
	oe_scalar	daMajTwists;

	static	oe_scalar	m_MajTwists		= 0.0f;
	static	oe_scalar	m_MajPertFreq	= 0.0f;
	

	vMajX	.Set(rMajor	, 0.0f	, 0.0f	);
	vMajZ	.Set(0.0f	, 0.0f	, rMajor);

	daMaj		=	OE_2PI	/	(oe_scalar)segsMajor;
	daMin		=	OE_2PI	/	(oe_scalar)segsMinor;
	aMaj		=	0.0f;

	if (flags & 1)
		{
		oe_scalar	zap	=	.92f;
		majTwists		= (float)(int)(majTwists	+ 0.5f);
		majPertFreq		= (float)(int)(majPertFreq	+ 0.5f);

		m_MajTwists		= m_MajTwists	* zap + majTwists	* (1.0f - zap);
		m_MajPertFreq	= m_MajPertFreq * zap + majPertFreq	* (1.0f - zap);

		majTwists		= m_MajTwists;
		majPertFreq		= m_MajPertFreq;
		}

	
	daPertMaj	=	majPertFreq					* OE_2PI / (oe_scalar)segsMajor;
	aPertMaj	=	majPertPhase	-majPertFreq* OE_2PI / 2.0f;


	daMajTwists	=	majTwists					* OE_2PI / (oe_scalar)segsMajor;
	aMajTwists	=	twistOffset		-majTwists	* OE_2PI / 2.0f;
	

	v		=	m_Vertices;
	n		=	m_Normals;

	for (smaj = 0; smaj < segsMajor; smaj++)
		{
		pertMaj	=	majPertAmp * (oe_sin(aPertMaj)/* + oe_sin(aPertMaj - majPertPhase*.345)*/) * 0.5f;
		aPertMaj	+=	daPertMaj;
		
		// Calculate spine location
		vSpine		=	vMajX * oe_cos(aMaj);
		vSpine		+=	vMajZ * oe_sin(aMaj);

//		vSpine		=	vMajX * aMaj;

		vSpine.Norm(vMinX);
//		vMinX	=	vMajZ;
		vMinX		*=	rMinor + pertMaj;
		vMinY		.	Set(0.0f, rMinor + pertMaj, 0.0f);
	


		aMin	=	0.0f;
		for (smin = 0; smin < segsMinor; smin++)
			{
			vN	=	vMinX	*	oe_cos(aMin + aMajTwists);
			vN	+=	vMinY	*	oe_sin(aMin + aMajTwists);
//			vN.Norm(*n++);

			// this line generates the ridges that go around the minor axis.
//			vN	*=	1.0f	+	oe_sin(aMin * 3.0f + t * .2415f) * .95f;
			vN	*=	1.0f	+	oe_sin(aMin * 3.0f + t * 4.2415f) * twistAmp;
//			vN	*=	twistOffset + oe_sin(aMin * majTwists + t * twistRate) * twistAmp;

			*v		=	vSpine;
			*v++	+=	vN;

//			vN.Norm(vN);
//			*n++	=	vN;

			aMin	+=	daMin;
			}

		aMaj		+=	daMaj;
		aMajTwists	+=	daMajTwists;

/*
		if (aMaj > OE_PI && !(flags & 1))
			{
			daMajTwists	=	-majTwists		* OE_2PI / (oe_scalar)segsMajor;
			daPertMaj	=	-majPertFreq	* OE_2PI / (oe_scalar)segsMajor;
			}
*/
		
		}


	if (prevVertsNum != m_VerticesNum)
		{

		// Now generate connectivity

		int		lead;
		int		foll;
		int*	index;

		index		=	m_Indices;


		lead		=	0;
		foll		=	segsMinor * (segsMajor - 1);

		*index++	=	foll + segsMinor - 1;
		*index++	=	lead;
		*index++	=	lead + segsMinor - 1;

		*index++	=	lead;
		*index++	=	foll + segsMinor - 1;
		*index++	=	foll;

		lead++;
		foll++;

		for (smin = 1; smin < segsMinor; smin++)
			{
			*index++	=	foll - 1;
			*index++	=	lead;
			*index++	=	lead - 1;

			*index++	=	lead;
			*index++	=	foll - 1;
			*index++	=	foll;

			lead++;
			foll++;
			}
		
		
		for (smaj = 1; smaj < segsMajor; smaj++)
			{
			lead	=	segsMinor * (smaj		);
			foll	=	segsMinor * (smaj - 1	);

			*index++	=	foll + segsMinor - 1;
			*index++	=	lead;
			*index++	=	lead + segsMinor - 1;

			*index++	=	lead;
			*index++	=	foll + segsMinor - 1;
			*index++	=	foll;

			lead++;
			foll++;

			for (smin = 1; smin < segsMinor; smin++)
				{
				*index++	=	foll - 1;
				*index++	=	lead;
				*index++	=	lead - 1;

				*index++	=	lead;
				*index++	=	foll - 1;
				*index++	=	foll;

				lead++;
				foll++;
				}
			}

		if (m_TexCoords0Use)
			{
			oe_v2* t0;
			
			t0		=	m_TexCoords0;
			float	u, du;
			float	v, dv;


			du	=	1.0f / (float)(segsMajor);
			dv	=	1.0f / (float)(segsMinor);
			
			u	=	0.0f;
			for (smaj = 0; smaj < segsMajor; smaj++)
				{
				v	=	0.0f;
				for (smin = 0; smin < segsMinor; smin++)
					{
					t0 -> m_Value[0]	=	u;
					t0 -> m_Value[1]	=	v;
					t0++;
					v	+=	dv;
					}
				u	+=	du;
				}
			}
		}


	if (m_NormalsUse)
		{
		// Calculate normals.
		// These normals are not going to be _quite_ accurate,
		// but they will be pretty close.
		int		i;
		int*	index;
	//	oe_v3*	n;
		oe_v3	v0;
		oe_v3	v1;
		oe_v3	v2;

		n	=	m_Normals;
		for (i = 0; i < m_VerticesNum; i++)
			{
			index	=	m_Indices + i * 6;
			m_Vertices[*(index + 1)].Minus(m_Vertices[*(index    )], v1);
			m_Vertices[*(index + 2)].Minus(m_Vertices[*(index    )], v2);
			v1.Cross(v2, v0);
			v0.Norm(*n++);
			}
		}

	

		
	Touch();
//	TouchIndxs();
	}





