/*

oe_v4.h

Simple Vector Class
by orion elenzil

*/


#ifndef	_OE_V4_H_
#define	_OE_V4_H_

#include "oe_v3.h"

#define	OE_W	3

#define	OE_YX	4
#define	OE_ZX	5
#define	OE_YZ	6
#define	OE_WX	7
#define	OE_WY	8
#define	OE_WZ	9

#define	OE_XY	OE_YX
#define	OE_XZ	OE_ZX
#define	OE_ZY	OE_YZ
#define	OE_XW	OE_WX
#define	OE_YW	OE_WY
#define	OE_ZW	OE_WZ

class	oe_v4
	{
	public:

	oe_scalar	m_Value[4];

   			   			oe_v4		();
						oe_v4		(oe_scalar	x, oe_scalar	y, oe_scalar	z, oe_scalar	w);
	void	  			Set	 		(oe_scalar	x, oe_scalar	y, oe_scalar	z, oe_scalar	w);
	void	  			Get	 		(oe_scalar&	x, oe_scalar&	y, oe_scalar&	z, oe_scalar&	w);
	oe_scalar*			Get	 		();
	void				Get	 		(oe_scalar* v);

	// convenient operators
	oe_v4&	operator	=			(const  oe_v4&		v);
	oe_v4&	operator	=			(const  oe_v3&		v);

	oe_v4	operator	+			(const	oe_v4&		v);
	oe_v4	operator	-			(const	oe_v4&		v);
	oe_v4	operator	*			(const	oe_v4&		v);
	oe_v4	operator	/			(const	oe_v4&		v);

	oe_v4&	operator	-=			(const	oe_v4&		v);
	oe_v4&	operator	+=			(const	oe_v4&		v);
	oe_v4&	operator	*=			(const	oe_v4&		v);
	oe_v4&	operator	/=			(const	oe_v4&		v);

	oe_v4	operator	*			(		oe_scalar	s);
	oe_v4	operator	/			(		oe_scalar	s);
	oe_v4&	operator	*=			(		oe_scalar	s);
	oe_v4&	operator	/=			(		oe_scalar	s);

//	oe_v4				Cross		(const	oe_v4&		va,	const	oe_v4&		vb);
//	oe_v4&				CrossEq		(const	oe_v4&		va,	const	oe_v4&		vb);

	oe_v4				Normalized	();
	oe_v4&				NormalizedEq();

	// inconvenient but faster versions of the same operators.
	void				Plus		(oe_v4&		src,	oe_v4& dst);
	void				Minus		(oe_v4&		src,	oe_v4& dst);
	void				Mult		(oe_v4&		src,	oe_v4& dst);
	void				Div			(oe_v4&		src,	oe_v4& dst);
	void				Mult		(oe_scalar	src,	oe_v4& dst);
	void				Div			(oe_scalar	src,	oe_v4& dst);
	oe_scalar			Dot			(oe_v4&		src);
	oe_scalar			Length		();
	void				Norm		(					oe_v4& dst);
	void				Cross		(oe_v4&		src,	oe_v4& dst);

	void				RotX		(oe_scalar	theta,	oe_v4& dst);
	void				RotY		(oe_scalar	theta,	oe_v4& dst);
	void				RotZ		(oe_scalar	theta,	oe_v4& dst);
	void				RotW		(oe_scalar	theta,	oe_v4& dst);

	void				RotWX		(oe_scalar	theta,	oe_v4& dst);
	void				RotWY		(oe_scalar	theta,	oe_v4& dst);
	void				RotWZ		(oe_scalar	theta,	oe_v4& dst);
	void				RotYX		(oe_scalar	theta,	oe_v4& dst);
	void				RotZX		(oe_scalar	theta,	oe_v4& dst);
	void				RotYZ		(oe_scalar	theta,	oe_v4& dst);

	void				RotWX		(oe_scalar	s, oe_scalar c,	oe_v4& dst);
	void				RotWY		(oe_scalar	s, oe_scalar c,	oe_v4& dst);
	void				RotWZ		(oe_scalar	s, oe_scalar c,	oe_v4& dst);
	void				RotYX		(oe_scalar	s, oe_scalar c,	oe_v4& dst);
	void				RotZX		(oe_scalar	s, oe_scalar c,	oe_v4& dst);
	void				RotYZ		(oe_scalar	s, oe_scalar c,	oe_v4& dst);


	// Line Routines
	void				ClosestPointOnLine			(oe_v4& line_pt, oe_v4& line_v, oe_v4& dst);
	void				ClosestPointOnLine_NoNorm	(oe_v4& line_pt, oe_v4& line_v, oe_v4& dst);
	oe_scalar			DistanceToLine				(oe_v4& line_pt, oe_v4& line_v);
	oe_scalar			DistanceToLine_NoNorm		(oe_v4& line_pt, oe_v4& line_v);
	};



//
//
// class definitions above, implementations below
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
//
//
//


inline	oe_v4::oe_v4()
	{
//	opted not to initialize, as this happens for all the inlines and all.
//	Set(0.0, 0.0, 0.0);
	}

inline	oe_v4::oe_v4(oe_scalar x, oe_scalar y, oe_scalar z, oe_scalar w)
	{
	Set(x, y, z, w);
	}


inline	void	oe_v4::Set(oe_scalar x, oe_scalar y, oe_scalar z, oe_scalar w)
	{
	m_Value[OE_X]	= x;
	m_Value[OE_Y]	= y;
	m_Value[OE_Z]	= z;
	m_Value[OE_W]	= w;
	}

inline	void	oe_v4::Get(oe_scalar& x, oe_scalar& y, oe_scalar& z, oe_scalar& w)
	{
	x = m_Value[OE_X];
	y = m_Value[OE_Y];
	z = m_Value[OE_Z];
	w = m_Value[OE_W];
	}

inline	oe_scalar*	oe_v4::Get()
	{
	return(m_Value);
	}

inline	void	oe_v4::Get(oe_scalar* v)
	{
	v[OE_X]	=	m_Value[OE_X];
	v[OE_Y]	=	m_Value[OE_Y];
	v[OE_Z]	=	m_Value[OE_Z];
	v[OE_W]	=	m_Value[OE_W];
	}

inline	oe_v4	oe_v4::operator	+	(const oe_v4& v)
	{
	oe_v4	v1;

	v1.m_Value[OE_X] = v.m_Value[OE_X] + m_Value[OE_X];
	v1.m_Value[OE_Y] = v.m_Value[OE_Y] + m_Value[OE_Y];
	v1.m_Value[OE_Z] = v.m_Value[OE_Z] + m_Value[OE_Z];
	v1.m_Value[OE_W] = v.m_Value[OE_W] + m_Value[OE_W];

	return(v1);
	}

inline	oe_v4	oe_v4::operator	-	(const oe_v4& v)
	{
	oe_v4	v1;

	v1.m_Value[OE_X] = m_Value[OE_X] - v.m_Value[OE_X];
	v1.m_Value[OE_Y] = m_Value[OE_Y] - v.m_Value[OE_Y];
	v1.m_Value[OE_Z] = m_Value[OE_Z] - v.m_Value[OE_Z];
	v1.m_Value[OE_W] = m_Value[OE_W] - v.m_Value[OE_W];

	return(v1);
	}

// This is a component-wise multiplication,
// which isn't normally a standard 3D vector operation,
// but i have wanted it from time to time.
// THIS IS NOT DOT PRODUCT !!
inline	oe_v4	oe_v4::operator	*	(const oe_v4& v)
	{
	oe_v4	v1;

	v1.m_Value[OE_X] = v.m_Value[OE_X] * m_Value[OE_X];
	v1.m_Value[OE_Y] = v.m_Value[OE_Y] * m_Value[OE_Y];
	v1.m_Value[OE_Z] = v.m_Value[OE_Z] * m_Value[OE_Z];
	v1.m_Value[OE_W] = v.m_Value[OE_W] * m_Value[OE_W];

	return(v1);
	}

// This is a component-wise division,
// which isn't normally a standard 3D vector operation,
// but i have wanted it from time to time.
inline	oe_v4	oe_v4::operator	/	(const oe_v4& v)
	{
	oe_v4	v1;

	v1.m_Value[OE_X] = m_Value[OE_X] / v.m_Value[OE_X];
	v1.m_Value[OE_Y] = m_Value[OE_Y] / v.m_Value[OE_Y];
	v1.m_Value[OE_Z] = m_Value[OE_Z] / v.m_Value[OE_Z];
	v1.m_Value[OE_W] = m_Value[OE_W] / v.m_Value[OE_W];

	return(v1);
	}

inline	oe_v4&	oe_v4::operator	=	(const oe_v4& v)
	{
	m_Value[OE_X] = v.m_Value[OE_X];
	m_Value[OE_Y] = v.m_Value[OE_Y];
	m_Value[OE_Z] = v.m_Value[OE_Z];
	m_Value[OE_W] = v.m_Value[OE_W];

	return(*this);
	}

inline	oe_v4&	oe_v4::operator	=	(const oe_v3& v)
	{
	m_Value[OE_X] = v.m_Value[OE_X];
	m_Value[OE_Y] = v.m_Value[OE_Y];
	m_Value[OE_Z] = v.m_Value[OE_Z];
	m_Value[OE_W] = 0.0f;

	return(*this);
	}

inline	oe_v4&	oe_v4::operator	+=	(const oe_v4& v)
	{
	m_Value[OE_X] += v.m_Value[OE_X];
	m_Value[OE_Y] += v.m_Value[OE_Y];
	m_Value[OE_Z] += v.m_Value[OE_Z];
	m_Value[OE_W] += v.m_Value[OE_W];

	return(*this);
	}

inline	oe_v4&	oe_v4::operator	-=	(const oe_v4& v)
	{
	m_Value[OE_X] -= v.m_Value[OE_X];
	m_Value[OE_Y] -= v.m_Value[OE_Y];
	m_Value[OE_Z] -= v.m_Value[OE_Z];
	m_Value[OE_W] -= v.m_Value[OE_W];

	return(*this);
	}

// This is a component-wise multiplication,
// which isn't normally a standard 3D vector operation,
// but i have wanted it from time to time.
// THIS IS NOT DOT PRODUCT !!
inline	oe_v4&	oe_v4::operator	*=	(const oe_v4& v)
	{
	m_Value[OE_X] *= v.m_Value[OE_X];
	m_Value[OE_Y] *= v.m_Value[OE_Y];
	m_Value[OE_Z] *= v.m_Value[OE_Z];
	m_Value[OE_W] *= v.m_Value[OE_W];

	return(*this);
	}

// This is a component-wise division,
// which isn't normally a standard 3D vector operation,
// but i have wanted it from time to time.
inline	oe_v4&	oe_v4::operator	/=	(const oe_v4& v)
	{
	m_Value[OE_X] /= v.m_Value[OE_X];
	m_Value[OE_Y] /= v.m_Value[OE_Y];
	m_Value[OE_Z] /= v.m_Value[OE_Z];
	m_Value[OE_W] /= v.m_Value[OE_W];

	return(*this);
	}

inline	oe_v4	oe_v4::operator	*	(const oe_scalar s)
	{
	oe_v4	v1;

	v1.m_Value[OE_X] = m_Value[OE_X] * s;
	v1.m_Value[OE_Y] = m_Value[OE_Y] * s;
	v1.m_Value[OE_Z] = m_Value[OE_Z] * s;
	v1.m_Value[OE_W] = m_Value[OE_W] * s;

	return(v1);
	}

inline	oe_v4	oe_v4::operator	/	(const oe_scalar s)
	{
	oe_v4	v1;

	v1.m_Value[OE_X] = m_Value[OE_X] / s;
	v1.m_Value[OE_Y] = m_Value[OE_Y] / s;
	v1.m_Value[OE_Z] = m_Value[OE_Z] / s;
	v1.m_Value[OE_W] = m_Value[OE_W] / s;

	return(v1);
	}

inline	oe_v4&	oe_v4::operator	*=	(const oe_scalar s)
	{
	m_Value[OE_X] *= s;
	m_Value[OE_Y] *= s;
	m_Value[OE_Z] *= s;
	m_Value[OE_W] *= s;

	return(*this);
	}

inline	oe_v4&	oe_v4::operator	/=	(const oe_scalar s)
	{
	m_Value[OE_X] /= s;
	m_Value[OE_Y] /= s;
	m_Value[OE_Z] /= s;
	m_Value[OE_W] /= s;

	return(*this);
	}

/*
// standard right handed cross product
// leaves my data the same.
inline	oe_v4	oe_v4::Cross(const oe_v4& va, const oe_v4& vb)
	{
	oe_v4	v1;

	v1.m_Value[OE_X] = m_Value[OE_Y] * v.m_Value[OE_Z] - m_Value[OE_Z] * v.m_Value[OE_Y];
	v1.m_Value[OE_Y] = m_Value[OE_Z] * v.m_Value[OE_X] - m_Value[OE_X] * v.m_Value[OE_Z];
	v1.m_Value[OE_Z] = m_Value[OE_X] * v.m_Value[OE_Y] - m_Value[OE_Y] * v.m_Value[OE_X];

	return(v1);
	}

// standard right handed cross product
// in place. like *= or +=
inline	oe_v4&	oe_v4::CrossEq(const oe_v4& v)
	{
	oe_v4	v1;

	v1 = Cross(v);

	m_Value[OE_X]	= v1.m_Value[OE_X];
	m_Value[OE_Y]	= v1.m_Value[OE_Y];
	m_Value[OE_Z]	= v1.m_Value[OE_Z];

	return(*this);
	}
*/

inline	oe_v4	oe_v4::Normalized()
	{
	oe_v4	v1;
	oe_scalar	length;

	v1 = *this;
	length	= Length();
	if (length > 0.0)
		v1 /= length;

	return(v1);
	}

inline	oe_v4&	oe_v4::NormalizedEq()
	{
	oe_scalar	length;

	length = Length();

	if (length > 0.0)
		*this /= length;

	return(*this);
	}


inline	void		oe_v4::Plus		(oe_v4&		src,	oe_v4& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] + src.m_Value[OE_X];
	dst.m_Value[OE_Y]	= m_Value[OE_Y] + src.m_Value[OE_Y];
	dst.m_Value[OE_Z]	= m_Value[OE_Z] + src.m_Value[OE_Z];
	dst.m_Value[OE_W]	= m_Value[OE_W] + src.m_Value[OE_W];
	}

inline	void		oe_v4::Minus	(oe_v4&		src,	oe_v4& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] - src.m_Value[OE_X];
	dst.m_Value[OE_Y]	= m_Value[OE_Y] - src.m_Value[OE_Y];
	dst.m_Value[OE_Z]	= m_Value[OE_Z] - src.m_Value[OE_Z];
	dst.m_Value[OE_W]	= m_Value[OE_W] - src.m_Value[OE_W];
	}

inline	void		oe_v4::Mult		(oe_v4&		src,	oe_v4& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] * src.m_Value[OE_X];
	dst.m_Value[OE_Y]	= m_Value[OE_Y] * src.m_Value[OE_Y];
	dst.m_Value[OE_Z]	= m_Value[OE_Z] * src.m_Value[OE_Z];
	dst.m_Value[OE_W]	= m_Value[OE_W] * src.m_Value[OE_W];
	}

inline	void		oe_v4::Div		(oe_v4&		src,	oe_v4& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] / src.m_Value[OE_X];
	dst.m_Value[OE_Y]	= m_Value[OE_Y] / src.m_Value[OE_Y];
	dst.m_Value[OE_Z]	= m_Value[OE_Z] / src.m_Value[OE_Z];
	dst.m_Value[OE_W]	= m_Value[OE_W] / src.m_Value[OE_W];
	}

inline	void		oe_v4::Mult		(oe_scalar	src,	oe_v4& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] * src;
	dst.m_Value[OE_Y]	= m_Value[OE_Y] * src;
	dst.m_Value[OE_Z]	= m_Value[OE_Z] * src;
	dst.m_Value[OE_W]	= m_Value[OE_W] * src;
	}

inline	void		oe_v4::Div		(oe_scalar	src,	oe_v4& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] / src;
	dst.m_Value[OE_Y]	= m_Value[OE_Y] / src;
	dst.m_Value[OE_Z]	= m_Value[OE_Z] / src;
	dst.m_Value[OE_W]	= m_Value[OE_W] / src;
	}

inline	oe_scalar	oe_v4::Dot		(oe_v4&		src)
	{
	return	(
			m_Value[OE_X] * src.m_Value[OE_X] +
			m_Value[OE_Y] * src.m_Value[OE_Y] +
			m_Value[OE_Z] * src.m_Value[OE_Z] +
			m_Value[OE_Z] * src.m_Value[OE_W]
			);
	}

inline	oe_scalar	oe_v4::Length	()
	{
	return(oe_sqrt(Dot(*this)));
	}

inline	void		oe_v4::Norm		(oe_v4& dst)
	{
	oe_scalar	len;

	len	= Length();
	if (len != 0.0)
		Mult((oe_scalar)1.0/len, dst);
	}

/*
inline	void		oe_v4::Cross	(oe_v4&		src,	oe_v4& dst)
	{
	dst.m_Value[OE_X] = m_Value[OE_Y] * src.m_Value[OE_Z] - m_Value[OE_Z] * src.m_Value[OE_Y];
	dst.m_Value[OE_Y] = m_Value[OE_Z] * src.m_Value[OE_X] - m_Value[OE_X] * src.m_Value[OE_Z];
	dst.m_Value[OE_Z] = m_Value[OE_X] * src.m_Value[OE_Y] - m_Value[OE_Y] * src.m_Value[OE_X];
	}
*/


inline	void	oe_v4::RotX(oe_scalar theta, oe_v4& dst)
	{
	oe_scalar	s, c;
	oe_scalar	v[4];

	Get(v);
	
	s	=	oe_sin(theta) * OE_SQRT_1D2;
	c	=	oe_cos(theta);


	dst.m_Value[OE_X]	=	v[OE_X];
	dst.m_Value[OE_Y]	=				   v[OE_Y] *  c + v[OE_Z] * -s + v[OE_W] *  s;
	dst.m_Value[OE_Z]	=				   v[OE_Y] *  s + v[OE_Z] *  c + v[OE_W] * -s;
	dst.m_Value[OE_W]	=				   v[OE_Y] * -s + v[OE_Z] *  s + v[OE_W] *  c;
	}


inline	void	oe_v4::RotY(oe_scalar theta, oe_v4& dst)
	{
	oe_scalar	s, c;
	oe_scalar	v[4];

	Get(v);
	
//	s	=	oe_sin(theta) * OE_SQRT_1D2;
	s	=	oe_sin(theta) * 0.5f;
	c	=	oe_cos(theta);

	dst.m_Value[OE_X]	=	v[OE_X] *  c +                v[OE_Z] * -s + v[OE_W] *  s;
	dst.m_Value[OE_Y]	=                  v[OE_Y];
	dst.m_Value[OE_Z]	=	v[OE_X] *  s +                v[OE_Z] *  c + v[OE_W] * -s;
	dst.m_Value[OE_W]	=	v[OE_X] * -s +                v[OE_Z] *  s + v[OE_W] *  c;
	}

inline	void	oe_v4::RotZ(oe_scalar theta, oe_v4& dst)
	{
	oe_scalar	s, c;
	oe_scalar	v[4];

	Get(v);
	
	s	=	oe_sin(theta) * OE_SQRT_1D2;
	c	=	oe_cos(theta);

	dst.m_Value[OE_X]	=	v[OE_X] *  c + v[OE_Y] * -s +                v[OE_W] *  s;
	dst.m_Value[OE_Y]	=	v[OE_X] *  s + v[OE_Y] *  c +                v[OE_W] * -s;
	dst.m_Value[OE_Z]	=                                 v[OE_Z];
	dst.m_Value[OE_W]	=	v[OE_X] * -s + v[OE_Y] *  s +                v[OE_W] *  c;
	}

inline	void	oe_v4::RotW(oe_scalar theta, oe_v4& dst)
	{
	oe_scalar	s, c;
	oe_scalar	v[4];

	Get(v);
	
	s	=	oe_sin(theta) * OE_SQRT_1D2;
	c	=	oe_cos(theta);

	dst.m_Value[OE_X]	=	v[OE_X] *  c + v[OE_Y] * -s + v[OE_Z] *  s;
	dst.m_Value[OE_Y]	=	v[OE_X] *  s + v[OE_Y] *  c + v[OE_Z] * -s;
	dst.m_Value[OE_Z]	=	v[OE_X] * -s + v[OE_Y] *  s + v[OE_Z] *  c;
	dst.m_Value[OE_W]	=                                                v[OE_W];
	}


inline	void	oe_v4::RotWX(oe_scalar theta, oe_v4& dst)
	{
	RotWX(oe_sin(theta), oe_cos(theta), dst);
	}

inline	void	oe_v4::RotWY(oe_scalar theta, oe_v4& dst)
	{
	RotWY(oe_sin(theta), oe_cos(theta), dst);
	}

inline	void	oe_v4::RotWZ(oe_scalar theta, oe_v4& dst)
	{
	RotWZ(oe_sin(theta), oe_cos(theta), dst);
	}


inline	void	oe_v4::RotYX(oe_scalar theta, oe_v4& dst)
	{
	RotYX(oe_sin(theta), oe_cos(theta), dst);
	}

inline	void	oe_v4::RotZX(oe_scalar theta, oe_v4& dst)
	{
	RotZX(oe_sin(theta), oe_cos(theta), dst);
	}

inline	void	oe_v4::RotYZ(oe_scalar theta, oe_v4& dst)
	{
	RotYZ(oe_sin(theta), oe_cos(theta), dst);
	}

inline	void	oe_v4::RotWX(oe_scalar s, oe_scalar c, oe_v4& dst)
	{
	oe_scalar	tmp1, tmp2;

	tmp1	=	m_Value[OE_Y];
	tmp2	=	m_Value[OE_Z];

	dst.m_Value[OE_X]	=	m_Value[OE_X];
	dst.m_Value[OE_Y]	=				   tmp1    *  c + tmp2    *  s;
	dst.m_Value[OE_Z]	=				   tmp1    * -s + tmp2    *  c;
	dst.m_Value[OE_W]	=				                                 m_Value[OE_W];
	}

inline	void	oe_v4::RotWY(oe_scalar s, oe_scalar c, oe_v4& dst)
	{
	oe_scalar	tmp1, tmp2;

	tmp1	=	m_Value[OE_X];
	tmp2	=	m_Value[OE_Z];

	dst.m_Value[OE_X]	=	tmp1    *  c                + tmp2    * -s;
	dst.m_Value[OE_Y]	=				   m_Value[OE_Y];
	dst.m_Value[OE_Z]	=	tmp1    *  s                + tmp2    *  c;
	dst.m_Value[OE_W]	=				                                 m_Value[OE_W];
	}

inline	void	oe_v4::RotWZ(oe_scalar s, oe_scalar c, oe_v4& dst)
	{
	oe_scalar	tmp1, tmp2;

	tmp1	=	m_Value[OE_X];
	tmp2	=	m_Value[OE_Y];

	dst.m_Value[OE_X]	=	tmp1    *  c + tmp2    *  s;
	dst.m_Value[OE_Y]	=	tmp1    * -s + tmp2    *  c;
	dst.m_Value[OE_Z]	=	                              m_Value[OE_Z];
	dst.m_Value[OE_W]	=				                                 m_Value[OE_W];
	}


inline	void	oe_v4::RotYX(oe_scalar s, oe_scalar c, oe_v4& dst)
	{
	oe_scalar	tmp1, tmp2;

	tmp1	=	m_Value[OE_Z];
	tmp2	=	m_Value[OE_W];

	dst.m_Value[OE_X]	=	m_Value[OE_X];
	dst.m_Value[OE_Y]	=	               m_Value[OE_Y];
	dst.m_Value[OE_Z]	=	                              tmp1    *  c + tmp2    *  s;
	dst.m_Value[OE_W]	=	                              tmp1    * -s + tmp2    *  c;
	}

inline	void	oe_v4::RotZX(oe_scalar s, oe_scalar c, oe_v4& dst)
	{
	oe_scalar	tmp1, tmp2;

	tmp1	=	m_Value[OE_Y];
	tmp2	=	m_Value[OE_W];

	dst.m_Value[OE_X]	=	m_Value[OE_X];
	dst.m_Value[OE_Y]	=	               tmp1    *  c                + tmp2    * -s;
	dst.m_Value[OE_Z]	=	                              m_Value[OE_Z];
	dst.m_Value[OE_W]	=	               tmp1    *  s                + tmp2    *  c;
	}

inline	void	oe_v4::RotYZ(oe_scalar s, oe_scalar c, oe_v4& dst)
	{
	oe_scalar	tmp1, tmp2;

	tmp1	=	m_Value[OE_X];
	tmp2	=	m_Value[OE_W];

	dst.m_Value[OE_X]	=	tmp1    *  c                               + tmp2    * -s;
	dst.m_Value[OE_Y]	=	               m_Value[OE_Y];
	dst.m_Value[OE_Z]	=	                              m_Value[OE_Z];
	dst.m_Value[OE_W]	=	tmp1    *  s                               + tmp2    *  c;
	}


//
//
// vector class above
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
// matrix classes below
// matrix classes above
///////////////////////////////////////////////////////////////////////////////////////


#endif	//	_OE_V4_H_

/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/




