/*

oe_v2.h

Simple Vector Class
by orion elenzil

*/


#ifndef	_OE_V2_H_
#define	_OE_V2_H_

#include "oe_v3.h"		// for precision etc

class	oe_v2
	{
    public:

    oe_scalar	m_Value[2];

	public:
						oe_v2		(								);
						oe_v2		(oe_scalar	x, oe_scalar y		);
						oe_v2		(oe_scalar	s					);
    void	  			Set	 		(oe_scalar	x, oe_scalar y		);
    void	  			Set	 		(oe_scalar	s					);

	// convenient operators
	oe_v2&	operator	=			(const  oe_v2&		v			);

	oe_v2	operator	+			(const	oe_v2&		v			);
	oe_v2	operator	-			(const	oe_v2&		v			);
	oe_v2	operator	*			(const	oe_v2&		v			);
	oe_v2	operator	/			(const	oe_v2&		v			);

	oe_v2&	operator	-=			(const	oe_v2&		v			);
	oe_v2&	operator	+=			(const	oe_v2&		v			);
	oe_v2&	operator	*=			(const	oe_v2&		v			);
	oe_v2&	operator	/=			(const	oe_v2&		v			);

	oe_v2	operator	*			(		oe_scalar	s			);
	oe_v2	operator	/			(		oe_scalar	s			);
	oe_v2&	operator	*=			(		oe_scalar	s			);
	oe_v2&	operator	/=			(		oe_scalar	s			);

	void				Plus		(oe_v2&		src,	oe_v2& dst	);
	void				Minus		(oe_v2&		src,	oe_v2& dst	);
	void				Mult		(oe_v2&		src,	oe_v2& dst	);
	void				Div			(oe_v2&		src,	oe_v2& dst	);
	void				Mult		(oe_scalar	src,	oe_v2& dst	);
	void				Div			(oe_scalar	src,	oe_v2& dst	);
	oe_scalar			Dot			(oe_v2&		src					);
	oe_scalar			Length		(								);
	void				Norm		(								);
	void				Norm		(					oe_v2& dst	);
	void				Norm		(oe_scalar	src					);
	void				Norm		(oe_scalar	src,	oe_v2& dst	);
	void				Rot			(oe_scalar	theta,	oe_v2& dst	);
	void				Perp		(					oe_v2& dst	);
	void				Rot90		(					oe_v2& dst	);
	void				RotMinus90	(					oe_v2& dst	);
	};

inline oe_v2::oe_v2()
	{
	}

inline oe_v2::oe_v2(oe_scalar x, oe_scalar y)
	{
	Set(x, y);
	}

inline oe_v2::oe_v2(oe_scalar s)
	{
	Set(s);
	}

inline void	oe_v2::Set(oe_scalar x, oe_scalar y)
	{
	m_Value[0]	=	x;
	m_Value[1]	=	y;
	}

inline void	oe_v2::Set(oe_scalar s)
	{
	m_Value[0]	=	s;
	m_Value[1]	=	s;
	}

inline    oe_v2	oe_v2::operator	+	(const oe_v2& v)
	{
    oe_v2	v1;

    v1.m_Value[OE_X] = v.m_Value[OE_X] + m_Value[OE_X];
    v1.m_Value[OE_Y] = v.m_Value[OE_Y] + m_Value[OE_Y];

    return(v1);
    }

inline    oe_v2	oe_v2::operator	-	(const oe_v2& v)
	{
    oe_v2	v1;

    v1.m_Value[OE_X] = m_Value[OE_X] - v.m_Value[OE_X];
    v1.m_Value[OE_Y] = m_Value[OE_Y] - v.m_Value[OE_Y];

    return(v1);
    }

// This is a component-wise multiplication,
// which isn't normally a standard vector operation,
// but i have wanted it from time to time.
// THIS IS NOT DOT PRODUCT !!
inline    oe_v2	oe_v2::operator	*	(const oe_v2& v)
	{
    oe_v2	v1;

    v1.m_Value[OE_X] = v.m_Value[OE_X] * m_Value[OE_X];
    v1.m_Value[OE_Y] = v.m_Value[OE_Y] * m_Value[OE_Y];

    return(v1);
    }

// This is a component-wise division,
// which isn't normally a standard vector operation,
// but i have wanted it from time to time.
inline    oe_v2	oe_v2::operator	/	(const oe_v2& v)
	{
    oe_v2	v1;

    v1.m_Value[OE_X] = m_Value[OE_X] / v.m_Value[OE_X];
    v1.m_Value[OE_Y] = m_Value[OE_Y] / v.m_Value[OE_Y];

    return(v1);
    }

inline    oe_v2&	oe_v2::operator	=	(const oe_v2& v)
	{
    m_Value[OE_X] = v.m_Value[OE_X];
    m_Value[OE_Y] = v.m_Value[OE_Y];

    return(*this);
    }

inline    oe_v2&	oe_v2::operator	+=	(const oe_v2& v)
	{
    m_Value[OE_X] += v.m_Value[OE_X];
    m_Value[OE_Y] += v.m_Value[OE_Y];

    return(*this);
    }

inline    oe_v2&	oe_v2::operator	-=	(const oe_v2& v)
	{
    m_Value[OE_X] -= v.m_Value[OE_X];
    m_Value[OE_Y] -= v.m_Value[OE_Y];

    return(*this);
    }

// This is a component-wise multiplication,
// which isn't normally a standard vector operation,
// but i have wanted it from time to time.
// THIS IS NOT DOT PRODUCT !!
inline    oe_v2&	oe_v2::operator	*=	(const oe_v2& v)
	{
    m_Value[OE_X] *= v.m_Value[OE_X];
    m_Value[OE_Y] *= v.m_Value[OE_Y];

    return(*this);
    }

// This is a component-wise division,
// which isn't normally a standard vector operation,
// but i have wanted it from time to time.
inline    oe_v2&	oe_v2::operator	/=	(const oe_v2& v)
	{
    m_Value[OE_X] /= v.m_Value[OE_X];
    m_Value[OE_Y] /= v.m_Value[OE_Y];

    return(*this);
    }

inline    oe_v2	oe_v2::operator	*	(const oe_scalar s)
	{
    oe_v2	v1;

    v1.m_Value[OE_X] = m_Value[OE_X] * s;
    v1.m_Value[OE_Y] = m_Value[OE_Y] * s;

	return(v1);
    }

inline    oe_v2	oe_v2::operator	/	(const oe_scalar s)
	{
    oe_v2	v1;

    v1.m_Value[OE_X] = m_Value[OE_X] / s;
    v1.m_Value[OE_Y] = m_Value[OE_Y] / s;

    return(v1);
    }

inline    oe_v2&	oe_v2::operator	*=	(const oe_scalar s)
	{
    m_Value[OE_X] *= s;
    m_Value[OE_Y] *= s;

    return(*this);
    }

inline    oe_v2&	oe_v2::operator	/=	(const oe_scalar s)
	{
    m_Value[OE_X] /= s;
    m_Value[OE_Y] /= s;

    return(*this);
    }



inline	void		oe_v2::Plus		(oe_v2&		src,	oe_v2& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] + src.m_Value[OE_X];
	dst.m_Value[OE_Y]	= m_Value[OE_Y] + src.m_Value[OE_Y];
	}

inline	void		oe_v2::Minus	(oe_v2&		src,	oe_v2& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] - src.m_Value[OE_X];
	dst.m_Value[OE_Y]	= m_Value[OE_Y] - src.m_Value[OE_Y];
	}


inline	void		oe_v2::Mult		(oe_v2&		src,	oe_v2& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] * src.m_Value[OE_X];
	dst.m_Value[OE_Y]	= m_Value[OE_Y] * src.m_Value[OE_Y];
	}


inline	void		oe_v2::Div		(oe_v2&		src,	oe_v2& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] / src.m_Value[OE_X];
	dst.m_Value[OE_Y]	= m_Value[OE_Y] / src.m_Value[OE_Y];
	}


inline	void		oe_v2::Mult		(oe_scalar	src,	oe_v2& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] * src;
	dst.m_Value[OE_Y]	= m_Value[OE_Y] * src;
	}

inline	void		oe_v2::Div		(oe_scalar	src,	oe_v2& dst)
	{
	dst.m_Value[OE_X]	= m_Value[OE_X] / src;
	dst.m_Value[OE_Y]	= m_Value[OE_Y] / src;
	}

inline	oe_scalar	oe_v2::Dot	(oe_v2&		src)
	{
	return	(
			m_Value[OE_X] * src.m_Value[OE_X] +
			m_Value[OE_Y] * src.m_Value[OE_Y]
			);
	}


inline	oe_scalar	oe_v2::Length	()
	{
	return(oe_sqrt(Dot(*this)));
	}

inline	void		oe_v2::Norm		()
	{
	Norm(1.0f);
	}

inline	void		oe_v2::Norm		(					oe_v2& dst)
	{
	Norm(1.0f, dst);
	}

inline	void		oe_v2::Norm		(oe_scalar src)
	{
	Norm(src, *this);
	}

inline	void		oe_v2::Norm		(oe_scalar src,		oe_v2& dst)
	{
	oe_scalar	len;

	len	= Length();
	if (len != 0.0)
		Mult(src/len, dst);
	}

inline	void		oe_v2::Perp		(					oe_v2& dst)
	{
	Rot90(dst);
	}

inline	void		oe_v2::Rot90	(					oe_v2& dst)
	{
	oe_scalar	tmp;
	tmp	=	m_Value[0];
	dst.m_Value[0]	=	-m_Value[1];
	dst.m_Value[1]	=	 tmp;
	}

inline	void		oe_v2::RotMinus90(					oe_v2& dst)
	{
	oe_scalar	tmp;
	tmp	=	m_Value[0];
	dst.m_Value[0]	=	 m_Value[1];
	dst.m_Value[1]	=	-tmp;
	}

inline	void	oe_v2::Rot(oe_scalar theta, oe_v2& dst)
	{
	oe_scalar	s, c;
	
	s	=	oe_sin(theta);
	c	=	oe_cos(theta);

	oe_scalar	tmp;

	tmp	=	m_Value[0];

	dst.m_Value[0]	=	tmp			* c	- m_Value[1]	* s;
	dst.m_Value[1]	=	m_Value[1]	* c	+ tmp			* s;
	}


/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////

static oe_v2 SUPERTMPVARIABLE_OE_V2;
static oe_v3 SUPERTMPVARIABLE_OE_V3;

static oe_v2& v3_to_v2(oe_v3& v)
	{
	SUPERTMPVARIABLE_OE_V2.Set(v.m_Value[0], v.m_Value[1]);

	return SUPERTMPVARIABLE_OE_V2;
	}

static oe_v3& v2_to_v3(oe_v2& v)
	{
	SUPERTMPVARIABLE_OE_V3.Set(v.m_Value[0], v.m_Value[1], 0.0f);

	return SUPERTMPVARIABLE_OE_V3;
	}

#endif	//	_OE_V2_H_

/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/




