/*

  oe_timer.cpp

  Simple Timer Class.

  */

#include "OSHeader.h"
#include "oe_Timer.h"

#if	OS_BUILD == OS_WIN32
// Windows 95 / 98 / NT Implementation
// Requires kernel32.lib
#include <windows.h>
//#include <winbase.h>
	
#endif

#if	OS_BUILD == OS_IRIX

#include <sys/time.h>

#endif


#if	OS_BUILD == OS_LINUX

//#include <sys/time.h>

#endif

#if	OS_BUILD == OS_WIN32

double oe_timer ::	SystemSeconds()
	{
	return(((double)GetTickCount()) * 0.001);
	}

#endif

#if	OS_BUILD == OS_IRIX

double	oe_timer :: SystemSeconds()
	{
	gettimeofday(&m_TimeInfo);
	return ((double)m_TimeInfo.tv_sec + (double)m_TimeInfo.tv_usec/100000.0);

	}
#endif
	
#if	OS_BUILD == OS_MACOS

double oe_timer ::	SystemSeconds()
	{
	//gettimeofday(&m_TimeInfo);
//	return ((double)m_TimeInfo.tv_usec/100000.0);
	return 0;

	}
#endif


#if	OS_BUILD == OS_LINUX

double oe_timer ::	SystemSeconds()
	{
	//gettimeofday(&m_TimeInfo);
//	return ((double)m_TimeInfo.tv_usec/100000.0);
	return 0;

	}
#endif
oe_timer ::	oe_timer()
{
	m_Mode			= HT_REALTIME;
	m_SecondsStep	= 1.0 / 30.0;	// default Hz
	SetSeconds(0.0);
	m_MostRecentTimeStep = 0;
}



void	oe_timer ::	SetSeconds(oe_scalar seconds)
{
	m_SystemSecondsCurrent	= SystemSeconds();
	m_SystemSecondsStart	= m_SystemSecondsCurrent - (double)seconds;
	m_SecondsCurrent		= (double)seconds;
	m_MostRecentTimeStep = 0;
}


void	oe_timer ::	Pulse()
{
	if (m_Mode == HT_REALTIME)
		m_SystemSecondsCurrent	=	SystemSeconds();
	else if (m_Mode == HT_STEPTIME)
		m_SystemSecondsCurrent	+=	m_SecondsStep;

	double prevSecondsCurrent = m_SecondsCurrent;

	m_SecondsCurrent = m_SystemSecondsCurrent - m_SystemSecondsStart;

	m_MostRecentTimeStep = m_SecondsCurrent - prevSecondsCurrent;

}
