/*

  OSHeader.h

  Able to be #included in all source files,
  with minimal impact.

  Defines a few operating systems,
  conditionally includes one more file for the
  particular OS we are in.

  Sadly, VC++ (pc) has trouble playing nicely,
  and StdAfx.h must be directly included in
  each source file.
  So there is some repetition, as every
  source file now includes stdafx,
  and every file includes this file,
  and this file includes stdafx,
  but the "only include once" features
  should take care of it.
  
*/


#ifndef HAPOSHEADER_H
#define HAPOSHEADER_H

// Some constants
#define	OS_UNKNOWN	0
#define	OS_WIN32	1
#define	OS_MACOS	2
#define	OS_IRIX		3
#define	OS_LINUX	4

// What OS are we compiling on right now ?
#define	OS_BUILD	OS_WIN32

#define GLUTENABLED	0
#define PLAYSTATION2	0

#include "generic_os.h"

#if OS_BUILD == OS_WIN32
#include <windows.h>
#endif


#endif
