/*


  */


#include "dxod3dx.h"
#include "dxo_4d.h"

void InterpretError(HRESULT hr)
{
    char errStr[256];

    if(D3DXERR_NODIRECT3DDEVICEAVAILABLE  == hr) 
    {
        strcpy(errStr, "D3DXERR_NODIRECT3DDEVICEAVAILABLE\n\n"
                       "No suitable 3D device found.  "
                       "Try enabling the reference rasterizer.");
    }
    else
    {
        D3DXGetErrorString(hr, 256, errStr);
    }

    if (0) {
		MessageBox(NULL, errStr, "D3DX Error", MB_OK);
		}

} // InterpretError


#define	RETURNHRERROR(hr) m_LastResult = hr; if (FAILED(m_LastResult)){InterpretError(m_LastResult);return m_LastResult;}
#define RELEASENULL(object) if (object) {object->Release();}


dxo_d3dx::dxo_d3dx()
	{
	m_bD3DXReady	=	FALSE;
	m_pD3DDev		=	NULL;
	m_pD3DX			=	NULL;
	m_pDD			=	FALSE;
	m_InScene		=	FALSE;
	m_pStack		=	NULL;
	m_WindowWidth	=	0;
	m_WindowHeight	=	0;
	m_hWnd			=	0;


	D3DXCreateMatrixStack(0, &m_pStack); 
	}

dxo_d3dx::~dxo_d3dx()
	{
	ReleaseD3DX();
	if (m_pStack)
		m_pStack	->	Release();
	}

HRESULT dxo_d3dx::InitD3DX(HWND hwnd)
{
    RETURNHRERROR(D3DXInitialize());

    RETURNHRERROR(D3DXCreateContext(	D3DX_DEFAULT,	// D3DX handle
										0,				// flags
										hwnd,
										D3DX_DEFAULT,	// colorbits
										D3DX_DEFAULT,	// numdepthbits
										&m_pD3DX		// returned D3DX interface
										));

    m_bD3DXReady	=	TRUE;
	m_hWnd			=	hwnd;

    return InitRenderer();
}

HRESULT	dxo_d3dx::ReleaseD3DX()
{
	RELEASENULL			(m_pDD		);
	RELEASENULL			(m_pD3DDev	);
	RELEASENULL			(m_pD3DX	);
	
	m_bD3DXReady	=	FALSE;
	
	D3DXUninitialize	();

	return S_OK;
}

HRESULT dxo_d3dx::InitRenderer()
{
	if( !m_bD3DXReady )
		return E_FAIL;

	m_pD3DDev = m_pD3DX->GetD3DDevice();
	if( m_pD3DDev == NULL )
		return E_FAIL;

	m_pDD = m_pD3DX->GetDD();
	if( m_pDD == NULL )
		return E_FAIL;

	RETURNHRERROR(m_pD3DDev	-> SetRenderState	(D3DRENDERSTATE_DITHERENABLE, TRUE							));
	RETURNHRERROR(m_pD3DDev	-> SetRenderState	(D3DRENDERSTATE_CULLMODE	, D3DCULL_NONE					));
//	RETURNHRERROR(m_pD3DDev	-> SetRenderState	(D3DRENDERSTATE_CULLMODE	, D3DCULL_CCW					));
	RETURNHRERROR(m_pD3DDev	-> SetRenderState	(D3DRENDERSTATE_FILLMODE	, D3DFILL_SOLID					));
//	RETURNHRERROR(m_pD3DDev	-> SetRenderState	(D3DRENDERSTATE_FILLMODE	, D3DFILL_WIREFRAME				));
//	RETURNHRERROR(m_pD3DDev	-> SetRenderState	(D3DRENDERSTATE_FILLMODE	, D3DFILL_POINT					));
//	RETURNHRERROR(m_pD3DDev	-> SetRenderState	(D3DRENDERSTATE_ANTIALIAS	, D3DANTIALIAS_SORTINDEPENDENT 	));
//	RETURNHRERROR(m_pD3DDev	-> SetRenderState	(D3DRENDERSTATE_ANTIALIAS	, D3DANTIALIAS_SORTDEPENDENT 	));
	RETURNHRERROR(m_pD3DX	-> SetClearColor	(D3DRGBA(0.3f,0.3f,0.4f,0)									));
	RETURNHRERROR(m_pD3DX	-> Clear			(D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER							));

	
	D3DXMATRIX	mat;
	D3DXMatrixPerspectiveFovLH(&mat, (float)OE_DEG_TO_RAD * 45.0f, 1.0f, 10.0f, 30.0f);
	m_pD3DDev	->	SetTransform(D3DTRANSFORMSTATE_PROJECTION	, (D3DMATRIX *)&mat);
	

	UpdateFrame();


    return S_OK;
}


HRESULT dxo_d3dx::HandleWindowedModeChanges()
{
HRESULT hr;
	hr = m_pDD->TestCooperativeLevel();

	if( SUCCEEDED( hr ) )
		{
		// This means that mode changes had taken place, surfaces
		// were lost but still we are in the original mode, so we
		// simply restore all surfaces and keep going.
		if( FAILED( m_pDD->RestoreAllSurfaces() ) )
			return hr;
		}
	else if( hr == DDERR_WRONGMODE )
		{
		// This means that the desktop mode has changed
		// we can destroy and recreate everything back again.
		if(FAILED(hr = ReleaseD3DX()))
			return hr;
		if(FAILED(hr = InitD3DX(m_hWnd)))
		return hr;
		}
	else if( hr == DDERR_EXCLUSIVEMODEALREADYSET )
		{
		// This means that some app took exclusive mode access
		// we need to sit in a loop till we get back to the right mode.
		do
			{
			Sleep( 500 );
			} while( DDERR_EXCLUSIVEMODEALREADYSET == (hr = m_pDD->TestCooperativeLevel()) );
		if( SUCCEEDED( hr ) )
			{
			// This means that the exclusive mode app relinquished its 
			// control and we are back to the safe mode, so simply restore
			if( FAILED( m_pDD->RestoreAllSurfaces() ) )
				return hr;
			}
		else if( DDERR_WRONGMODE == hr )
			{
			// This means that the exclusive mode app relinquished its 
			// control BUT we are back to some strange mode, so destroy
			// and recreate.
			if(FAILED(hr = ReleaseD3DX()))
				return hr;
			if(FAILED(hr = InitD3DX(m_hWnd)))
				return hr;
			}
		else
			{
			// Busted!!
			return hr;
			}
		}
	else
		{
		// Busted!!
		return hr;
		}

	return S_OK;
}


void dxo_d3dx::UpdateFrame()
	{
	HRESULT hr;

    hr	=	m_pD3DX	->	UpdateFrame( 0 );
	
	CheckWindow();

    if ( hr == DDERR_SURFACELOST || hr == DDERR_SURFACEBUSY )
        hr = HandleWindowedModeChanges();

	}

HRESULT dxo_d3dx::Draw_dxo_4d_obj(dxo_4d_obj* obj)
	{
	if (!obj || !m_InScene)
		return E_FAIL;

	obj -> Untouch();

	int	flag;

	flag	=	0;
	flag	|=	D3DFVF_XYZ		;
	flag	|=	D3DFVF_NORMAL	;

	if (obj -> m_FillStyle == OE_FILL_SOLID) {
		RETURNHRERROR(	m_pD3DDev -> DrawIndexedPrimitive(
						D3DPT_TRIANGLELIST,
						flag,
						obj			->	m_d3dVecs,
						obj			->	m_VrtsNum,
						obj			->	m_Tris,
						obj			->	m_TrisNum * 3,
						0));
		}
	else if (obj -> m_FillStyle == OE_FILL_LINE) {
		RETURNHRERROR(	m_pD3DDev -> DrawIndexedPrimitive(
						D3DPT_LINELIST,
						flag,
						obj			->	m_d3dVecs,
						obj			->	m_VrtsNum,
						obj			->	m_Lins,
						obj			->	m_LinsNum * 2,
						0));
		}

	return S_OK;
	}

HRESULT dxo_d3dx::SceneBegin()
	{
	if( !m_bD3DXReady )
		return E_FAIL;

	RETURNHRERROR(m_pD3DDev->BeginScene());

	static	oe_scalar	t;
	t += .02f;
	m_pD3DX		->	SetClearColor	(D3DRGBA(1,1,1,1));
	m_pD3DX		->	Clear(D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER);

	m_pStack	->	LoadIdentity();
	m_pD3DDev	->	SetTransform(D3DTRANSFORMSTATE_WORLD		, (D3DMATRIX *)m_pStack -> GetTop());

	D3DXVECTOR3	v;
	v.z =	(D3DVALUE) 0.0f;
	v.y	=	(D3DVALUE) oe_sin(t*0.2f);
	v.x	=	(D3DVALUE) oe_cos(t*0.2f);

//	m_pStack	->	RotateAxis	(&v, (D3DVALUE) t*3.0f);
	m_pStack	->	Scale		(7.0f, 7.0f, 7.0f);
	m_pStack	->	Translate	(0.0f, 0.0f, 18.0f);
	m_pD3DDev	->	SetTransform(D3DTRANSFORMSTATE_WORLD		, (D3DMATRIX *)m_pStack -> GetTop());

	m_InScene	=	TRUE;

	return S_OK;
	}

void dxo_d3dx::SceneEnd()
	{
	m_InScene	=	FALSE;
	m_pD3DDev	->	EndScene		();
	UpdateFrame						();
	}

void	dxo_d3dx::CheckWindow()
	{
	if (!m_hWnd)
		return;

	RECT	r;
	long	w, h;

	GetWindowRect(m_hWnd, &r);
	w	=	r.right		-	r.left;
	h	=	r.bottom	-	r.top;
	
	if (w != m_WindowWidth || h != m_WindowHeight) {
		m_pD3DX -> Resize(w, h);
		m_WindowWidth	=	w;
		m_WindowHeight	=	h;
		}
	}

/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
