/*


  */



#ifndef	_DXO_4D_H_
#define	_DXO_4D_H_

#include "oe_v4.h"
#include "dxod3dx.h"

#define	OE_FILL_POINT		1
#define	OE_FILL_LINE		2
#define	OE_FILL_SOLID		3

// These are different ways to convert a filled object into a wireframe.
// 1, 2, & 3 refer to the sides of a triangle.
// OE_CONVERT_1 only converts the first sides to lines,
// OE_CONVERT_123 converts all three sides to lines.
#define OE_CONVERT_1		1
#define OE_CONVERT_2		2
#define OE_CONVERT_3		4
#define OE_CONVERT_12		OE_CONVERT_1 | OE_CONVERT_2
#define OE_CONVERT_23		OE_CONVERT_2 | OE_CONVERT_3
#define OE_CONVERT_13		OE_CONVERT_1 | OE_CONVERT_3
#define OE_CONVERT_123		OE_CONVERT_1 | OE_CONVERT_2 | OE_CONVERT_3

#ifndef NULL
#define	NULL	0
#endif

typedef struct OE_D3DX_COLORVERTEX
	{
	D3DVECTOR	v;
	DWORD		c;
	} oe_d3dx_colorvertex;

typedef struct OE_D3DX_VERTEX_POSNRM
	{
	D3DVECTOR	v;
	D3DVECTOR	n;
	} oe_d3dx_vertex_posnrm;

class	dxo_4d_obj
	{
	public:

	oe_v4*			m_Vrts;
	oe_v4*			m_Nrms;
	long			m_VrtsNum;
//	long			m_NrmsNum	==	m_VrtsNum
	unsigned short*	m_Tris;
	long			m_TrisNum;
	unsigned short* m_Lins;
	long			m_LinsNum;

	int				m_FillStyle;
	int				m_ConvertStyle;

	BOOL	m_Touched;
	BOOL	m_ConvertTouched;

			dxo_4d_obj	();
	~		dxo_4d_obj	();

	void	SetVrtsNum	(long n);
	void	SetTrisNum	(long n);

	void	MakeCube	(BOOL cube1 = TRUE, BOOL cube2 = TRUE, BOOL verticals = TRUE, BOOL horizontals = TRUE, BOOL depths = TRUE, BOOL zonks = TRUE, BOOL reset = FALSE);
	void	MakeD3D		();

	void	Touch		()		{ m_Touched			= TRUE;							}
	void	ConvertTouch()		{ m_ConvertTouched	= TRUE;							}
	void	Untouch		();
	BOOL	Touched		()		{ return m_Touched;									}

	void	Rot			(int which, oe_scalar theta, dxo_4d_obj* dst = NULL);
	void	SetFillType	(int style, int conversion = OE_CONVERT_1);
	void	Convert		(int conversion = OE_CONVERT_1);


//////////////////////////////////////
// d3dx stuff


	void*	m_d3dVecs;

	
// d3dx stuff
//////////////////////////////////////


	};


#endif	//	_DXO_4D_H_


