/*


  */


#include "dxo_4d.h"


dxo_4d_obj::dxo_4d_obj()
	{
	m_Vrts			=	NULL;
	m_Nrms			=	NULL;
	m_VrtsNum		=	0;
	m_Tris			=	NULL;
	m_TrisNum		=	0;
	m_Lins			=	NULL;
	m_LinsNum		=	0;

	m_d3dVecs		=	NULL;
	m_FillStyle		=	OE_FILL_SOLID;
	m_ConvertStyle	=	OE_CONVERT_1;

	Touch();
	}


dxo_4d_obj::~dxo_4d_obj()
	{
	SetVrtsNum	(0);
	SetTrisNum	(0);
	}

void	dxo_4d_obj::SetVrtsNum(long n)
	{
	if (m_Vrts) {
		delete [] m_Vrts;
		m_Vrts = NULL;
		}

	if (m_Nrms) {
		delete [] m_Nrms;
		m_Nrms = NULL;
		}

	if (m_d3dVecs) {
		delete [] m_d3dVecs;
		m_d3dVecs = NULL;
		}

	m_VrtsNum	=	0;

	if (n > 0) {
		m_Vrts		=	new oe_v4					[n];
		m_Nrms		=	new oe_v4					[n];
		m_d3dVecs	=	new oe_d3dx_vertex_posnrm	[n];
		m_VrtsNum	=	n;
		}

	Touch();
	}

void	dxo_4d_obj::SetTrisNum(long n)
	{
	if (m_Tris) {
		delete [] m_Tris;
		m_Tris	=	NULL;
		}
	m_TrisNum	=	0;

	if (m_Lins) {
		delete [] m_Lins;
		m_Lins	=	NULL;
		}
	m_LinsNum	=	0;

	if (n > 0) {
		m_Tris		=	new unsigned short[n * 3];
		m_TrisNum	=	n;
		m_Lins		=	new unsigned short[n * 6];
		m_LinsNum	=	0;
		}

	Touch			();
	ConvertTouch	();
	}

void	dxo_4d_obj::MakeD3D()
	{
	long					i;

	int						mode;
	oe_scalar				w;
	oe_scalar*				v;
	oe_scalar*				n;

	oe_d3dx_vertex_posnrm*	pv;

	pv		=	(oe_d3dx_vertex_posnrm*)m_d3dVecs;

	mode	=	0;

	if (mode == 0) {
		for (i = 0; i < m_VrtsNum; i++) {
			v = m_Vrts[i].m_Value;
			n = m_Nrms[i].m_Value;
			pv[i].v.x	=	(D3DVALUE)v[OE_X];
			pv[i].v.y	=	(D3DVALUE)v[OE_Y];
			pv[i].v.z	=	(D3DVALUE)v[OE_Z];
			pv[i].n.x	=	(D3DVALUE)n[OE_X];
			pv[i].n.y	=	(D3DVALUE)n[OE_Y];
			pv[i].n.z	=	(D3DVALUE)n[OE_Z];
			}
		}
	else if (mode == 1) {
		for (i = 0; i < m_VrtsNum; i++) {
			v = m_Vrts[i].m_Value;
			w = v[OE_W];
			pv[i].v.x	=	(D3DVALUE)(v[OE_X] + w);
			pv[i].v.y	=	(D3DVALUE)(v[OE_Y] + w);
			pv[i].v.z	=	(D3DVALUE)(v[OE_Z] + w);
			}
		}
	}

void	dxo_4d_obj::MakeCube(BOOL cube1, BOOL cube2, BOOL verticals, BOOL horizontals, BOOL depths, BOOL zonks, BOOL reset)
	{
	oe_scalar	a, b, c, d;
//	BOOL		cube1, cube2, verticals, horizontals, depths;

	int			i;

	if (reset) {
		SetVrtsNum	(16);

		a	=	-0.5f;
		b	=	 0.5f;
		c	=	-0.5f;
		d	=	 0.5f;

		i = 0;

		m_Vrts[i++]	.	Set(a, a, a, c);
		m_Vrts[i++]	.	Set(b, a, a, c);
		m_Vrts[i++]	.	Set(a, b, a, c);
		m_Vrts[i++]	.	Set(b, b, a, c);
		m_Vrts[i++]	.	Set(a, a, b, c);
		m_Vrts[i++]	.	Set(b, a, b, c);
		m_Vrts[i++]	.	Set(a, b, b, c);
		m_Vrts[i++]	.	Set(b, b, b, c);

		m_Vrts[i++]	.	Set(a, a, a, d);
		m_Vrts[i++]	.	Set(b, a, a, d);
		m_Vrts[i++]	.	Set(a, b, a, d);
		m_Vrts[i++]	.	Set(b, b, a, d);
		m_Vrts[i++]	.	Set(a, a, b, d);
		m_Vrts[i++]	.	Set(b, a, b, d);
		m_Vrts[i++]	.	Set(a, b, b, d);
		m_Vrts[i++]	.	Set(b, b, b, d);
		}

	for (i = 0; i < m_VrtsNum; i++) {
		m_Vrts[i].Norm(m_Nrms[i]);
		}

	i = 0;

	if(cube1)
		i += 12;
	if(cube2)
		i += 12;
	if(verticals)
		i += 8;
	if(horizontals)
		i += 8;
	if(depths)
		i += 8;
	if(zonks)
		i += 8;

	SetTrisNum	(i);

	i	=	0;
	
	if (cube1) {

		// bottom
		m_Tris[i++]	=	4;
		m_Tris[i++]	=	0;
		m_Tris[i++]	=	1;
	
		m_Tris[i++]	=	1;
		m_Tris[i++]	=	5;
		m_Tris[i++]	=	4;
	
		// back
		m_Tris[i++]	=	1;
		m_Tris[i++]	=	0;
		m_Tris[i++]	=	2;
	
		m_Tris[i++]	=	2;
		m_Tris[i++]	=	3;
		m_Tris[i++]	=	1;
	
		// left
		m_Tris[i++]	=	2;
		m_Tris[i++]	=	0;
		m_Tris[i++]	=	4;
	
		m_Tris[i++]	=	4;
		m_Tris[i++]	=	6;
		m_Tris[i++]	=	2;
	
		// top
		m_Tris[i++]	=	2;
		m_Tris[i++]	=	6;
		m_Tris[i++]	=	7;
	
		m_Tris[i++]	=	7;
		m_Tris[i++]	=	3;
		m_Tris[i++]	=	2;
	
		// front
		m_Tris[i++]	=	4;
		m_Tris[i++]	=	5;
		m_Tris[i++]	=	7;
	
		m_Tris[i++]	=	7;
		m_Tris[i++]	=	6;
		m_Tris[i++]	=	4;
	
		// right
		m_Tris[i++]	=	7;
		m_Tris[i++]	=	5;
		m_Tris[i++]	=	1;
	
		m_Tris[i++]	=	1;
		m_Tris[i++]	=	3;
		m_Tris[i++]	=	7;
		}

	if (cube2) {

		// bottom
		m_Tris[i++]	=	1 + 8;
		m_Tris[i++]	=	0 + 8;
		m_Tris[i++]	=	4 + 8;
	
		m_Tris[i++]	=	4 + 8;
		m_Tris[i++]	=	5 + 8;
		m_Tris[i++]	=	1 + 8;
	
		// back
		m_Tris[i++]	=	2 + 8;
		m_Tris[i++]	=	0 + 8;
		m_Tris[i++]	=	1 + 8;
	
		m_Tris[i++]	=	1 + 8;
		m_Tris[i++]	=	3 + 8;
		m_Tris[i++]	=	2 + 8;
	
		// left
		m_Tris[i++]	=	4 + 8;
		m_Tris[i++]	=	0 + 8;
		m_Tris[i++]	=	2 + 8;
	
		m_Tris[i++]	=	2 + 8;
		m_Tris[i++]	=	6 + 8;
		m_Tris[i++]	=	4 + 8;
	
		// top
		m_Tris[i++]	=	7 + 8;
		m_Tris[i++]	=	6 + 8;
		m_Tris[i++]	=	2 + 8;
	
		m_Tris[i++]	=	2 + 8;
		m_Tris[i++]	=	3 + 8;
		m_Tris[i++]	=	7 + 8;
	
		// front
		m_Tris[i++]	=	7 + 8;
		m_Tris[i++]	=	5 + 8;
		m_Tris[i++]	=	4 + 8;
	
		m_Tris[i++]	=	4 + 8;
		m_Tris[i++]	=	6 + 8;
		m_Tris[i++]	=	7 + 8;
	
		// right
		m_Tris[i++]	=	1 + 8;
		m_Tris[i++]	=	5 + 8;
		m_Tris[i++]	=	7 + 8;
	
		m_Tris[i++]	=	7 + 8;
		m_Tris[i++]	=	3 + 8;
		m_Tris[i++]	=	1 + 8;
		}

	if (horizontals) {
	
		m_Tris[i++]	=	0;
		m_Tris[i++]	=	1;
		m_Tris[i++]	=	0 + 8;
	
		m_Tris[i++]	=	1 + 8;
		m_Tris[i++]	=	0 + 8;
		m_Tris[i++]	=	1;

		m_Tris[i++]	=	0     + 2;
		m_Tris[i++]	=	1     + 2;
		m_Tris[i++]	=	0 + 8 + 2;
	
		m_Tris[i++]	=	1 + 8 + 2;
		m_Tris[i++]	=	0 + 8 + 2;
		m_Tris[i++]	=	1     + 2;

		m_Tris[i++]	=	0         + 4;
		m_Tris[i++]	=	1         + 4;
		m_Tris[i++]	=	0 + 8     + 4;
	
		m_Tris[i++]	=	1 + 8     + 4;
		m_Tris[i++]	=	0 + 8     + 4;
		m_Tris[i++]	=	1         + 4;

		m_Tris[i++]	=	0     + 2 + 4;
		m_Tris[i++]	=	1     + 2 + 4;
		m_Tris[i++]	=	0 + 8 + 2 + 4;
	
		m_Tris[i++]	=	1 + 8 + 2 + 4;
		m_Tris[i++]	=	0 + 8 + 2 + 4;
		m_Tris[i++]	=	1     + 2 + 4;
		}
	
	if (verticals) {
	
		m_Tris[i++]	=	 0;
		m_Tris[i++]	=	 2;
		m_Tris[i++]	=	 8;
	
		m_Tris[i++]	=	10;
		m_Tris[i++]	=	 8;
		m_Tris[i++]	=	 2;

		m_Tris[i++]	=	 1;
		m_Tris[i++]	=	 3;
		m_Tris[i++]	=	 9;
	
		m_Tris[i++]	=	11;
		m_Tris[i++]	=	 9;
		m_Tris[i++]	=	 3;

		m_Tris[i++]	=	 4;
		m_Tris[i++]	=	 6;
		m_Tris[i++]	=	12;
	
		m_Tris[i++]	=	14;
		m_Tris[i++]	=	12;
		m_Tris[i++]	=	 6;

		m_Tris[i++]	=	 5;
		m_Tris[i++]	=	 7;
		m_Tris[i++]	=	13;
	
		m_Tris[i++]	=	15;
		m_Tris[i++]	=	13;
		m_Tris[i++]	=	 7;
		}

	if (depths) {
	
		m_Tris[i++]	=	 0;
		m_Tris[i++]	=	 4;
		m_Tris[i++]	=	 8;
	
		m_Tris[i++]	=	12;
		m_Tris[i++]	=	 8;
		m_Tris[i++]	=	 4;

		m_Tris[i++]	=	 1;
		m_Tris[i++]	=	 5;
		m_Tris[i++]	=	 9;
	
		m_Tris[i++]	=	13;
		m_Tris[i++]	=	 9;
		m_Tris[i++]	=	 5;

		m_Tris[i++]	=	 0 + 2;
		m_Tris[i++]	=	 4 + 2;
		m_Tris[i++]	=	 8 + 2;
	
		m_Tris[i++]	=	12 + 2;
		m_Tris[i++]	=	 8 + 2;
		m_Tris[i++]	=	 4 + 2;

		m_Tris[i++]	=	 1 + 2;
		m_Tris[i++]	=	 5 + 2;
		m_Tris[i++]	=	 9 + 2;
	
		m_Tris[i++]	=	13 + 2;
		m_Tris[i++]	=	 9 + 2;
		m_Tris[i++]	=	 5 + 2;
		}

	if (zonks) {
	
		m_Tris[i++]	=	 0;
		m_Tris[i++]	=	 8;
		m_Tris[i++]	=	 1;
	
		m_Tris[i++]	=	 9;
		m_Tris[i++]	=	 1;
		m_Tris[i++]	=	 8;

		m_Tris[i++]	=	 2;
		m_Tris[i++]	=	10;
		m_Tris[i++]	=	 3;
	
		m_Tris[i++]	=	11;
		m_Tris[i++]	=	 3;
		m_Tris[i++]	=	10;

		m_Tris[i++]	=	 4;
		m_Tris[i++]	=	12;
		m_Tris[i++]	=	 5;
	
		m_Tris[i++]	=	13;
		m_Tris[i++]	=	 5;
		m_Tris[i++]	=	12;

		m_Tris[i++]	=	 6;
		m_Tris[i++]	=	14;
		m_Tris[i++]	=	 7;
	
		m_Tris[i++]	=	15;
		m_Tris[i++]	=	 7;
		m_Tris[i++]	=	14;
	
		}


	Touch();
	ConvertTouch();
	}

void	dxo_4d_obj::Rot(int which, oe_scalar theta, dxo_4d_obj* dst)
	{
	if (which < 0 || which > 9)
		return;

	long		i, inum;
	oe_scalar	s, c;

	if (dst == NULL)
		dst	=	this;

	if (dst -> m_VrtsNum != m_VrtsNum)
		return;

	s	=	sin(theta);
	c	=	cos(theta);

	switch (which) {

		/////////////////////////////////////////////////

		case	OE_X:
			inum	=	m_VrtsNum;
			for (i = 0; i < inum; i++) {
				m_Vrts[i].RotX(theta, dst -> m_Vrts[i]);
				m_Nrms[i].RotX(theta, dst -> m_Nrms[i]);
				}
			break;
		case	OE_Y:
			inum	=	m_VrtsNum;
			for (i = 0; i < inum; i++) {
				m_Vrts[i].RotY(theta, dst -> m_Vrts[i]);
				m_Nrms[i].RotY(theta, dst -> m_Nrms[i]);
				}
			break;
		case	OE_Z:
			inum	=	m_VrtsNum;
			for (i = 0; i < inum; i++) {
				m_Vrts[i].RotZ(theta, dst -> m_Vrts[i]);
				m_Nrms[i].RotZ(theta, dst -> m_Nrms[i]);
				}
			break;
		case	OE_W:
			inum	=	m_VrtsNum;
			for (i = 0; i < inum; i++) {
				m_Vrts[i].RotW(theta, dst -> m_Vrts[i]);
				m_Nrms[i].RotW(theta, dst -> m_Nrms[i]);
				}
			break;

		/////////////////////////////////////////////////

		case	OE_YX:
			inum	=	m_VrtsNum;
			for (i = 0; i < inum; i++) {
				m_Vrts[i].RotYX(s, c, dst -> m_Vrts[i]);
				m_Nrms[i].RotYX(s, c, dst -> m_Nrms[i]);
				}
			break;
		case	OE_ZX:
			inum	=	m_VrtsNum;
			for (i = 0; i < inum; i++) {
				m_Vrts[i].RotZX(s, c, dst -> m_Vrts[i]);
				m_Nrms[i].RotZX(s, c, dst -> m_Nrms[i]);
				}
			break;
		case	OE_YZ:
			inum	=	m_VrtsNum;
			for (i = 0; i < inum; i++) {
				m_Vrts[i].RotYZ(s, c, dst -> m_Vrts[i]);
				m_Nrms[i].RotYZ(s, c, dst -> m_Nrms[i]);
				}
			break;
		case	OE_WX:
			inum	=	m_VrtsNum;
			for (i = 0; i < inum; i++) {
				m_Vrts[i].RotWX(s, c, dst -> m_Vrts[i]);
				m_Nrms[i].RotWX(s, c, dst -> m_Nrms[i]);
				}
			break;
		case	OE_WY:
			inum	=	m_VrtsNum;
			for (i = 0; i < inum; i++) {
				m_Vrts[i].RotWY(s, c, dst -> m_Vrts[i]);
				m_Nrms[i].RotWY(s, c, dst -> m_Nrms[i]);
				}
			break;
		case	OE_WZ:
			inum	=	m_VrtsNum;
			for (i = 0; i < inum; i++) {
				m_Vrts[i].RotWZ(s, c, dst -> m_Vrts[i]);
				m_Nrms[i].RotWZ(s, c, dst -> m_Nrms[i]);
				}
			break;
		}

	Touch();
	}

void	dxo_4d_obj::SetFillType	(int style, int conversion)
	{
	m_FillStyle			=	style;
	m_ConvertStyle		=	conversion;
	m_ConvertTouched	=	TRUE;
	}

// convert triangle data to line data.
// we know we have twice the number of line indices as triangle indices.
void	dxo_4d_obj::Convert(int conversion)
	{
	int	t;
	int	i;		

	m_LinsNum	=	0;

	for (t = 0; t < m_TrisNum; t++) {
		i	=	t * 3;
		switch (conversion) {
			case OE_CONVERT_1:
				m_Lins[m_LinsNum++] = m_Tris[i    ];
				m_Lins[m_LinsNum++] = m_Tris[i + 1];
				break;
			case OE_CONVERT_2:
				m_Lins[m_LinsNum++] = m_Tris[i + 1];
				m_Lins[m_LinsNum++] = m_Tris[i + 2];
				break;
			case OE_CONVERT_3:
				m_Lins[m_LinsNum++] = m_Tris[i + 2];
				m_Lins[m_LinsNum++] = m_Tris[i    ];
				break;
			case OE_CONVERT_12:
				m_Lins[m_LinsNum++] = m_Tris[i    ];
				m_Lins[m_LinsNum++] = m_Tris[i + 1];
				m_Lins[m_LinsNum++] = m_Tris[i + 1];
				m_Lins[m_LinsNum++] = m_Tris[i + 2];
				break;
			case OE_CONVERT_23:
				m_Lins[m_LinsNum++] = m_Tris[i + 1];
				m_Lins[m_LinsNum++] = m_Tris[i + 2];
				m_Lins[m_LinsNum++] = m_Tris[i + 2];
				m_Lins[m_LinsNum++] = m_Tris[i    ];
				break;
			case OE_CONVERT_13:
				m_Lins[m_LinsNum++] = m_Tris[i    ];
				m_Lins[m_LinsNum++] = m_Tris[i + 1];
				m_Lins[m_LinsNum++] = m_Tris[i + 1];
				m_Lins[m_LinsNum++] = m_Tris[i + 2];
				break;
			case OE_CONVERT_123:
				m_Lins[m_LinsNum++] = m_Tris[i    ];
				m_Lins[m_LinsNum++] = m_Tris[i + 1];
				m_Lins[m_LinsNum++] = m_Tris[i + 1];
				m_Lins[m_LinsNum++] = m_Tris[i + 2];
				m_Lins[m_LinsNum++] = m_Tris[i + 2];
				m_Lins[m_LinsNum++] = m_Tris[i    ];
				break;
			}
		}
	m_LinsNum /= 2;

	m_ConvertTouched	=	FALSE;
	}

void	dxo_4d_obj::Untouch()
	{
	if (m_Touched) {
		MakeD3D();
		m_Touched			=	FALSE;
		}

	if (m_ConvertTouched) {
		Convert(m_ConvertStyle);
		m_ConvertTouched	=	FALSE;
		}
	}




/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/
/*** EOF EOF EOF ***/

