// 4dDlg.cpp : implementation file
//

#include "stdafx.h"
#include "4d.h"
#include "4dDlg.h"
#include "DumbDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	OE_RANDOM() (oe_scalar(rand() % 20000) / 20000.0f)

/////////////////////////////////////////////////////////////////////////////
// CMy4dDlg dialog

CMy4dDlg::CMy4dDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMy4dDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMy4dDlg)
	//}}AFX_DATA_INIT
	m_hIcon		=	AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_Quit		=	FALSE;
	m_SetTrip	=	FALSE;
	m_WasMax	=	FALSE;
}

void CMy4dDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMy4dDlg)
	DDX_Control(pDX, IDC_CHECK8, m_Check8);
	DDX_Control(pDX, IDC_CHECK7, m_Check7);
	DDX_Control(pDX, IDC_CHECK6, m_Check6);
	DDX_Control(pDX, IDC_SLIDER2, m_Slider2);
	DDX_Control(pDX, IDC_LKJFLEJE, m_lkwjelkjwe);
	DDX_Control(pDX, IDC_SLIDER1, m_Slider1);
	DDX_Control(pDX, IDC_CHECK5, m_Check5);
	DDX_Control(pDX, IDC_CHECK4, m_Check4);
	DDX_Control(pDX, IDC_CHECK3, m_Check3);
	DDX_Control(pDX, IDC_CHECK2, m_Check2);
	DDX_Control(pDX, IDC_CHECK1, m_Check1);
	DDX_Control(pDX, IDC_EDIT6, m_Edit6);
	DDX_Control(pDX, IDC_EDIT5, m_Edit5);
	DDX_Control(pDX, IDC_EDIT4, m_Edit4);
	DDX_Control(pDX, IDC_EDIT3, m_Edit3);
	DDX_Control(pDX, IDC_EDIT2, m_Edit2);
	DDX_Control(pDX, IDC_EDIT1, m_Edit1);
	DDX_Control(pDX, IDC_YOYOYO, m_YoYoYo);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMy4dDlg, CDialog)
	//{{AFX_MSG_MAP(CMy4dDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_YOYOYO, OnYoyoyo)
	ON_BN_CLICKED(IDC_LKJFLEJE, OnLkjfleje)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_CHECK1, OnChangedSomeGoddamThing)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_WM_SIZE()
	ON_WM_CAPTURECHANGED()
	ON_BN_CLICKED(IDC_CHECK2, OnChangedSomeGoddamThing)
	ON_BN_CLICKED(IDC_CHECK3, OnChangedSomeGoddamThing)
	ON_BN_CLICKED(IDC_CHECK4, OnChangedSomeGoddamThing)
	ON_BN_CLICKED(IDC_CHECK5, OnChangedSomeGoddamThing)
	ON_BN_CLICKED(IDC_CHECK6, OnChangedSomeGoddamThing)
	ON_BN_CLICKED(IDC_CHECK8, OnChangedSomeGoddamThing)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy4dDlg message handlers

BOOL CMy4dDlg::OnInitDialog()
{
	CDialog::OnInitDialog	();

	SetIcon					(m_hIcon, TRUE);			// Set big icon
	SetIcon					(m_hIcon, FALSE);		// Set small icon
		
	m_Check1	.SetCheck		(1);
	m_Check2	.SetCheck		(1);
	m_Check3	.SetCheck		(1);
	m_Check4	.SetCheck		(1);
	m_Check5	.SetCheck		(1);
	m_Check6	.SetCheck		(1);
	m_Check7	.SetCheck		(1);
	m_Check8	.SetCheck		(1);
	m_Slider1	.SetPos			(25);
	m_Slider2	.SetPos			(0);
	
	m_dxo_d3dx	.InitD3DX		(m_YoYoYo.m_hWnd);
	m_4dObj1	.MakeCube		(1, 1, 1, 1, 1, 1, TRUE);
//	m_4dObj1	.SetFillType	(OE_FILL_LINE, OE_CONVERT_1);
	m_4dObj1	.SetFillType	(OE_FILL_SOLID , OE_CONVERT_1);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMy4dDlg::OnClose() 
{
	CDialog::OnClose();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMy4dDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CMy4dDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMy4dDlg::OnYoyoyo() 
{
	static	int		i = 0;
			char	s[20];

	i++;

	sprintf(s, "%d", i);

	SetWindowText(s);

}

void CMy4dDlg::OnOK() 
{
//	m_Quit	=	TRUE;
//	CDialog::OnOK();
}

void CMy4dDlg::OnCancel() 
{
	m_Quit	=	TRUE;
	CDialog::OnCancel();
}

void CMy4dDlg::OnLkjfleje() 
	{
	DumbDialog dd;

	dd.DoModal();
	}

void CMy4dDlg::Pulse()
	{
	char		s[32];
	oe_scalar	r1, r2, r3, r4, r5, r6;
	float		fog1;

	m_Edit1.GetWindowText(s, 31);
	r1		=	atof(s);

	m_Edit2.GetWindowText(s, 31);
	r2		=	atof(s);

	m_Edit3.GetWindowText(s, 31);
	r3		=	atof(s);

	m_Edit4.GetWindowText(s, 31);
	r4		=	atof(s);

	m_Edit5.GetWindowText(s, 31);
	r5		=	atof(s);

	m_Edit6.GetWindowText(s, 31);
	r6		=	atof(s);

	fog1	=	1.0f - (float)m_Slider1.GetPos() * 0.01f;

	if (fog1 < 1.0f) {
		float	fStart;
		float	fEnd;

		fStart	=	12.0f;
		fEnd	=	fog1 * 20.0f + fStart;

		m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGENABLE		, TRUE);
		m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGCOLOR		, D3DRGBA(1.0f, 1.0f, 1.0f, 0.0f));
		m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGTABLEMODE	, D3DFOG_NONE);
		m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGVERTEXMODE	, D3DFOG_LINEAR);
		m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGSTART		, *(DWORD *)(&fStart));
		m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGEND		, *(DWORD *)(&fEnd	));
		}
	else {
		m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGENABLE		, FALSE);
		}

	m_4dObj1	.Rot				(OE_XY, r4 * OE_DEG_TO_RAD);
	m_4dObj1	.Rot				(OE_ZX, r5 * OE_DEG_TO_RAD);
	m_4dObj1	.Rot				(OE_YZ, r6 * OE_DEG_TO_RAD);
	m_4dObj1	.Rot				(OE_WX, r1 * OE_DEG_TO_RAD);
	m_4dObj1	.Rot				(OE_WY, r2 * OE_DEG_TO_RAD);
	m_4dObj1	.Rot				(OE_WZ, r3 * OE_DEG_TO_RAD);


    D3DLIGHT7 d3dLight;
    ZeroMemory(&d3dLight, sizeof(d3dLight));

    d3dLight.dltType			= D3DLIGHT_DIRECTIONAL;
    d3dLight.dcvDiffuse		.r	=  0.0f;
    d3dLight.dcvDiffuse		.g	=  2.0f;
    d3dLight.dcvDiffuse		.b	=  2.0f;
    d3dLight.dcvDiffuse		.a	=  0.0f;
    d3dLight.dcvSpecular	.r	=  1.0f;
    d3dLight.dcvSpecular	.g	=  1.0f;
    d3dLight.dcvSpecular	.b	=  1.0f;
    d3dLight.dcvSpecular	.a	=  0.0f;
    d3dLight.dvDirection	.x	=  0.7f;
    d3dLight.dvDirection	.y	= -0.1f;
    d3dLight.dvDirection	.z	=  0.1f;

	m_dxo_d3dx.m_pD3DDev ->	LightEnable	(0, m_Check7.GetCheck() & 3);

    m_dxo_d3dx.m_pD3DDev ->	SetLight	(0, &d3dLight);


    //
    // Create material
    //

    D3DMATERIAL7 d3dMaterial;
    ZeroMemory(&d3dMaterial, sizeof(d3dMaterial));

    d3dMaterial.dcvDiffuse	.r	= 2.0f;
    d3dMaterial.dcvDiffuse	.g	= 2.0f;
    d3dMaterial.dcvDiffuse	.b	= 2.0f;
    d3dMaterial.dcvDiffuse	.a	= 0.0f;
    d3dMaterial.dcvAmbient	.r	= 0.0f;
    d3dMaterial.dcvAmbient	.g	= 0.0f;
    d3dMaterial.dcvAmbient	.b	= 0.0f;
    d3dMaterial.dcvSpecular	.r	= 0.5f;
    d3dMaterial.dcvSpecular	.g	= 0.5f;
    d3dMaterial.dcvSpecular	.b	= 0.5f;
    d3dMaterial.dcvSpecular	.a	= 0.5f;
    d3dMaterial.dvPower			= 10.0f;


    m_dxo_d3dx.m_pD3DDev ->	SetMaterial(&d3dMaterial);

	m_dxo_d3dx	.SceneBegin			();
	m_dxo_d3dx	.Draw_dxo_4d_obj	(&m_4dObj1);
	m_dxo_d3dx	.SceneEnd			();
	}

void CMy4dDlg::OnChangedSomeGoddamThing() 
{
	BOOL	c1, c2, h, v, d, w;

	c1	=	m_Check1.GetCheck() & 3;
	c2	=	m_Check2.GetCheck() & 3;
	h	=	m_Check3.GetCheck() & 3;
	v	=	m_Check4.GetCheck() & 3;
	d	=	m_Check5.GetCheck() & 3;
	w	=	m_Check8.GetCheck() & 3;

	m_4dObj1.MakeCube(c1, c2, h, v, d, w);
//	Randomize(&m_4dObj1);


	if (m_Check6.GetCheck() & 3)
		m_4dObj1.SetFillType(OE_FILL_SOLID);
	else
		m_4dObj1.SetFillType(OE_FILL_LINE);

}

void CMy4dDlg::OnButton1() 
{
	BOOL	c1, c2, h, v, d, w;

	c1	=	m_Check1.GetCheck() & 3;
	c2	=	m_Check2.GetCheck() & 3;
	h	=	m_Check3.GetCheck() & 3;
	v	=	m_Check4.GetCheck() & 3;
	d	=	m_Check5.GetCheck() & 3;
	w	=	m_Check8.GetCheck() & 3;

	m_4dObj1.MakeCube(c1, c2, h, v, d, w, TRUE);
	Randomize(&m_4dObj1);

}


void	CMy4dDlg::Randomize(dxo_4d_obj* obj)
	{
	int			i, inum;
	oe_scalar	r;

	i		=	m_Slider2.GetPos();
	r		=	(oe_scalar)i * .01f * .3f;

	inum	=	obj	-> m_VrtsNum;
	for (i = 0; i < inum; i++) {
		obj -> m_Vrts[i].m_Value[0]	+=	(OE_RANDOM()*2.0f - 1.0f) * r;
		obj -> m_Vrts[i].m_Value[1]	+=	(OE_RANDOM()*2.0f - 1.0f) * r;
		obj -> m_Vrts[i].m_Value[2]	+=	(OE_RANDOM()*2.0f - 1.0f) * r;
		}

	}

void CMy4dDlg::Fog() 
	{
	static	on	=	false;
	float	fStart;
	float	fEnd;

	fStart	=	8.0f;
	fEnd	=	26.0f;

	on		=	!on;

	m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGENABLE		, on);
	m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGCOLOR		, D3DRGBA(1.0f, 1.0f, 1.0f, 0.0f));
	m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGVERTEXMODE	, D3DFOG_LINEAR);
	m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGSTART		, *(DWORD *)(&fStart));
	m_dxo_d3dx.m_pD3DDev -> SetRenderState(D3DRENDERSTATE_FOGEND		, *(DWORD *)(&fEnd	));
	}




void CMy4dDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

	if (!m_YoYoYo.GetSafeHwnd())
		return;

	m_YoYoYo		.SetWindowPos(NULL, 0, 0, cx, cy - 73, SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER);

	m_lkwjelkjwe	.SetWindowPos(NULL, cx / 2 - 198, 2, 0, 0, SWP_NOSIZE | SWP_NOACTIVATE | SWP_NOZORDER);
}


void CMy4dDlg::OnCaptureChanged(CWnd *pWnd) 
{
	CDialog::OnCaptureChanged(pWnd);

	if (m_SetTrip) {
		m_dxo_d3dx.ReleaseD3DX();
		m_dxo_d3dx.InitD3DX(m_YoYoYo.m_hWnd);
		m_SetTrip	=	FALSE;
		}
}


